/*
 * Decompiled with CFR 0.152.
 */
package de.vonloesch.pdf4eclipse.model.jpedal;

import de.vonloesch.pdf4eclipse.model.IPDFDestination;
import de.vonloesch.pdf4eclipse.model.IPDFLinkAnnotation;
import de.vonloesch.pdf4eclipse.model.jpedal.JPedalPDFDestination;
import java.awt.geom.Rectangle2D;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class JPedalPDFLinkAnnotation
implements IPDFLinkAnnotation {
    FormObject annotObj;
    PdfDecoder decoder;
    Rectangle2D r;

    public JPedalPDFLinkAnnotation(FormObject annotObj, PdfDecoder decoder) {
        this.annotObj = annotObj;
        this.decoder = decoder;
    }

    @Override
    public Rectangle2D getPosition() {
        if (this.r == null) {
            float[] coords = this.annotObj.getFloatArray(573911876);
            float x = coords[0];
            float w = coords[2] - coords[0];
            float y = coords[1];
            float h = coords[3] - coords[1];
            this.r = new Rectangle2D.Float(x, y, w, h);
        }
        return this.r;
    }

    @Override
    public IPDFDestination getDestination() {
        PdfObject aData = this.annotObj.getDictionary(17);
        if (aData == null) {
            aData = this.annotObj;
        }
        if (aData.getNameAsConstant(35) == 2433561) {
            String text = aData.getTextStreamValue(2433561);
            return new JPedalPDFDestination(text);
        }
        PdfArrayIterator destIt = aData.getMixedArray(339034948);
        String ref = this.decoder.getIO().convertNameToRef(destIt.getNextValueAsString(false));
        if (ref != null) {
            aData = new OutlineObject(ref);
            this.decoder.getIO().readObject(aData);
            destIt = aData.getMixedArray(339034948);
        }
        return new JPedalPDFDestination(aData);
    }
}

