/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadPoolManagementAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContext;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextHolder;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextMemento;
import de.rcenvironment.toolkit.modules.concurrency.setup.ConcurrencyModuleConfiguration;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionContributor;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionRegistry;
import de.rcenvironment.toolkit.utils.internal.StringUtils;
import de.rcenvironment.toolkit.utils.text.TextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.impl.BufferingTextLinesReceiver;
import de.rcenvironment.toolkit.utils.text.impl.MultiLineOutputWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AsyncTaskServiceImpl
implements AsyncTaskService,
ThreadPoolManagementAccess {
    @Deprecated
    private static final String SYSTEM_PROPERTY_USE_70x_THREAD_POOL_CONFIGURATION = "rce.threadpool.use70xBehavior";
    private static final int DEFAULT_COMMON_THREAD_POOL_SIZE = 512;
    private static final String DEFAULT_THREAD_NAME_PREFIX = "ToolkitThreadPool-";
    private static final long IDLE_THREAD_RELEASE_TIME_SECONDS = 60L;
    private static final int NUM_THREADS_FOR_SCHEDULED_TASKS = 4;
    private static final float NANOS_TO_MSEC_RATIO = 1000000.0f;
    private volatile ExecutorService executorService;
    private AtomicInteger poolIndex = new AtomicInteger(0);
    private AtomicInteger threadIndex = new AtomicInteger(0);
    private ThreadGroup currentThreadGroup;
    private Map<Class<?>, StatisticsEntry> statisticsMap;
    private ScheduledExecutorService schedulerService;
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConcurrencyModuleConfiguration configuration;

    public AsyncTaskServiceImpl(ConcurrencyModuleConfiguration configuration, StatusCollectionRegistry statusCollectionRegistry) {
        this.configuration = configuration;
        this.initialize();
        statusCollectionRegistry.addContributor(new StatusCollectionContributor(){

            @Override
            public String getStandardDescription() {
                return "Asynchronous Tasks";
            }

            @Override
            public void printDefaultStateInformation(TextLinesReceiver receiver) {
                AsyncTaskServiceImpl.this.renderStatistics(false, true, receiver);
            }

            @Override
            public String getUnfinishedOperationsDescription() {
                return null;
            }

            @Override
            public void printUnfinishedOperationsInformation(TextLinesReceiver receiver) {
            }
        });
    }

    @Override
    public void execute(Runnable task) {
        this.execute(task, null);
    }

    @Override
    public void execute(Runnable task, String taskId) {
        try {
            this.getNullSafeExecutorService().execute(new WrappedRunnable(task, taskId));
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(task);
            throw e;
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    @Override
    public Future<?> submit(Runnable task, String taskId) {
        try {
            return this.getNullSafeExecutorService().submit(new WrappedRunnable(task, taskId));
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(task);
            throw e;
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.submit(task, null);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, String taskId) {
        try {
            return this.getNullSafeExecutorService().submit(new WrappedCallable<T>(task, taskId));
        }
        catch (RejectedExecutionException e) {
            this.logExecutionRejectedAfterShutdown(task);
            throw e;
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAfterDelay(Runnable runnable, long delayMsec) {
        return this.schedulerService.schedule(new WrappedRunnable(runnable, null), delayMsec, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> ScheduledFuture<T> scheduleAfterDelay(Callable<T> callable, long delayMsec) {
        return this.schedulerService.schedule(new WrappedCallable<T>(callable, null), delayMsec, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long repetitionDelayMsec) {
        return this.scheduleAtFixedRateAfterDelay(runnable, repetitionDelayMsec, repetitionDelayMsec);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRateAfterDelay(Runnable runnable, long initialDelayMsec, long repetitionDelayMsec) {
        return this.schedulerService.scheduleAtFixedRate(new WrappedRunnable(runnable, null), initialDelayMsec, repetitionDelayMsec, TimeUnit.MILLISECONDS);
    }

    @Override
    public int shutdown() {
        this.log.debug((Object)"Shutting down thread pool");
        List<Runnable> queued = this.executorService.shutdownNow();
        this.executorService = null;
        this.schedulerService.shutdown();
        this.schedulerService = null;
        return queued.size();
    }

    @Override
    public int reset() {
        int unfinishedCount = this.shutdown();
        this.initialize();
        return unfinishedCount;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.currentThreadGroup.activeCount();
    }

    @Override
    public String getFormattedStatistics(boolean addTaskIds) {
        return this.getFormattedStatistics(addTaskIds, true);
    }

    @Override
    public String getFormattedStatistics(boolean addTaskIds, boolean includeInactive) {
        BufferingTextLinesReceiver lineBuffer = new BufferingTextLinesReceiver();
        this.renderStatistics(addTaskIds, includeInactive, lineBuffer);
        return new MultiLineOutputWrapper(lineBuffer.getCollectedLines()).asMultilineString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderStatistics(boolean addTaskIds, boolean includeInactive, TextLinesReceiver receiver) {
        StringBuilder lineBuffer = new StringBuilder(512);
        TreeMap<String, StatisticsEntry> sortedMap = new TreeMap<String, StatisticsEntry>();
        Map<Class<?>, StatisticsEntry> map = this.statisticsMap;
        synchronized (map) {
            for (Map.Entry<Class<?>, StatisticsEntry> entry : this.statisticsMap.entrySet()) {
                StatisticsEntry statisticsEntry = entry.getValue();
                if (statisticsEntry.activeTasks == 0 && !includeInactive) continue;
                sortedMap.put(statisticsEntry.getTaskName(), statisticsEntry);
            }
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            StatisticsEntry statsEntry;
            String taskName = (String)entry.getKey();
            StatisticsEntry statisticsEntry = statsEntry = (StatisticsEntry)entry.getValue();
            synchronized (statisticsEntry) {
                receiver.addLine(taskName);
                lineBuffer.setLength(0);
                lineBuffer.append("    ");
                statsEntry.printFormatted(lineBuffer);
                receiver.addLine(lineBuffer.toString());
                if (addTaskIds) {
                    if (statsEntry.activeTaskIds != null && !statsEntry.activeTaskIds.isEmpty()) {
                        receiver.addLine("        Named tasks:");
                        lineBuffer.setLength(0);
                        for (Map.Entry entry2 : statsEntry.activeTaskIds.entrySet()) {
                            receiver.addLine(StringUtils.format("          %s [%s]", entry2.getKey(), ((Thread)entry2.getValue()).getName()));
                        }
                    }
                    if (statsEntry.anonymousTaskThreads != null && !statsEntry.anonymousTaskThreads.isEmpty()) {
                        receiver.addLine("        Anonymous task threads:");
                        for (Thread thread : statsEntry.anonymousTaskThreads) {
                            receiver.addLine(StringUtils.format("          [%s]", thread.getName()));
                        }
                    }
                }
            }
        }
    }

    private ExecutorService getNullSafeExecutorService() {
        if (this.executorService != null) {
            return this.executorService;
        }
        throw new RejectedExecutionException();
    }

    private void logExecutionRejectedAfterShutdown(Object task) {
        this.log.warn((Object)("Ignoring request to execute task of type " + task.getClass() + " as the thread pool has been shut down (java.util.concurrent.RejectedExecutionException)"));
    }

    private void initialize() {
        String mainPrefix = DEFAULT_THREAD_NAME_PREFIX;
        if (this.configuration.getThreadPoolName() != null) {
            mainPrefix = String.valueOf(this.configuration.getThreadPoolName()) + "-";
        }
        final ThreadGroup threadGroup = new ThreadGroup(String.valueOf(mainPrefix) + "ThreadGroup");
        final String threadNamePrefix = String.valueOf(mainPrefix) + this.poolIndex.incrementAndGet() + "-";
        this.threadIndex.set(0);
        this.currentThreadGroup = threadGroup;
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(threadGroup, r, String.valueOf(threadNamePrefix) + AsyncTaskServiceImpl.this.threadIndex.incrementAndGet());
            }
        };
        if (System.getProperty(SYSTEM_PROPERTY_USE_70x_THREAD_POOL_CONFIGURATION) == null) {
            int commonPoolSize = 512;
            if (this.configuration.getThreadPoolSize() > 0) {
                commonPoolSize = this.configuration.getThreadPoolSize();
            }
            this.log.debug((Object)("Setting maximum thread pool size to " + commonPoolSize));
            this.executorService = new ThreadPoolExecutor(commonPoolSize, commonPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            ((ThreadPoolExecutor)this.executorService).allowCoreThreadTimeOut(true);
            this.schedulerService = Executors.newScheduledThreadPool(4, threadFactory);
        } else {
            this.log.info((Object)"Using 7.0.x compatible thread pool configuration");
            this.executorService = Executors.newCachedThreadPool(threadFactory);
            this.schedulerService = Executors.newScheduledThreadPool(1, threadFactory);
        }
        this.statisticsMap = Collections.synchronizedMap(new HashMap());
        if (this.configuration.getPeriodicTaskLoggingIntervalMsec() > 0) {
            this.scheduleAtFixedRate(new Runnable(){

                @Override
                @TaskDescription(value="Thread pool debug logging")
                public void run() {
                    AsyncTaskServiceImpl.this.log.debug((Object)("Current combined thread pool size: " + AsyncTaskServiceImpl.this.getCurrentThreadCount() + "; Asynchronous tasks:\n" + AsyncTaskServiceImpl.this.getFormattedStatistics(false, true)));
                }
            }, this.configuration.getPeriodicTaskLoggingIntervalMsec());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticsEntry getStatisticsEntry(Class<?> r) {
        StatisticsEntry statisticsEntry = this.statisticsMap.get(r);
        if (statisticsEntry == null) {
            Map<Class<?>, StatisticsEntry> map = this.statisticsMap;
            synchronized (map) {
                statisticsEntry = this.statisticsMap.get(r);
                statisticsEntry = this.createEntryIfNotPresent(r, statisticsEntry);
            }
        }
        return statisticsEntry;
    }

    private StatisticsEntry createEntryIfNotPresent(Class<?> r, StatisticsEntry statisticsEntry) {
        if (statisticsEntry == null) {
            statisticsEntry = new StatisticsEntry(r);
            this.statisticsMap.put(r, statisticsEntry);
        }
        return statisticsEntry;
    }

    private final class StatisticsEntry {
        private int activeTasks;
        private int maxParallel;
        private int completedTasks;
        private int exceptionCount;
        private long maxNormalCompletionTime;
        private long totalCompletionTime;
        private Map<String, Thread> activeTaskIds;
        private Set<Thread> anonymousTaskThreads;
        private final Class<?> taskClass;
        private final String taskName;

        StatisticsEntry(Class<?> taskClass) {
            this.taskClass = taskClass;
            this.taskName = this.determineTaskName();
        }

        public String getTaskName() {
            return this.taskName;
        }

        private synchronized void beforeExecution(String taskId) {
            ++this.activeTasks;
            if (this.activeTasks > this.maxParallel) {
                this.maxParallel = this.activeTasks;
            }
            if (taskId != null) {
                Thread replaced;
                if (this.activeTaskIds == null) {
                    this.activeTaskIds = new HashMap<String, Thread>();
                }
                if ((replaced = this.activeTaskIds.put(taskId, Thread.currentThread())) != null) {
                    AsyncTaskServiceImpl.this.log.warn((Object)StringUtils.format("Task id '%s' used more than once for task '%s' (existing: %s, new: %s)", taskId, this.taskName, replaced.getName(), Thread.currentThread().getName()), (Throwable)new RuntimeException());
                }
            } else {
                if (this.anonymousTaskThreads == null) {
                    this.anonymousTaskThreads = new HashSet<Thread>();
                }
                if (!this.anonymousTaskThreads.add(Thread.currentThread())) {
                    AsyncTaskServiceImpl.this.log.error((Object)("Consistency error: Thread " + Thread.currentThread() + " is already in the set of active tasks"));
                }
            }
        }

        private synchronized void afterExecution(String taskId, long duration, boolean exception) {
            this.totalCompletionTime += duration;
            ++this.completedTasks;
            --this.activeTasks;
            if (taskId != null) {
                Thread removed;
                if (this.activeTaskIds == null) {
                    AsyncTaskServiceImpl.this.log.error((Object)"Consistency error: Non-null task id finished, but active set not initialized");
                    this.activeTaskIds = new HashMap<String, Thread>();
                }
                if ((removed = this.activeTaskIds.remove(taskId)) == null) {
                    AsyncTaskServiceImpl.this.log.warn((Object)StringUtils.format("No registered task id '%s' for task '%s'; was there an id collision before?", taskId, this.taskName));
                }
            } else if (!this.anonymousTaskThreads.remove(Thread.currentThread())) {
                AsyncTaskServiceImpl.this.log.error((Object)("Consistency error: Thread " + Thread.currentThread() + " was not in the set of active tasks"));
            }
            if (exception) {
                ++this.exceptionCount;
            } else if (duration > this.maxNormalCompletionTime) {
                this.maxNormalCompletionTime = duration;
            }
        }

        private void printFormatted(StringBuilder sb) {
            int numCompleted = this.completedTasks;
            int numActive = this.activeTasks;
            sb.append("Active: ");
            sb.append(numActive);
            sb.append(", Completed: ");
            sb.append(numCompleted);
            sb.append(", MaxParallel: ");
            sb.append(this.maxParallel);
            if (numCompleted > 0) {
                long totalTimeNanos = this.totalCompletionTime;
                float avgTimeMsec = (float)totalTimeNanos / 1000000.0f / (float)numCompleted;
                sb.append(", AvgTime: ");
                sb.append(avgTimeMsec);
                sb.append(" msec, Total: ");
                sb.append((float)totalTimeNanos / 1000000.0f);
                sb.append(" msec, MaxTime: ");
                sb.append((float)this.maxNormalCompletionTime / 1000000.0f);
                sb.append(" msec");
            }
            if (this.exceptionCount > 0) {
                sb.append(", Exceptions: ");
                sb.append(this.exceptionCount);
            }
        }

        private String determineTaskName() {
            Method runMethod;
            try {
                runMethod = this.taskClass.getMethod("run", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    runMethod = this.taskClass.getMethod("call", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new IllegalStateException("Task is neither Runnable nor Callable? " + this.taskClass.getClass());
                }
            }
            Annotation[] annotationArray = runMethod.getDeclaredAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType() == TaskDescription.class) {
                    return ((TaskDescription)annotation).value();
                }
                ++n2;
            }
            String taskClassName = this.taskClass.getName();
            boolean isAnonymousNestedTestClass = taskClassName.matches("^.*Test(s)?\\$(.*\\$)?\\d+$");
            if (!isAnonymousNestedTestClass) {
                AsyncTaskServiceImpl.this.log.warn((Object)("Thread pool task " + taskClassName + " should have a @TaskDescription"));
            }
            return "<" + this.taskClass.getName() + ">";
        }
    }

    private class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> innerCallable;
        private final String taskId;
        private final ThreadContext contextObject;

        WrappedCallable(Callable<T> callable, String taskId) {
            this.innerCallable = callable;
            this.taskId = taskId;
            this.contextObject = ThreadContextHolder.getCurrentContext();
        }

        @Override
        public T call() throws Exception {
            T result;
            ThreadContextMemento previousThreadContext = ThreadContextHolder.setCurrentContext(this.contextObject);
            StatisticsEntry statisticsEntry = AsyncTaskServiceImpl.this.getStatisticsEntry(this.innerCallable.getClass());
            long startTime = System.nanoTime();
            statisticsEntry.beforeExecution(this.taskId);
            boolean exception = false;
            try {
                try {
                    result = this.innerCallable.call();
                }
                catch (RuntimeException e) {
                    AsyncTaskServiceImpl.this.log.warn((Object)("Unhandled exception in Callable for task " + statisticsEntry.getTaskName()), (Throwable)e);
                    exception = true;
                    throw e;
                }
            }
            finally {
                long duration = System.nanoTime() - startTime;
                statisticsEntry.afterExecution(this.taskId, duration, exception);
                previousThreadContext.restore();
            }
            if (Thread.interrupted()) {
                AsyncTaskServiceImpl.this.log.debug((Object)StringUtils.format("Thread %s was interrupted after running task '%s', resetting flag", Thread.currentThread().getName(), statisticsEntry.getTaskName()));
            }
            return result;
        }
    }

    private final class WrappedRunnable
    implements Runnable {
        private final Runnable innerRunnable;
        private final String taskId;
        private final ThreadContext contextObject;

        WrappedRunnable(Runnable runnable, String taskId) {
            this.innerRunnable = runnable;
            this.taskId = taskId;
            this.contextObject = ThreadContextHolder.getCurrentContext();
        }

        @Override
        public void run() {
            ThreadContextMemento previousThreadContext = ThreadContextHolder.setCurrentContext(this.contextObject);
            StatisticsEntry statisticsEntry = AsyncTaskServiceImpl.this.getStatisticsEntry(this.innerRunnable.getClass());
            long startTime = System.nanoTime();
            statisticsEntry.beforeExecution(this.taskId);
            boolean exception = false;
            try {
                try {
                    this.innerRunnable.run();
                }
                catch (RuntimeException e) {
                    AsyncTaskServiceImpl.this.log.warn((Object)("Unhandled exception in Runnable for task " + statisticsEntry.getTaskName()), (Throwable)e);
                    exception = true;
                }
            }
            finally {
                long duration = System.nanoTime() - startTime;
                statisticsEntry.afterExecution(this.taskId, duration, exception);
                previousThreadContext.restore();
            }
            if (Thread.interrupted()) {
                AsyncTaskServiceImpl.this.log.debug((Object)StringUtils.format("Thread %s was interrupted after running task '%s', resetting flag", Thread.currentThread().getName(), statisticsEntry.getTaskName()));
            }
        }
    }
}

