/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.internal.AsyncOrderedExecutionQueueImpl;
import de.rcenvironment.toolkit.modules.concurrency.internal.ConcurrencyUtilsServiceHolder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncOrderedCallbackManagerImpl<T>
implements AsyncOrderedCallbackManager<T> {
    private final AsyncCallbackExceptionPolicy exceptionPolicy;
    private final Map<T, InternalAsyncOrderedCallbackQueue> listenerMap = new HashMap<T, InternalAsyncOrderedCallbackQueue>();
    private final Log log = LogFactory.getLog(this.getClass());
    private ConcurrencyUtilsServiceHolder internalServiceHolder;

    public AsyncOrderedCallbackManagerImpl(ConcurrencyUtilsServiceHolder internalServiceHolder, AsyncCallbackExceptionPolicy exceptionPolicy) {
        this(exceptionPolicy, internalServiceHolder);
    }

    public AsyncOrderedCallbackManagerImpl(AsyncCallbackExceptionPolicy exceptionPolicy, ConcurrencyUtilsServiceHolder internalServiceHolder) {
        this.internalServiceHolder = internalServiceHolder;
        this.exceptionPolicy = exceptionPolicy;
        if (exceptionPolicy != AsyncCallbackExceptionPolicy.LOG_AND_PROCEED && exceptionPolicy != AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER) {
            this.log.warn((Object)((Object)((Object)exceptionPolicy) + " policy not implemented yet"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(T listener) {
        Map<T, InternalAsyncOrderedCallbackQueue> map = this.listenerMap;
        synchronized (map) {
            this.listenerMap.put(listener, new InternalAsyncOrderedCallbackQueue(listener, this.exceptionPolicy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListenerAndEnqueueCallback(T listener, AsyncCallback<T> callback) {
        Map<T, InternalAsyncOrderedCallbackQueue> map = this.listenerMap;
        synchronized (map) {
            InternalAsyncOrderedCallbackQueue singleListenerQueue = new InternalAsyncOrderedCallbackQueue(listener, this.exceptionPolicy);
            this.listenerMap.put(listener, singleListenerQueue);
            singleListenerQueue.enqueue(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueCallback(AsyncCallback<T> callback) {
        Map<T, InternalAsyncOrderedCallbackQueue> map = this.listenerMap;
        synchronized (map) {
            for (InternalAsyncOrderedCallbackQueue wrappedListener : this.listenerMap.values()) {
                wrappedListener.enqueue(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(T listener) {
        Map<T, InternalAsyncOrderedCallbackQueue> map = this.listenerMap;
        synchronized (map) {
            this.listenerMap.remove(listener);
        }
    }

    private final class InternalAsyncOrderedCallbackQueue
    extends AsyncOrderedExecutionQueueImpl {
        private final T listener;

        private InternalAsyncOrderedCallbackQueue(T listener, AsyncCallbackExceptionPolicy exceptionPolicy) {
            super(exceptionPolicy, AsyncOrderedCallbackManagerImpl.this.internalServiceHolder);
            this.listener = listener;
        }

        private void enqueue(final AsyncCallback<T> callback) {
            super.enqueue(new Runnable(){

                @Override
                public void run() {
                    callback.performCallback(InternalAsyncOrderedCallbackQueue.this.listener);
                    AsyncOrderedCallbackManagerImpl.this.internalServiceHolder.getStatisticsTrackerService().getCounterCategory("AsyncOrderedExecutionQueue dispatch").count("Asynchronous callback");
                }
            });
        }
    }
}

