/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator;

import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileSystemOperations {
    private FileSystemOperations() {
    }

    public static void deleteSandboxDirectory(File directory) {
        File absoluteDirectory = directory.getAbsoluteFile();
        Log log = LogFactory.getLog(FileSystemOperations.class);
        DirectoryDeletionStats stats = new DirectoryDeletionStats();
        try {
            Files.walkFileTree(absoluteDirectory.toPath(), new FilesAndDirsDeletionFileVisitor(log, stats));
        }
        catch (IOException e) {
            log.error((Object)StringUtils.format((String)"Uncaught exception while trying to delete directory %s", (Object[])new Object[]{absoluteDirectory.toString()}), (Throwable)e);
        }
        if (!directory.exists()) {
            log.debug((Object)StringUtils.format((String)"Successfully deleted %s (which consisted of %d files, %d symbolic links, %d directories, %d junctions and %d files/directories of unknown type.)", (Object[])new Object[]{absoluteDirectory.toString(), stats.filesDeleted, stats.symlinksDeleted, stats.directoriesDeleted, stats.junctionsDeleted, stats.unknownDeleted}));
        } else {
            log.warn((Object)StringUtils.format((String)"Failed to fully delete directory %s (deleted %d files, %d symbolic links, %d directories %d junctions and %d files/directories of unknown type; encountered %d errors)", (Object[])new Object[]{absoluteDirectory.toString(), stats.filesDeleted, stats.symlinksDeleted, stats.directoriesDeleted, stats.junctionsDeleted, stats.unknownDeleted, stats.errors}));
        }
    }

    private static final class DirectoryDeletionStats {
        private int filesDeleted = 0;
        private int symlinksDeleted = 0;
        private int directoriesDeleted = 0;
        private int junctionsDeleted = 0;
        private int unknownDeleted = 0;
        private int errors = 0;

        private DirectoryDeletionStats() {
        }
    }

    private static final class FilesAndDirsDeletionFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Log log;
        private final DirectoryDeletionStats stats;

        private FilesAndDirsDeletionFileVisitor(Log log, DirectoryDeletionStats stats) {
            this.log = log;
            this.stats = stats;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (attrs.isRegularFile()) {
                try {
                    Files.delete(file);
                    DirectoryDeletionStats directoryDeletionStats = this.stats;
                    directoryDeletionStats.filesDeleted = directoryDeletionStats.filesDeleted + 1;
                }
                catch (IOException e) {
                    this.log.warn((Object)StringUtils.format((String)"Failed to delete %s: %s", (Object[])new Object[]{file.toString(), e.toString()}));
                    DirectoryDeletionStats directoryDeletionStats = this.stats;
                    directoryDeletionStats.errors = directoryDeletionStats.errors + 1;
                }
            } else if (attrs.isSymbolicLink()) {
                try {
                    this.log.debug((Object)StringUtils.format((String)"Deleting symbolic link %s", (Object[])new Object[]{file.toString()}));
                    Files.delete(file);
                    DirectoryDeletionStats directoryDeletionStats = this.stats;
                    directoryDeletionStats.symlinksDeleted = directoryDeletionStats.symlinksDeleted + 1;
                }
                catch (IOException e) {
                    this.log.warn((Object)StringUtils.format((String)"Failed to delete symbolic link %s: %s", (Object[])new Object[]{file.toString(), e.toString()}));
                    DirectoryDeletionStats directoryDeletionStats = this.stats;
                    directoryDeletionStats.errors = directoryDeletionStats.errors + 1;
                }
            } else {
                this.log.warn((Object)("Not deleting a file as it is neither a normal file nor a symbolic link: " + file.toString()));
                DirectoryDeletionStats directoryDeletionStats = this.stats;
                directoryDeletionStats.errors = directoryDeletionStats.errors + 1;
            }
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!attrs.isDirectory()) {
                this.log.warn((Object)("Unexpected type of directory (please examine manually): " + dir.toString()));
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (attrs.isOther()) {
                try {
                    this.log.debug((Object)StringUtils.format((String)"Deleting junction point %s", (Object[])new Object[]{dir.toString()}));
                    Files.delete(dir);
                    DirectoryDeletionStats directoryDeletionStats = this.stats;
                    directoryDeletionStats.junctionsDeleted = directoryDeletionStats.junctionsDeleted + 1;
                }
                catch (IOException e) {
                    this.log.warn((Object)StringUtils.format((String)"Failed to delete junction point %s: %s", (Object[])new Object[]{dir.toString(), e.toString()}));
                    DirectoryDeletionStats directoryDeletionStats = this.stats;
                    directoryDeletionStats.errors = directoryDeletionStats.errors + 1;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            try {
                Files.delete(dir);
                DirectoryDeletionStats directoryDeletionStats = this.stats;
                directoryDeletionStats.directoriesDeleted = directoryDeletionStats.directoriesDeleted + 1;
            }
            catch (DirectoryNotEmptyException directoryNotEmptyException) {
                this.log.warn((Object)StringUtils.format((String)"Cannot delete directory %s as it is not empty", (Object[])new Object[]{dir.toString()}));
            }
            return super.postVisitDirectory(dir, exc);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            try {
                this.log.debug((Object)StringUtils.format((String)"Deleting unknown type of file/directory %s (possibly a link/junction to a non-existing target)", (Object[])new Object[]{file.toString()}));
                Files.delete(file);
                DirectoryDeletionStats directoryDeletionStats = this.stats;
                directoryDeletionStats.unknownDeleted = directoryDeletionStats.unknownDeleted + 1;
            }
            catch (IOException e1) {
                this.log.warn((Object)StringUtils.format((String)"Failed to delete unknown type of file/directory %s: %s", (Object[])new Object[]{file.toString(), e1.toString()}));
                DirectoryDeletionStats directoryDeletionStats = this.stats;
                directoryDeletionStats.errors = directoryDeletionStats.errors + 1;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

