/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.textstream.receivers;

import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;

public class CapturingTextOutReceiver
implements TextOutputReceiver {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private StringBuilder buffer;
    private String endOfStreamSuffix;
    private String lineTerminator;

    public CapturingTextOutReceiver() {
        this(null, "\n", null);
    }

    public CapturingTextOutReceiver(String prefix, String lineTerminator, String endOfStreamSuffix) {
        this.lineTerminator = lineTerminator;
        this.endOfStreamSuffix = endOfStreamSuffix;
        this.buffer = new StringBuilder(1024);
        if (prefix != null) {
            this.buffer.append(prefix);
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public synchronized void onFinished() {
        if (this.endOfStreamSuffix != null) {
            this.buffer.append(this.endOfStreamSuffix);
        }
    }

    @Override
    public synchronized void onFatalError(Exception e) {
        this.buffer.append("Exception:");
        this.buffer.append(this.lineTerminator);
        this.buffer.append(e.toString());
    }

    @Override
    public synchronized void addOutput(String line) {
        this.buffer.append(line);
        this.buffer.append(this.lineTerminator);
    }

    public synchronized String getBufferedOutput() {
        return this.buffer.toString();
    }
}

