/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common;

import de.rcenvironment.core.utils.common.RestartSafeIncreasingValueGenerator;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;

public final class LogUtils {
    private static final String REMOTE_SERVICE_CALL_EXCEPTION_ID_PREFIX = "E#";
    private static final RestartSafeIncreasingValueGenerator sharedRestartSafeUniqueIdGenerator = new RestartSafeIncreasingValueGenerator();

    private LogUtils() {
    }

    public static String logErrorAndAssignUniqueMarker(Log log, String logMessage) {
        return LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker(log, logMessage, null);
    }

    public static String logExceptionWithStacktraceAndAssignUniqueMarker(Log log, String logMessage, Throwable throwable) {
        String errorId = LogUtils.generateNewErrorId();
        if (throwable != null) {
            log.error((Object)StringUtils.format("%s: %s:", errorId, logMessage), throwable);
        } else {
            log.error((Object)StringUtils.format("%s: %s", errorId, logMessage));
        }
        return errorId;
    }

    public static String logExceptionAsSingleLineAndAssignUniqueMarker(Log log, String logMessage, Throwable throwable) {
        String errorId = LogUtils.generateNewErrorId();
        if (throwable != null) {
            log.error((Object)StringUtils.format("%s: %s: %s", errorId, logMessage, throwable.toString()));
        } else {
            log.error((Object)StringUtils.format("%s: %s", errorId, logMessage));
        }
        return errorId;
    }

    private static String generateNewErrorId() {
        return REMOTE_SERVICE_CALL_EXCEPTION_ID_PREFIX + sharedRestartSafeUniqueIdGenerator.invalidateAndGet();
    }
}

