/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start;

import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.start.EclipseLogListener;
import de.rcenvironment.core.start.common.Instance;
import de.rcenvironment.core.start.common.InstanceRunner;
import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.toolkit.modules.introspection.api.StatusCollectionService;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Application
implements IApplication {
    private static final String STDOUT_MESSAGE_EARLY_STARTUP_COMPLETE = "Early startup complete, running main application";
    private final Log log = LogFactory.getLog(this.getClass());

    public Object start(IApplicationContext context) throws Exception {
        Platform.addLogListener((ILogListener)new EclipseLogListener());
        if (CommandLineArguments.hasConfigurationErrors()) {
            this.log.error((Object)"Error parsing command-line options; shutting down");
            return IApplication.EXIT_OK;
        }
        Instance.setHeadless((boolean)CommandLineArguments.isHeadlessModeRequested());
        Bundle currentBundle = FrameworkUtil.getBundle(this.getClass());
        if (currentBundle == null) {
            throw new IllegalStateException("Internal error: Failed to get launcher bundle");
        }
        this.log.debug((Object)("Running from common launcher bundle " + currentBundle));
        String instanceRunnerBundle = CommandLineArguments.isHeadlessModeRequested() ? "de.rcenvironment.core.start.headless" : "de.rcenvironment.core.start.gui";
        Bundle[] bundleArray = currentBundle.getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (instanceRunnerBundle.equals(bundle.getSymbolicName())) {
                this.log.debug((Object)("Starting specific launcher bundle " + bundle));
                bundle.start();
                break;
            }
            ++n2;
        }
        PrintStream sysOut = System.out;
        sysOut.println(STDOUT_MESSAGE_EARLY_STARTUP_COMPLETE);
        StatusCollectionService statusCollectionService = (StatusCollectionService)StaticToolkitHolder.getService(StatusCollectionService.class);
        this.log.debug((Object)statusCollectionService.getCollectedDefaultStateInformation().asMultilineString("Application state after early startup:", "  ", "\n", null));
        InstanceRunner instanceRunner = Instance.getInstanceRunner();
        int runnerResult = instanceRunner.run();
        this.log.debug((Object)("Main application shutdown complete, exit code: " + runnerResult));
        return runnerResult;
    }

    public void stop() {
        Instance.shutdown();
    }
}

