/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view;

import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowRunNodePart;
import de.rcenvironment.core.gui.workflow.view.ComponentRuntimeView;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkflowRunEditorContextMenuProvider
extends ContextMenuProvider {
    private final GraphicalViewer viewer;

    public WorkflowRunEditorContextMenuProvider(GraphicalViewer viewer) {
        super((EditPartViewer)viewer);
        this.viewer = viewer;
    }

    public void buildContextMenu(IMenuManager menu) {
        List selection = this.viewer.getSelectedEditParts();
        if (selection.size() == 0) {
            return;
        }
        WorkflowRunNodePart part = null;
        if (selection.get(0) instanceof WorkflowRunNodePart) {
            part = (WorkflowRunNodePart)selection.get(0);
        }
        if (part != null) {
            WorkflowExecutionInformation wfExeInfo = (WorkflowExecutionInformation)((WorkflowExecutionInformationPart)((WorkflowPart)part.getParent()).getParent()).getModel();
            WorkflowNode wfNode = (WorkflowNode)part.getModel();
            final ComponentExecutionInformation compExeInfo = wfExeInfo.getComponentExecutionInformation(wfNode.getIdentifier());
            IExtensionRegistry extReg = Platform.getExtensionRegistry();
            IConfigurationElement[] confElements = extReg.getConfigurationElementsFor("de.rcenvironment.core.gui.workflow.monitoring");
            IConfigurationElement[] viewConfElements = extReg.getConfigurationElementsFor("org.eclipse.ui.views");
            IConfigurationElement[] iConfigurationElementArray = confElements;
            int n = confElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement confElement = iConfigurationElementArray[n2];
                if (compExeInfo.getComponentIdentifier().startsWith(confElement.getAttribute("component"))) {
                    IConfigurationElement[] iConfigurationElementArray2 = viewConfElements;
                    int n3 = viewConfElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        final IConfigurationElement viewConfElement = iConfigurationElementArray2[n4];
                        if (viewConfElement.getAttribute("id").equals(confElement.getAttribute("view"))) {
                            menu.add((IAction)new Action(){

                                public String getText() {
                                    return viewConfElement.getAttribute("name");
                                }

                                public void run() {
                                    try {
                                        final IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewConfElement.getAttribute("class"), compExeInfo.getExecutionIdentifier(), 2);
                                        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                                            @Override
                                            @TaskDescription(value="Initialize component runtime view data")
                                            public void run() {
                                                ((ComponentRuntimeView)view).initializeData(compExeInfo);
                                                Display.getDefault().asyncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        ((ComponentRuntimeView)view).initializeView();
                                                    }
                                                });
                                            }
                                        });
                                        view.setFocus();
                                    }
                                    catch (PartInitException e) {
                                        throw new RuntimeException(e);
                                    }
                                    catch (InvalidRegistryObjectException e) {
                                        throw new RuntimeException(e);
                                    }
                                }

                                public boolean isEnabled() {
                                    List selection = WorkflowRunEditorContextMenuProvider.this.viewer.getSelectedEditParts();
                                    return selection.size() == 1 && selection.get(0).getClass() == WorkflowRunNodePart.class;
                                }
                            });
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }
}

