/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditor;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class WorkflowRunEditorAction
extends Action {
    private static File folder;
    private final WorkflowExecutionInformation wfExeInfo;

    public WorkflowRunEditorAction(WorkflowExecutionInformation wfExeInfo) {
        this.wfExeInfo = wfExeInfo;
    }

    private static File getFolder() {
        if (folder == null) {
            try {
                folder = TempFileServiceAccess.getInstance().createManagedTempDir();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return folder;
    }

    public void run() {
        IEditorPart editorPart;
        String filename = StringUtils.format((String)"%s.wfr", (Object[])new Object[]{this.wfExeInfo.getExecutionIdentifier()});
        File tempFile = new File(WorkflowRunEditorAction.getFolder(), filename);
        Path location = new Path(tempFile.getAbsolutePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getProject("External Files").getFile((IPath)location);
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(filename);
        try {
            editorPart = activePage.openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
        }
        catch (PartInitException e) {
            throw new RuntimeException(e);
        }
        if (!((WorkflowRunEditor)editorPart).isWorkflowExecutionInformationSet()) {
            ((WorkflowRunEditor)editorPart).setWorkflowExecutionInformation(this.wfExeInfo);
        }
    }
}

