/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.model.configuration.api.PlaceholdersMetaDataDefinition;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowPlaceholderHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.PlaceholderSortUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class WorkflowPageClearHistoryDialog
extends Dialog {
    private String title;
    private WorkflowPlaceholderHandler weph;
    private WorkflowDescription wd;
    private Map<String, String> guiNameToPlaceholder;
    private Tree componentPlaceholderTree;
    private Composite container;
    private Button deleteAllPasswordHistories;

    protected WorkflowPageClearHistoryDialog(Shell parentShell, String title, WorkflowPlaceholderHandler pd, WorkflowDescription workflowDescription) {
        super(parentShell);
        this.title = title;
        this.weph = pd;
        this.wd = workflowDescription;
        this.guiNameToPlaceholder = new HashMap<String, String>();
        this.setShellStyle(68720);
    }

    protected Control createDialogArea(final Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        this.container.setLayout((Layout)new GridLayout(1, false));
        GridData containergridData = new GridData(4, 4, true, true);
        this.container.setLayoutData((Object)containergridData);
        this.componentPlaceholderTree = new Tree(this.container, 34);
        this.componentPlaceholderTree.setLayoutData((Object)containergridData);
        this.componentPlaceholderTree.setHeaderVisible(false);
        this.componentPlaceholderTree.setLinesVisible(true);
        this.fillTree();
        this.componentPlaceholderTree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 20;
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final TreeItem treeItem = (TreeItem)e.item;
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeItem.getParent().getColumn(0).pack();
                    }
                });
            }
        };
        this.componentPlaceholderTree.addListener(18, listener);
        this.componentPlaceholderTree.addListener(17, listener);
        this.componentPlaceholderTree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                this.checkItems((TreeItem)event.item, ((TreeItem)event.item).getChecked());
            }

            private void checkItems(TreeItem item, boolean checked) {
                item.setChecked(checked);
                if (item.getItemCount() > 0) {
                    TreeItem[] treeItemArray = item.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem it = treeItemArray[n2];
                        this.checkItems(it, checked);
                        ++n2;
                    }
                }
            }
        });
        this.deleteAllPasswordHistories = new Button(this.container, 32);
        this.deleteAllPasswordHistories.setText("Delete ALL password histories");
        return this.container;
    }

    private void clearHistory(TreeItem itComp, String parent, boolean isGlobal) {
        for (WorkflowNode wn : this.wd.getWorkflowNodes()) {
            if (!wn.getComponentDescription().getName().equals(itComp.getParentItem().getText())) continue;
            this.weph.deletePlaceholderHistory(wn.getComponentDescription().getIdentifier(), this.guiNameToPlaceholder.get(itComp.getText()));
        }
    }

    private void fillTree() {
        TreeColumn column1 = new TreeColumn(this.componentPlaceholderTree, 16384);
        column1.setText("");
        Set componentTypesWithPlaceholder = this.weph.getIdentifiersOfPlaceholderContainingComponents();
        Object[] componentTypesWithPlaceholderArray = componentTypesWithPlaceholder.toArray(new String[componentTypesWithPlaceholder.size()]);
        Arrays.sort(componentTypesWithPlaceholderArray);
        Object[] objectArray = componentTypesWithPlaceholderArray;
        int n = componentTypesWithPlaceholderArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object componentID = objectArray[n2];
            TreeItem componentIDTreeItem = new TreeItem(this.componentPlaceholderTree, 0);
            String componentName = this.wd.getWorkflowNode((String)this.weph.getComponentInstances((String)componentID).get(0)).getComponentDescription().getName();
            componentIDTreeItem.setText(0, componentName);
            componentIDTreeItem.setImage(this.getImage(this.wd.getWorkflowNode((String)this.weph.getComponentInstances((String)componentID).get(0))));
            PlaceholdersMetaDataDefinition metaData = this.getPlaceholderAttributes(componentName);
            componentIDTreeItem.setExpanded(true);
            if (this.weph.getPlaceholderNameSetOfComponentID((String)componentID) != null) {
                List<String> globalPlaceholderOrder = PlaceholderSortUtils.getPlaceholderOrder(this.weph.getPlaceholderNameSetOfComponentID((String)componentID), metaData);
                if (globalPlaceholderOrder == null) {
                    globalPlaceholderOrder = new LinkedList<String>();
                }
                for (String componentPlaceholder : globalPlaceholderOrder) {
                    TreeItem compPHTreeItem = new TreeItem(componentIDTreeItem, 0);
                    String guiName = metaData.getGuiName(componentPlaceholder);
                    this.guiNameToPlaceholder.put(guiName, componentPlaceholder);
                    compPHTreeItem.setText(0, guiName);
                    compPHTreeItem.setExpanded(true);
                }
            }
            if (this.weph.getComponentInstances((String)componentID) != null) {
                List<String> instancesWithPlaceholder = this.weph.getComponentInstances((String)componentID);
                if ((instancesWithPlaceholder = PlaceholderSortUtils.sortInstancesWithPlaceholderByName(instancesWithPlaceholder, this.wd)) != null) {
                    String compInstances = instancesWithPlaceholder.get(0);
                    Set unsortedInstancePlaceholder = this.weph.getPlaceholderNameSetOfComponentInstance(compInstances);
                    List<String> sortedInstancePlaceholder = PlaceholderSortUtils.getPlaceholderOrder(unsortedInstancePlaceholder, metaData);
                    for (String instancePlaceholder : sortedInstancePlaceholder) {
                        TreeItem instancePHTreeItem = new TreeItem(componentIDTreeItem, 0);
                        String guiName = metaData.getGuiName(instancePlaceholder);
                        this.guiNameToPlaceholder.put(guiName, instancePlaceholder);
                        if (guiName != null) {
                            instancePHTreeItem.setText(0, guiName);
                        } else {
                            instancePHTreeItem.setText(0, instancePlaceholder);
                        }
                        instancePHTreeItem.setExpanded(true);
                    }
                }
            }
            ++n2;
        }
        column1.pack();
    }

    private PlaceholdersMetaDataDefinition getPlaceholderAttributes(String name) {
        for (WorkflowNode wn : this.wd.getWorkflowNodes()) {
            if (!wn.getComponentDescription().getName().equals(name)) continue;
            return wn.getComponentDescription().getConfigurationDescription().getComponentConfigurationDefinition().getPlaceholderMetaDataDefinition();
        }
        return null;
    }

    private Image getImage(WorkflowNode element) {
        byte[] icon = element.getComponentDescription().getIcon16();
        Image image = icon != null ? new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(icon)) : Activator.getInstance().getImageRegistry().get("de.rcenvironment.rce.icon.16");
        return image;
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it1 = treeItemArray[n2];
            this.expandItem(it1);
            ++n2;
        }
        this.getShell().pack();
        this.getShell().setSize(this.getShell().getSize().x, this.getShell().getSize().y + 30);
        this.componentPlaceholderTree.getColumn(0).setWidth(this.container.getSize().x - 10);
    }

    private void expandItem(TreeItem it1) {
        it1.setExpanded(true);
        if (it1.getItems().length > 0) {
            TreeItem[] treeItemArray = it1.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem it2 = treeItemArray[n2];
                this.expandItem(it2);
                ++n2;
            }
        }
    }

    protected void okPressed() {
        TreeItem[] treeItemArray = this.componentPlaceholderTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it = treeItemArray[n2];
            TreeItem[] treeItemArray2 = it.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem itComp = treeItemArray2[n4];
                if (itComp.getChecked()) {
                    this.clearHistory(itComp, it.getText(), true);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.deleteAllPasswordHistories.getSelection()) {
            this.weph.deleteAllPasswordHistories();
        }
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = Messages.clear;
        }
        return super.createButton(parent, id, label, defaultButton);
    }
}

