/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.execute.CheckboxLabelProvider;
import de.rcenvironment.core.gui.workflow.execute.ColorPalette;
import de.rcenvironment.core.gui.workflow.execute.Filter;
import de.rcenvironment.core.gui.workflow.execute.Messages;
import de.rcenvironment.core.gui.workflow.execute.NodeIdentifierConfigurationHelper;
import de.rcenvironment.core.gui.workflow.execute.TableBehaviour;
import de.rcenvironment.core.gui.workflow.execute.TableSortSelectionListener;
import de.rcenvironment.core.gui.workflow.execute.TargetNodeEditingSupport;
import de.rcenvironment.core.gui.workflow.execute.TreeBehaviour;
import de.rcenvironment.core.gui.workflow.execute.TreeContentProvider;
import de.rcenvironment.core.gui.workflow.execute.TreeNode;
import de.rcenvironment.core.gui.workflow.execute.WorkflowDescriptionContentProvider;
import de.rcenvironment.core.gui.workflow.execute.WorkflowNodeTargetPlatformLabelProvider;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

final class WorkflowPage
extends WizardPage {
    private static final String PLATFORM_DATA_PREFIX = "platform_index";
    private static final String FILTER = "Filter";
    private static final String ALL = "All";
    private static final int WIDTH_NAME_COLUMN = 200;
    private static final int WIDTH_BOX_COLUMN = 60;
    private static final int WIDTH_INSTANCE_COLUMN = 250;
    private static final int SCROLLBAR_CORRECTION = 16;
    private static final int TABLE_WIDTH = 510;
    private int tableHeight;
    private final WorkflowDescription workflowDescription;
    private final NodeIdentifierConfigurationHelper nodeIdConfigHelper;
    private WorkflowComposite workflowComposite;
    private TargetNodeEditingSupport editingSupport;
    private WorkflowNodeTargetPlatformLabelProvider targetNodeLabelProviderTree;
    private WorkflowNodeTargetPlatformLabelProvider targetNodeLabelProviderTable;
    private CheckboxLabelProvider checkboxProviderTree;
    private CheckboxLabelProvider checkboxProviderTable;
    private List<InstanceNodeSessionId> missingInstances;
    private TreeContentProvider treeContenProvider;
    private final LogicalNodeId localNodeId;
    private boolean tableViewActive = true;

    WorkflowPage(WorkflowDescription workflowDescription, NodeIdentifierConfigurationHelper exeHelper) {
        super(Messages.workflowPageName);
        this.workflowDescription = workflowDescription;
        this.setDescription(Messages.configure);
        this.nodeIdConfigHelper = exeHelper;
        this.setTitle(Messages.workflowPageTitle);
        for (WorkflowNode node : workflowDescription.getWorkflowNodes()) {
            node.setInit(false);
        }
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        PlatformService platformService = (PlatformService)serviceRegistryAccess.getService(PlatformService.class);
        this.localNodeId = platformService.getLocalDefaultLogicalNodeId();
    }

    public void dispose() {
        this.targetNodeLabelProviderTree.disposeRescources();
        this.targetNodeLabelProviderTable.disposeRescources();
        ColorPalette.getInstance().disposeColors();
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.workflowComposite = new WorkflowComposite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 485;
        parent.setLayoutData((Object)data);
        this.setControl((Control)this.workflowComposite);
        String workflowName = this.workflowDescription.getName();
        if (workflowName != null) {
            this.workflowComposite.workflowNameText.setText(workflowName);
        }
        this.workflowComposite.workflowNameText.setFocus();
        this.workflowComposite.workflowNameText.selectAll();
        this.workflowComposite.workflowNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String name = WorkflowPage.this.workflowComposite.workflowNameText.getText();
                if (name.isEmpty()) {
                    WorkflowPage.this.setPageComplete(true);
                } else {
                    WorkflowPage.this.setPageComplete(false);
                }
                WorkflowPage.this.workflowDescription.setName(name);
            }
        });
        this.setListenersForControllerInstanceCombo();
        this.refreshControllersTargetInstance();
        this.workflowComposite.componentsTableViewer.setContentProvider((IContentProvider)new WorkflowDescriptionContentProvider(128, "COLUMN_NAME"));
        this.workflowComposite.componentsTableViewer.setInput((Object)this.workflowDescription);
        this.workflowComposite.additionalInformationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkflowPage.this.workflowDescription.setAdditionalInformation(WorkflowPage.this.workflowComposite.additionalInformationText.getText());
            }
        });
        this.treeContenProvider = new TreeContentProvider();
        TableBehaviour.allCheckboxesClicked = false;
    }

    private void setListenersForControllerInstanceCombo() {
        this.workflowComposite.addListener(5, new Listener(){

            public void handleEvent(Event arg0) {
                WorkflowPage.this.refreshControllersTargetInstance();
            }
        });
        this.workflowComposite.controllerTargetNodeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = WorkflowPage.this.workflowComposite.controllerTargetNodeCombo.getSelectionIndex();
                LogicalNodeId platform = (LogicalNodeId)WorkflowPage.this.workflowComposite.controllerTargetNodeCombo.getData(WorkflowPage.PLATFORM_DATA_PREFIX + index);
                WorkflowPage.this.workflowDescription.setControllerNode(platform);
                WorkflowPage.this.refreshControllersTargetInstance();
            }
        });
    }

    public void refreshControllersTargetInstance() {
        CCombo comboControllerTarget = this.workflowComposite.controllerTargetNodeCombo;
        if (comboControllerTarget != null) {
            comboControllerTarget.removeAll();
            comboControllerTarget.add(String.valueOf(this.localNodeId.getAssociatedDisplayName()) + " " + Messages.localPlatformSelectionTitle);
            comboControllerTarget.setData("platform_index0", null);
            List<LogicalNodeId> nodes = this.nodeIdConfigHelper.getWorkflowControllerNodesSortedByName();
            nodes.remove(this.localNodeId);
            int index = 0;
            for (LogicalNodeId node : nodes) {
                comboControllerTarget.add(node.getAssociatedDisplayName());
                comboControllerTarget.setData(PLATFORM_DATA_PREFIX + ++index, (Object)node);
            }
            LogicalNodeId selectedNode = this.workflowDescription.getControllerNode();
            if (selectedNode == null || selectedNode.equals(this.localNodeId) || !nodes.contains(selectedNode)) {
                comboControllerTarget.select(0);
            } else {
                int indexNode = nodes.indexOf(selectedNode) + 1;
                comboControllerTarget.select(indexNode);
            }
            index = comboControllerTarget.getSelectionIndex();
            LogicalNodeId platform = (LogicalNodeId)comboControllerTarget.getData(PLATFORM_DATA_PREFIX + index);
            this.workflowDescription.setControllerNode(platform);
        }
    }

    public boolean canFlipToNextPage() {
        if (this.hasInstanceError()) {
            return false;
        }
        if (!this.workflowComposite.areNodesValid()) {
            this.prepareErrorStatement();
            return false;
        }
        this.setErrorMessage(null);
        this.setDescription(Messages.configure);
        String name = this.workflowComposite.workflowNameText.getText();
        return !name.isEmpty();
    }

    private boolean hasInstanceError() {
        if (this.missingInstances != null) {
            for (InstanceNodeSessionId id : this.missingInstances) {
                for (WorkflowNode node : this.workflowDescription.getWorkflowNodes()) {
                    if (!node.getComponentDescription().getNode().equals(id)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void prepareErrorStatement() {
        ArrayList<WorkflowNode> nodes = new ArrayList<WorkflowNode>(this.workflowComposite.getInvalidNodes());
        Collections.sort(nodes);
        int count = 0;
        String errorNodes = " ";
        for (WorkflowNode node : nodes) {
            if (++count > 3) {
                errorNodes = String.valueOf(errorNodes) + ", ...";
                break;
            }
            if (!errorNodes.equals(" ")) {
                errorNodes = String.valueOf(errorNodes) + ", ";
            }
            errorNodes = String.valueOf(errorNodes) + node.getName();
        }
        if (count > 0) {
            this.setDescription(null);
            this.setErrorMessage(String.valueOf(Messages.selectExcatMatchtingPlatform) + errorNodes);
        }
    }

    protected boolean canFinish() {
        if (this.hasInstanceError()) {
            return false;
        }
        return this.workflowComposite.areNodesValid();
    }

    protected String getWorkflowName() {
        return this.workflowDescription.getName();
    }

    protected LogicalNodeId getControllerNodeId() {
        return this.workflowDescription.getControllerNode();
    }

    protected Map<String, ComponentInstallation> getComponentInstallations() {
        HashMap<String, ComponentInstallation> cmpInstallations = new HashMap<String, ComponentInstallation>();
        for (WorkflowNode wfNode : this.workflowDescription.getWorkflowNodes()) {
            cmpInstallations.put(wfNode.getIdentifier(), wfNode.getComponentDescription().getComponentInstallation());
        }
        return cmpInstallations;
    }

    protected String getAdditionalInformation() {
        return this.workflowDescription.getAdditionalInformation();
    }

    public WorkflowComposite getWorkflowComposite() {
        return this.workflowComposite;
    }

    public class WorkflowComposite
    extends Composite {
        private Text workflowNameText;
        private Text search;
        private TableViewer componentsTableViewer;
        private TreeViewer componentsTreeViewer;
        private CCombo controllerTargetNodeCombo;
        private Button groupbyComponentCheck;
        private Group grpComponentsTp;
        private Text additionalInformationText;
        private Filter filterTable;
        private Filter filterTree;
        private TreeBehaviour treeUpdater;
        private TableBehaviour tableUpdater;
        private Image checkedImg;
        private Image uncheckedImg;

        WorkflowComposite(Composite parent, int style) {
            super(parent, style);
            ScrolledComposite sc = new ScrolledComposite((Composite)this, 2816);
            sc.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).create());
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            Composite containerMain = new Composite((Composite)sc, 0);
            containerMain.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
            this.checkedImg = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_CHECKED);
            this.uncheckedImg = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.CHECK_UNCHECKED);
            this.setLayout((Layout)new GridLayout(1, false));
            Group groupName = new Group(containerMain, 0);
            groupName.setLayout((Layout)new GridLayout(1, false));
            groupName.setText(Messages.nameGroupTitle);
            groupName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.workflowNameText = new Text((Composite)groupName, 2048);
            this.workflowNameText.setText("");
            this.workflowNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            Group grpTargetPlatform = new Group(containerMain, 0);
            grpTargetPlatform.setLayout((Layout)new GridLayout(1, false));
            grpTargetPlatform.setText(Messages.controlTP);
            grpTargetPlatform.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.controllerTargetNodeCombo = new CCombo((Composite)grpTargetPlatform, 2056);
            this.controllerTargetNodeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.controllerTargetNodeCombo.setBackground(Display.getCurrent().getSystemColor(1));
            this.grpComponentsTp = new Group(containerMain, 0);
            this.grpComponentsTp.setLayout((Layout)new GridLayout(4, false));
            this.grpComponentsTp.setText(Messages.componentsTP);
            this.grpComponentsTp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            if (SystemUtils.IS_OS_LINUX) {
                this.search = new Text((Composite)this.grpComponentsTp, 2948);
                WorkflowPage.this.tableHeight = 170;
                this.search.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        if (e.detail == 256) {
                            if (WorkflowComposite.this.componentsTableViewer.getTable().isVisible()) {
                                WorkflowComposite.this.search.setText("");
                                WorkflowComposite.this.filterTable.setSearchText("");
                                WorkflowComposite.this.refreshTable();
                                WorkflowComposite.this.repackTable();
                            } else {
                                WorkflowComposite.this.search.setText("");
                                WorkflowComposite.this.filterTree.setSearchText("");
                                WorkflowComposite.this.refreshTree();
                                WorkflowComposite.this.repackTree();
                            }
                        }
                    }
                });
            } else {
                this.search = new Text((Composite)this.grpComponentsTp, 2052);
                WorkflowPage.this.tableHeight = 200;
            }
            GridData searchData = new GridData(4, 4, true, false, 2, 1);
            searchData.minimumWidth = 200;
            this.search.setLayoutData((Object)searchData);
            this.search.setMessage(WorkflowPage.FILTER);
            this.search.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text text = (Text)e.getSource();
                    if (WorkflowComposite.this.componentsTableViewer.getTable().isVisible()) {
                        WorkflowComposite.this.filterTable.setSearchText(text.getText());
                        WorkflowComposite.this.refreshTable();
                    } else {
                        WorkflowComposite.this.filterTree.setSearchText(text.getText());
                        WorkflowComposite.this.refreshTree();
                    }
                }
            });
            this.groupbyComponentCheck = new Button((Composite)this.grpComponentsTp, 32);
            this.groupbyComponentCheck.setText("Group by component");
            GridData groupByComponentData = new GridData(0x1000008, 4, false, false, 2, 1);
            this.groupbyComponentCheck.setLayoutData((Object)groupByComponentData);
            this.groupbyComponentCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowComposite.this.tableUpdater.saveIndexOfComboBeforeRefresh();
                    WorkflowComposite.this.treeUpdater.saveIndexOfComboBeforeRefresh();
                    WorkflowComposite.this.changeTable();
                    if (WorkflowComposite.this.componentsTableViewer.getTable().isVisible()) {
                        WorkflowComposite.this.refreshTable();
                    } else {
                        WorkflowComposite.this.refreshTree();
                    }
                    WorkflowComposite.this.tableUpdater.setSavedComboIndex();
                    WorkflowComposite.this.treeUpdater.setSavedComboIndex();
                }
            });
            this.componentsTableViewer = new TableViewer((Composite)this.grpComponentsTp, 2816);
            this.componentsTableViewer.getTable().addControlListener((ControlListener)new ResizeListener());
            Table componentsTable = this.componentsTableViewer.getTable();
            componentsTable.setHeaderVisible(true);
            GridData data = new GridData(4, 4, true, true, 4, 1);
            data.minimumHeight = WorkflowPage.this.tableHeight;
            data.heightHint = 6 * componentsTable.getItemHeight();
            componentsTable.setLayoutData((Object)data);
            WorkflowPage.this.editingSupport = new TargetNodeEditingSupport(WorkflowPage.this.nodeIdConfigHelper, WorkflowPage.this.localNodeId, (ColumnViewer)this.componentsTableViewer, 1);
            this.buildTable();
            this.buildTree();
            GridData dataApplyInstance = new GridData(4, 4, false, false, 1, 1);
            final Button applyInstanceBtn = new Button((Composite)this.grpComponentsTp, 8);
            applyInstanceBtn.setText(Messages.applyTargetInstance);
            applyInstanceBtn.setLayoutData((Object)dataApplyInstance);
            applyInstanceBtn.setEnabled(false);
            GridData dataCombo = new GridData(4, 4, true, false, 3, 1);
            dataCombo.verticalAlignment = 0x1000000;
            final CCombo comboTargetInstance = new CCombo((Composite)this.grpComponentsTp, 2056);
            comboTargetInstance.setEnabled(false);
            comboTargetInstance.setLayoutData((Object)dataCombo);
            comboTargetInstance.setBackground(Display.getCurrent().getSystemColor(1));
            comboTargetInstance.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    applyInstanceBtn.setFocus();
                }
            });
            applyInstanceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WorkflowComposite.this.componentsTreeViewer.getTree().isVisible()) {
                        for (CCombo combo : WorkflowPage.this.targetNodeLabelProviderTree.getComboList()) {
                            TreeNode n;
                            if (!combo.isVisible() || !(combo.getData() instanceof TreeNode) || (n = (TreeNode)combo.getData()).getWorkflowNode() == null) continue;
                            this.setInstanceFromComboToNodes(n.getWorkflowNode(), combo);
                        }
                        WorkflowComposite.this.refreshTree();
                    } else {
                        for (CCombo combo : WorkflowPage.this.targetNodeLabelProviderTable.getComboList()) {
                            if (!combo.isVisible() || !(combo.getData() instanceof WorkflowNode)) continue;
                            WorkflowNode node = (WorkflowNode)combo.getData();
                            this.setInstanceFromComboToNodes(node, combo);
                        }
                    }
                }

                private void setInstanceFromComboToNodes(WorkflowNode node, CCombo combo) {
                    if (node.isChecked()) {
                        String instanceText = comboTargetInstance.getText();
                        if (instanceText.equals(Messages.anyRemote)) {
                            WorkflowComposite.this.setAnyRemote(combo);
                            return;
                        }
                        int i = 0;
                        while (i < combo.getItemCount()) {
                            if (combo.getItem(i).equals(instanceText)) {
                                combo.select(i);
                            }
                            ++i;
                        }
                        WorkflowPage.this.targetNodeLabelProviderTable.handleSelection(combo, node);
                    }
                }
            });
            Group groupAdditionalInformation = new Group(containerMain, 0);
            groupAdditionalInformation.setLayout((Layout)new GridLayout(1, false));
            groupAdditionalInformation.setText(de.rcenvironment.core.gui.workflow.view.list.Messages.additionalInformationColon);
            groupAdditionalInformation.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 1, 1));
            this.additionalInformationText = new Text((Composite)groupAdditionalInformation, 2048);
            this.additionalInformationText.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 1, 1));
            this.tableUpdater.setMasterCombo(comboTargetInstance);
            this.treeUpdater.setMasterCombo(comboTargetInstance);
            this.tableUpdater.setMasterButton(applyInstanceBtn);
            this.treeUpdater.setMasterButton(applyInstanceBtn);
            sc.setContent((Control)containerMain);
            sc.setMinSize(containerMain.computeSize(-1, -1));
            WorkflowPage.this.setControl((Control)this);
        }

        private void setAnyRemote(CCombo combo) {
            if (this.componentsTreeViewer.getTree().isVisible()) {
                TreeNode n;
                if (combo.isVisible() && combo.getData() instanceof TreeNode && (n = (TreeNode)combo.getData()).getWorkflowNode() != null) {
                    this.setRandomlyRemote(n.getWorkflowNode(), combo);
                    WorkflowPage.this.targetNodeLabelProviderTable.handleSelection(combo, n.getWorkflowNode());
                }
            } else if (combo.isVisible() && combo.getData() instanceof WorkflowNode) {
                WorkflowNode node = (WorkflowNode)combo.getData();
                this.setRandomlyRemote(node, combo);
                WorkflowPage.this.targetNodeLabelProviderTable.handleSelection(combo, node);
            }
        }

        private void setRandomlyRemote(WorkflowNode node, CCombo combo) {
            int i;
            if (node.isChecked() && (i = WorkflowPage.this.editingSupport.setRemoteValue(node)) >= 0) {
                combo.select(i);
            }
        }

        private void changeTable() {
            GridData dataTable = (GridData)this.componentsTableViewer.getTable().getLayoutData();
            GridData dataTree = (GridData)this.componentsTreeViewer.getTree().getLayoutData();
            if (this.componentsTreeViewer.getTree().isVisible()) {
                dataTree.exclude = true;
                this.componentsTreeViewer.getTree().setVisible(false);
            } else {
                dataTree.exclude = false;
                this.filterTree.setSearchText(this.search.getText());
                this.refreshTree();
                this.componentsTreeViewer.getTree().setVisible(true);
                WorkflowPage.this.tableViewActive = false;
            }
            if (this.componentsTableViewer.getTable().isVisible()) {
                dataTable.exclude = true;
                this.componentsTableViewer.getTable().setVisible(false);
            } else {
                this.filterTable.setSearchText(this.search.getText());
                this.tableUpdater.setCurrentlyUsedSortingColumn(1);
                this.tableUpdater.refreshColumns();
                dataTable.exclude = false;
                this.componentsTableViewer.getTable().setVisible(true);
                WorkflowPage.this.tableViewActive = true;
            }
            this.componentsTableViewer.getControl().getParent().getParent().pack();
            this.componentsTableViewer.getControl().getParent().getParent().layout(true, true);
        }

        private void buildTree() {
            this.componentsTreeViewer = new TreeViewer((Composite)this.grpComponentsTp, 2816);
            this.componentsTreeViewer.getTree().addControlListener((ControlListener)new ResizeListener());
            WorkflowPage.this.targetNodeLabelProviderTree = new WorkflowNodeTargetPlatformLabelProvider(WorkflowPage.this.editingSupport, WorkflowPage.this.workflowDescription, WorkflowPage.this.getWizard());
            WorkflowPage.this.checkboxProviderTree = new CheckboxLabelProvider();
            WorkflowPage.this.targetNodeLabelProviderTree.setPage(WorkflowPage.this);
            this.componentsTreeViewer.getTree().addListener(17, new Listener(){

                public void handleEvent(Event e) {
                    WorkflowComposite.this.componentsTreeViewer.getTree().redraw();
                }
            });
            this.componentsTreeViewer.getTree().addListener(18, new Listener(){

                public void handleEvent(Event e) {
                    WorkflowComposite.this.componentsTreeViewer.getTree().redraw();
                }
            });
            this.treeUpdater = new TreeBehaviour(this.componentsTreeViewer, WorkflowPage.this.targetNodeLabelProviderTree, WorkflowPage.this.checkboxProviderTree);
            WorkflowPage.this.targetNodeLabelProviderTree.setUpdater(this.treeUpdater);
            WorkflowPage.this.checkboxProviderTree.setUpdater(this.treeUpdater);
            this.componentsTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
            this.componentsTreeViewer.setInput((Object)WorkflowPage.this.workflowDescription);
            this.componentsTreeViewer.getTree().setHeaderVisible(true);
            GridData dataOfTree = new GridData(4, 4, true, true, 1, 1);
            dataOfTree.horizontalSpan = 10;
            dataOfTree.exclude = true;
            dataOfTree.minimumHeight = WorkflowPage.this.tableHeight;
            dataOfTree.heightHint = 6 * this.componentsTreeViewer.getTree().getItemHeight();
            this.componentsTreeViewer.getTree().setLayoutData((Object)dataOfTree);
            this.componentsTreeViewer.getTree().setVisible(false);
            final TreeViewerColumn columnViewerBox = this.createTreeColumn(this.componentsTreeViewer, (CellLabelProvider)WorkflowPage.this.checkboxProviderTree, "", 60);
            columnViewerBox.getColumn().setImage(this.uncheckedImg);
            columnViewerBox.getColumn().setText(WorkflowPage.ALL);
            columnViewerBox.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowComposite.this.treeUpdater.saveIndexOfComboBeforeRefresh();
                    if (WorkflowComposite.this.treeUpdater.isCheckBoxColumnEnabled()) {
                        if (columnViewerBox.getColumn().getImage().equals((Object)WorkflowComposite.this.uncheckedImg)) {
                            TableBehaviour.allCheckboxesClicked = true;
                            columnViewerBox.getColumn().setImage(WorkflowComposite.this.checkedImg);
                            for (Button btn : WorkflowPage.this.checkboxProviderTree.getBtnList()) {
                                if (!btn.isEnabled()) continue;
                                TreeNode node = (TreeNode)btn.getData("CHECK_BOX");
                                if (node.isChildElement()) {
                                    node.getWorkflowNode().setChecked(true);
                                }
                                btn.setSelection(true);
                            }
                        } else {
                            for (Button btn : WorkflowPage.this.checkboxProviderTree.getBtnList()) {
                                if (!btn.isEnabled()) continue;
                                TreeNode node = (TreeNode)btn.getData("CHECK_BOX");
                                if (node.isChildElement()) {
                                    node.getWorkflowNode().setChecked(false);
                                }
                                btn.setSelection(false);
                            }
                            TableBehaviour.allCheckboxesClicked = false;
                            columnViewerBox.getColumn().setImage(WorkflowComposite.this.uncheckedImg);
                        }
                        WorkflowComposite.this.treeUpdater.prepareValuesForMasterCombo();
                        WorkflowComposite.this.treeUpdater.checkIfDisableMasterBtn();
                        WorkflowComposite.this.treeUpdater.setSavedComboIndex();
                    }
                }
            });
            TreeViewerColumn columnViewer = this.createTreeColumn(this.componentsTreeViewer, (CellLabelProvider)new WorkflowNodeNameLabelTreeProvider(), Messages.component, 200);
            this.componentsTreeViewer.getTree().setSortColumn(columnViewer.getColumn());
            this.componentsTreeViewer.getTree().setSortDirection(128);
            columnViewer.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowComposite.this.treeUpdater.saveIndexOfComboBeforeRefresh();
                    int direction = WorkflowComposite.this.componentsTreeViewer.getTree().getSortDirection();
                    direction = direction == 128 ? 1024 : 128;
                    WorkflowComposite.this.componentsTreeViewer.getTree().setSortDirection(direction);
                    WorkflowComposite.this.refreshTree();
                    WorkflowComposite.this.treeUpdater.setSavedComboIndex();
                }
            });
            this.componentsTreeViewer.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object node, Object otherNode) {
                    TreeViewer treeViewer = (TreeViewer)viewer;
                    TreeNode nodeOne = (TreeNode)node;
                    TreeNode nodeTwo = (TreeNode)otherNode;
                    if (treeViewer.getTree().getSortDirection() == 1024) {
                        return nodeTwo.getComponentName().compareTo(nodeOne.getComponentName());
                    }
                    return nodeOne.getComponentName().compareTo(nodeTwo.getComponentName());
                }
            });
            this.createTreeColumn(this.componentsTreeViewer, (CellLabelProvider)WorkflowPage.this.targetNodeLabelProviderTree, Messages.targetPlatform, 250);
            this.filterTree = new Filter(this.treeUpdater);
            this.componentsTreeViewer.addFilter((ViewerFilter)this.filterTree);
            this.componentsTreeViewer.refresh();
            this.componentsTreeViewer.getTree().setVisible(false);
            this.componentsTreeViewer.getTree().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    event.detail &= 0xFFFFFFFD;
                    event.detail &= 0xFFFFFFDF;
                    GC gc = event.gc;
                    TreeItem item = (TreeItem)event.item;
                    gc.setBackground(item.getBackground(event.index));
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                }
            });
        }

        private void repackTree() {
            this.componentsTreeViewer.getTree().getParent().pack();
            this.componentsTreeViewer.getTree().getParent().getParent().pack();
            this.componentsTreeViewer.getControl().getParent().getParent().layout(true, true);
        }

        private void repackTable() {
            this.componentsTableViewer.getTable().getParent().pack();
            this.componentsTableViewer.getTable().getParent().getParent().pack();
            this.componentsTableViewer.getControl().getParent().getParent().layout(true, true);
        }

        private TreeViewerColumn createTreeColumn(TreeViewer treeViewer, CellLabelProvider provider, String columnHeader, int width) {
            TreeViewerColumn column = new TreeViewerColumn(this.componentsTreeViewer, 32768);
            column.getColumn().setAlignment(16384);
            column.setLabelProvider(provider);
            column.getColumn().setText(columnHeader);
            column.getColumn().setWidth(width);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(false);
            return column;
        }

        private void buildTable() {
            WorkflowPage.this.targetNodeLabelProviderTable = new WorkflowNodeTargetPlatformLabelProvider(WorkflowPage.this.editingSupport, WorkflowPage.this.workflowDescription, WorkflowPage.this.getWizard());
            WorkflowPage.this.checkboxProviderTable = new CheckboxLabelProvider();
            this.tableUpdater = new TableBehaviour(this.componentsTableViewer, WorkflowPage.this.targetNodeLabelProviderTable, WorkflowPage.this.checkboxProviderTable);
            WorkflowPage.this.checkboxProviderTable.setUpdater(this.tableUpdater);
            WorkflowPage.this.targetNodeLabelProviderTable.setUpdater(this.tableUpdater);
            WorkflowPage.this.targetNodeLabelProviderTable.setPage(WorkflowPage.this);
            this.filterTable = new Filter(this.tableUpdater);
            this.componentsTableViewer.addFilter((ViewerFilter)this.filterTable);
            WorkflowNodeNameLabelProvider providerNames = new WorkflowNodeNameLabelProvider();
            final TableColumn columnCheck = this.createTableColumn(this.componentsTableViewer, (CellLabelProvider)WorkflowPage.this.checkboxProviderTable, "", 60);
            columnCheck.setText(WorkflowPage.ALL);
            columnCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorkflowComposite.this.tableUpdater.saveIndexOfComboBeforeRefresh();
                    if (WorkflowComposite.this.tableUpdater.isCheckBoxColumnEnabled()) {
                        if (columnCheck.getImage().equals((Object)WorkflowComposite.this.uncheckedImg)) {
                            columnCheck.setImage(WorkflowComposite.this.checkedImg);
                            TableBehaviour.allCheckboxesClicked = true;
                            for (Button btn : WorkflowPage.this.checkboxProviderTable.getBtnList()) {
                                if (!btn.isEnabled()) continue;
                                WorkflowNode node = (WorkflowNode)btn.getData("CHECK_BOX");
                                node.setChecked(true);
                                btn.setSelection(true);
                            }
                        } else {
                            for (Button btn : WorkflowPage.this.checkboxProviderTable.getBtnList()) {
                                if (!btn.isEnabled()) continue;
                                WorkflowNode node = (WorkflowNode)btn.getData("CHECK_BOX");
                                node.setChecked(false);
                                btn.setSelection(false);
                            }
                            TableBehaviour.allCheckboxesClicked = false;
                            columnCheck.setImage(WorkflowComposite.this.uncheckedImg);
                        }
                        WorkflowComposite.this.tableUpdater.prepareValuesForMasterCombo();
                        WorkflowComposite.this.tableUpdater.checkIfDisableMasterBtn();
                        WorkflowComposite.this.tableUpdater.setSavedComboIndex();
                    }
                }
            });
            columnCheck.setImage(this.uncheckedImg);
            TableColumn columnName = this.createTableColumn(this.componentsTableViewer, (CellLabelProvider)providerNames, Messages.component, 200);
            columnName.setData((Object)"COLUMN_NAME");
            TableColumn columnInstance = this.createTableColumn(this.componentsTableViewer, (CellLabelProvider)WorkflowPage.this.targetNodeLabelProviderTable, Messages.targetPlatform, 250);
            columnInstance.setData((Object)"COLUMN_INSTANCE");
            TableSortSelectionListener listenerColumnOne = new TableSortSelectionListener(this.componentsTableViewer, columnName, 1024);
            listenerColumnOne.setUpdaterTable(this.tableUpdater);
            TableSortSelectionListener listenerColumnTwo = new TableSortSelectionListener(this.componentsTableViewer, columnInstance, 1024);
            listenerColumnTwo.setUpdaterTable(this.tableUpdater);
            this.componentsTableViewer.getTable().setSortColumn(columnName);
            this.componentsTableViewer.getTable().setSortDirection(128);
            this.componentsTableViewer.getTable().addListener(40, (Listener)new EraseListener());
        }

        private TableColumn createTableColumn(TableViewer viewer, CellLabelProvider provider, String text, int width) {
            TableViewerColumn column = new TableViewerColumn(viewer, 4);
            column.setLabelProvider(provider);
            column.getColumn().setAlignment(16384);
            column.getColumn().setText(text);
            column.getColumn().setWidth(width);
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(false);
            return column.getColumn();
        }

        public boolean areNodesValid() {
            if (this.componentsTableViewer.getTable().isVisible()) {
                return WorkflowPage.this.targetNodeLabelProviderTable.areNodesValid();
            }
            return WorkflowPage.this.targetNodeLabelProviderTree.areNodesValid();
        }

        private void refreshTree() {
            this.componentsTreeViewer.getTree().setRedraw(false);
            this.treeUpdater.saveIndexOfComboBeforeRefresh();
            this.treeUpdater.disposeWidgets();
            this.componentsTreeViewer.setContentProvider((IContentProvider)WorkflowPage.this.treeContenProvider);
            this.treeUpdater.refreshColumns();
            this.componentsTreeViewer.getTree().pack();
            this.treeUpdater.setSavedComboIndex();
            this.repackTree();
            this.componentsTreeViewer.getTree().setRedraw(true);
        }

        private void refreshTable() {
            this.tableUpdater.saveIndexOfComboBeforeRefresh();
            this.tableUpdater.disposeWidgets();
            this.tableUpdater.refreshColumns();
            this.tableUpdater.setSavedComboIndex();
            this.componentsTableViewer.getTable().pack();
            this.repackTable();
        }

        public List<WorkflowNode> getInvalidNodes() {
            ArrayList<WorkflowNode> invalidNodesList = new ArrayList<WorkflowNode>();
            Iterator<Map.Entry<WorkflowNode, Boolean>> entries = this.componentsTableViewer.getTable().isVisible() ? WorkflowPage.this.targetNodeLabelProviderTable.getNodesValidList().entrySet().iterator() : WorkflowPage.this.targetNodeLabelProviderTree.getNodesValidList().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<WorkflowNode, Boolean> entry = entries.next();
                WorkflowNode key = entry.getKey();
                Boolean value = entry.getValue();
                WorkflowPage.this.editingSupport.getHasVersionErrorMap().put(key, false);
                if (value.booleanValue()) continue;
                invalidNodesList.add(key);
                WorkflowPage.this.editingSupport.getHasVersionErrorMap().put(key, true);
            }
            return invalidNodesList;
        }

        public void refreshContent() {
            WorkflowPage.this.refreshControllersTargetInstance();
            WorkflowPage.this.nodeIdConfigHelper.refreshInstallations();
            if (WorkflowPage.this.tableViewActive) {
                this.refreshTable();
            } else {
                this.refreshTree();
            }
        }

        private void resizeTables() {
            int offSet = 0;
            int scrollBarWidth = 0;
            scrollBarWidth = this.componentsTableViewer.getTable().getItemCount() > 9 ? 0 : 17;
            offSet = !this.componentsTreeViewer.getTree().isVisible() ? this.componentsTableViewer.getTable().getClientArea().width - 510 - scrollBarWidth : this.componentsTreeViewer.getTree().getClientArea().width - 510 - scrollBarWidth;
            if (offSet > 0) {
                this.componentsTableViewer.getTable().getColumn(2).setWidth(250 + offSet);
                this.componentsTreeViewer.getTree().getColumn(2).setWidth(250 + offSet);
            }
        }

        private class EraseListener
        implements Listener {
            private EraseListener() {
            }

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFDF;
                GC gc = event.gc;
                TableItem item = (TableItem)event.item;
                gc.setBackground(item.getBackground(event.index));
                gc.fillRectangle(event.x, event.y, event.width, event.height);
            }
        }

        public final class ResizeListener
        extends ControlAdapter {
            public void controlResized(ControlEvent event) {
                WorkflowComposite.this.resizeTables();
            }
        }

        private class WorkflowNodeNameLabelProvider
        extends StyledCellLabelProvider {
            private WorkflowNodeNameLabelProvider() {
            }

            protected void paint(Event event, Object element) {
                Rectangle bounds = event.getBounds();
                WorkflowNode node = (WorkflowNode)element;
                event.gc.setForeground(ColorPalette.getInstance().getBlackColor());
                event.gc.drawImage(WorkflowPage.this.targetNodeLabelProviderTree.getImage(node), bounds.x + 5, bounds.y);
                event.gc.drawText(node.getName(), bounds.x + 26, bounds.y);
            }
        }

        private final class WorkflowNodeNameLabelTreeProvider
        extends StyledCellLabelProvider {
            private final int offsetName = 30;
            private final int offsetPic = 10;

            private WorkflowNodeNameLabelTreeProvider() {
            }

            protected void paint(Event event, Object element) {
                TreeNode node = (TreeNode)element;
                Rectangle bounds = event.getBounds();
                GC gc = event.gc;
                TreeItem item = (TreeItem)event.item;
                event.detail &= 0xFFFFFFFD;
                event.detail &= 0xFFFFFFDF;
                gc.setBackground(item.getBackground(event.index));
                gc.setForeground(ColorPalette.getInstance().getBlackColor());
                gc.fillRectangle(event.x, event.y, event.width, event.height);
                if (node.isChildElement()) {
                    int positionnName = bounds.x + 30;
                    int postionPicture = bounds.x + 10;
                    gc.drawImage(WorkflowPage.this.targetNodeLabelProviderTree.getImage(node.getWorkflowNode()), postionPicture, bounds.y);
                    gc.drawText(node.getComponentName(), positionnName, bounds.y);
                } else {
                    Font font = new Font((Device)Display.getCurrent(), "Arial", 10, 2);
                    gc.setFont(font);
                    gc.drawText(node.getComponentName(), bounds.x + 5, bounds.y);
                    font.dispose();
                }
            }
        }
    }
}

