/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeUtil;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ComponentPropertySource
implements IPropertySource2,
ComponentInstanceProperties {
    private final WorkflowNode node;
    private final ConfigurationDescription configurationDesc;
    private final CommandStack cs;

    public ComponentPropertySource(CommandStack stack, WorkflowNode node) {
        this.node = node;
        this.configurationDesc = node.getComponentDescription().getConfigurationDescription();
        this.cs = stack;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        for (String key : this.configurationDesc.getConfiguration().keySet()) {
            descriptors.add(new PropertyDescriptor((Object)key, key));
        }
        return descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public boolean isPropertyResettable(Object key) {
        return false;
    }

    public Object getPropertyValue(Object key) {
        String value = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)((String)key));
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public boolean isPropertySet(Object key) {
        return WorkflowNodeUtil.isConfigurationValueSet((ComponentInstanceProperties)this.node, (String)((String)key));
    }

    public void resetPropertyValue(Object key) {
        this.setConfiguration((String)key, this.configurationDesc.getComponentConfigurationDefinition().getDefaultValue((String)key));
    }

    public void setPropertyValue(Object key, Object value) {
        if (value == null || ((String)value).isEmpty()) {
            this.setConfiguration((String)key, null);
            return;
        }
        this.setConfiguration((String)key, (String)value);
    }

    private String getConfiguration(String key) {
        return WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)this.node, (String)key);
    }

    private void setConfiguration(String key, String value) {
        if (value == null && this.getConfiguration(key) != null || value != null && !value.equals(this.getConfiguration(key))) {
            SetValueCommand setCommand = new SetValueCommand(Messages.property, this.node, key, value);
            this.cs.execute((Command)setCommand);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.node.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.node.removePropertyChangeListener(listener);
    }

    public EndpointDescriptionsManager getInputDescriptionsManager() {
        return this.node.getInputDescriptionsManager();
    }

    public EndpointDescriptionsManager getOutputDescriptionsManager() {
        return this.node.getOutputDescriptionsManager();
    }

    public ConfigurationDescription getConfigurationDescription() {
        this.node.getComponentDescription().getComponentInterface().getIdentifier();
        return this.node.getConfigurationDescription();
    }

    public String getComponentIdentifierWithVersion() {
        return this.node.getComponentDescription().getIdentifier();
    }

    class SetValueCommand
    extends Command {
        private final WorkflowNode target;
        private final String propertyName;
        private final String propertyValue;
        private String undoValue;
        private ConfigurationDescription config;

        SetValueCommand(String label, WorkflowNode node, String id, String value) {
            super(label);
            this.target = node;
            this.propertyName = id;
            this.propertyValue = value;
            this.config = this.target.getConfigurationDescription();
        }

        public void execute() {
            this.undoValue = this.config.getConfigurationValue(this.propertyName);
            this.config.setConfigurationValue(this.propertyName, this.propertyValue);
        }

        public void undo() {
            this.config.setConfigurationValue(this.propertyName, this.undoValue);
        }
    }
}

