/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointGroupDescription;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.Location;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowLabel;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.editor.commands.WorkflowNodeLabelConnectionCreateCommand;
import de.rcenvironment.core.gui.workflow.editor.handlers.AbstractWorkflowNodeEditHandler;
import de.rcenvironment.core.gui.workflow.parts.WorkflowEditorEditPartFactory;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;

public class WorkflowNodePasteHandler
extends AbstractWorkflowNodeEditHandler {
    private static final ObjectMapper JSON_OBJECT_MAPPER = JsonUtils.getDefaultObjectMapper();
    private final Map<String, String> nameMapping = new HashMap<String, String>();
    private final Map<WorkflowNode, WorkflowNode> nodeMapping = new HashMap<WorkflowNode, WorkflowNode>();
    private final Map<String, Map<String, EndpointDescription>> endpointIDMapping = new HashMap<String, Map<String, EndpointDescription>>();
    private final Map<WorkflowNode, Rectangle> newNodeAndLocationMapping = new HashMap<WorkflowNode, Rectangle>();
    private int nodeConstraintPositionCounter = 0;
    private int labelConstraintPositionCounter = 0;
    private final int offset = 20;
    private int componentSizeOffset = 0;
    private boolean hasConnections = false;
    private int nodeMinX = Integer.MAX_VALUE;
    private int nodeMinY = Integer.MAX_VALUE;
    private int labelMinX = Integer.MAX_VALUE;
    private int labelMinY = Integer.MAX_VALUE;
    private Point editorOffsetPoint = null;
    private boolean pasteTriggeredByMouse;

    @Override
    void edit() {
        Object content;
        this.nameMapping.clear();
        this.nodeConstraintPositionCounter = 0;
        this.hasConnections = false;
        this.labelConstraintPositionCounter = 0;
        LinkedList<WorkflowNode> workflowNodesToCreate = new LinkedList<WorkflowNode>();
        LinkedList<WorkflowNodePart> pastedWorkflowNodeParts = new LinkedList<WorkflowNodePart>();
        LinkedList<WorkflowLabel> workflowLabelsToCreate = new LinkedList<WorkflowLabel>();
        LinkedList<Connection> connectionsToCreate = new LinkedList<Connection>();
        LinkedList<Rectangle> nodeConstraintsToCreate = new LinkedList<Rectangle>();
        LinkedList<Rectangle> labelConstraintsToCreate = new LinkedList<Rectangle>();
        this.pasteTriggeredByMouse = false;
        if (this.event.getTrigger() instanceof Event) {
            Event ev = (Event)this.event.getTrigger();
            if (ev.widget instanceof MenuItem) {
                this.pasteTriggeredByMouse = true;
            }
        }
        if (this.viewer.getControl() instanceof FigureCanvas) {
            this.editorOffsetPoint = ((FigureCanvas)this.viewer.getControl()).getViewport().getViewLocation();
        }
        if ((content = this.extractContentfromSystemClipboard()) == null) {
            return;
        }
        HashMap otherNodesCombined = new HashMap();
        LinkedList<String> editorNodeNames = new LinkedList<String>();
        for (Object e : this.viewer.getContents().getChildren()) {
            if (!(e instanceof WorkflowNodePart)) continue;
            editorNodeNames.add(((WorkflowNode)((WorkflowNodePart)e).getModel()).getName());
        }
        if (content instanceof List) {
            for (Object nodePart : (List)content) {
                if (nodePart instanceof Connection) {
                    this.hasConnections = true;
                }
                if (!(nodePart instanceof WorkflowNodePart)) continue;
                ArrayList<String> otherNodes = new ArrayList<String>();
                for (Object nodePart2 : (List)content) {
                    if (!(nodePart2 instanceof WorkflowNodePart)) continue;
                    WorkflowNodePart part = (WorkflowNodePart)nodePart2;
                    WorkflowNode node = (WorkflowNode)part.getModel();
                    otherNodes.add(node.getName());
                }
                WorkflowNodePart part = (WorkflowNodePart)nodePart;
                WorkflowNode node = (WorkflowNode)part.getModel();
                otherNodes.remove(node.getName());
                otherNodes.addAll(editorNodeNames);
                otherNodesCombined.put(node.getName(), otherNodes);
            }
            this.getMinNodeAndLabel(content);
            for (Object partToPaste : (List)content) {
                if (partToPaste instanceof WorkflowNodePart) {
                    EndpointDescription newEndpoint;
                    String nodeName;
                    WorkflowNodePart part = (WorkflowNodePart)partToPaste;
                    pastedWorkflowNodeParts.add(part);
                    WorkflowNode node = (WorkflowNode)part.getModel();
                    String newName = nodeName = node.getName();
                    if (((List)otherNodesCombined.get(nodeName)).contains(nodeName)) {
                        newName = "Copy of " + nodeName;
                    }
                    int i = 2;
                    while (((List)otherNodesCombined.get(nodeName)).contains(newName)) {
                        newName = "Copy (" + i++ + ") of " + nodeName;
                    }
                    WorkflowNode newNode = new WorkflowNode(this.copyComponentDescription(node.getComponentDescription()));
                    newNode.setName(newName);
                    newNode.setEnabled(node.isEnabled());
                    workflowNodesToCreate.add(newNode);
                    this.addNewNodePosition(nodeConstraintsToCreate, node);
                    this.nameMapping.put(node.getIdentifier(), newNode.getIdentifier());
                    this.nodeMapping.put(node, newNode);
                    this.newNodeAndLocationMapping.put(newNode, (Rectangle)nodeConstraintsToCreate.get(this.nodeConstraintPositionCounter));
                    ++this.nodeConstraintPositionCounter;
                    HashMap<String, EndpointDescription> nodesEndpointIDMapping = new HashMap<String, EndpointDescription>();
                    for (EndpointDescription endpoint : node.getInputDescriptionsManager().getEndpointDescriptions()) {
                        newEndpoint = newNode.getInputDescriptionsManager().getEndpointDescription(endpoint.getName());
                        nodesEndpointIDMapping.put(endpoint.getIdentifier(), newEndpoint);
                    }
                    for (EndpointDescription endpoint : node.getOutputDescriptionsManager().getEndpointDescriptions()) {
                        newEndpoint = newNode.getOutputDescriptionsManager().getEndpointDescription(endpoint.getName());
                        nodesEndpointIDMapping.put(endpoint.getIdentifier(), newEndpoint);
                    }
                    this.endpointIDMapping.put(node.getIdentifier(), nodesEndpointIDMapping);
                }
                if (partToPaste instanceof WorkflowLabel) {
                    WorkflowLabel label = (WorkflowLabel)partToPaste;
                    WorkflowLabel newLabel = this.createCopiedWorkflowLabel(label);
                    newLabel.setLocation(label.getX() + 20, label.getY() + 20);
                    workflowLabelsToCreate.add(newLabel);
                    this.addNewLabelPosition(labelConstraintsToCreate, label);
                    ++this.labelConstraintPositionCounter;
                }
                if (!(partToPaste instanceof Connection)) continue;
                Connection oldConnection = (Connection)partToPaste;
                WorkflowNode source = this.nodeMapping.get(oldConnection.getSourceNode());
                WorkflowNode target = this.nodeMapping.get(oldConnection.getTargetNode());
                EndpointDescription sourceOutput = this.endpointIDMapping.get(oldConnection.getSourceNode().getIdentifier()).get(oldConnection.getOutput().getIdentifier());
                EndpointDescription targetInput = this.endpointIDMapping.get(oldConnection.getTargetNode().getIdentifier()).get(oldConnection.getInput().getIdentifier());
                List originalBendpoints = oldConnection.getBendpoints();
                int bendpointOffsetX = this.newNodeAndLocationMapping.get((Object)source).x - oldConnection.getSourceNode().getX();
                int bendpointOffsetY = this.newNodeAndLocationMapping.get((Object)source).y - oldConnection.getSourceNode().getY();
                List<Location> bendpointsWithOffset = ConnectionUtils.translateBendpointListByOffset(originalBendpoints, bendpointOffsetX, bendpointOffsetY);
                Connection newConnection = new Connection(source, sourceOutput, target, targetInput, bendpointsWithOffset);
                connectionsToCreate.add(newConnection);
            }
        }
        WorkflowNodeLabelConnectionCreateCommand nodeAndConnectionCreateCommand = new WorkflowNodeLabelConnectionCreateCommand(workflowNodesToCreate, workflowLabelsToCreate, connectionsToCreate, (WorkflowDescription)this.viewer.getContents().getModel(), nodeConstraintsToCreate, labelConstraintsToCreate);
        this.commandStack.execute((Command)nodeAndConnectionCreateCommand);
        this.selectPastedNodes(workflowNodesToCreate);
    }

    private void selectPastedNodes(List<WorkflowNode> workflowNodesToCreate) {
        this.viewer.deselectAll();
        for (Object editPartObject : this.viewer.getContents().getChildren()) {
            WorkflowNodePart nodePart;
            WorkflowNode node;
            if (!(editPartObject instanceof WorkflowNodePart) || !workflowNodesToCreate.contains(node = (WorkflowNode)(nodePart = (WorkflowNodePart)editPartObject).getModel())) continue;
            this.viewer.appendSelection((EditPart)nodePart);
        }
    }

    private Object extractContentfromSystemClipboard() {
        String clipboardText = ClipboardHelper.getContentAsStringOrNull();
        if (clipboardText != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(clipboardText.getBytes());){
                    return this.parseJson((ObjectNode)JSON_OBJECT_MAPPER.readTree(IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name())));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassCastException | ParseException e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)StringUtils.format((String)"Pasted content not valid, it will be ignored: '%s' (cause: %s)", (Object[])new Object[]{clipboardText, e.toString()}));
            }
        }
        return null;
    }

    private void getMinNodeAndLabel(Object content) {
        this.nodeMinX = Integer.MAX_VALUE;
        this.nodeMinY = Integer.MAX_VALUE;
        for (Object partToPast : (List)content) {
            AbstractGraphicalEditPart part;
            if (partToPast instanceof WorkflowNodePart) {
                part = (WorkflowNodePart)partToPast;
                WorkflowNode node = (WorkflowNode)part.getModel();
                this.getMinXandYForNode(node.getX(), node.getY());
                continue;
            }
            if (!(partToPast instanceof WorkflowLabelPart)) continue;
            part = (WorkflowLabelPart)partToPast;
            WorkflowLabel label = (WorkflowLabel)part.getModel();
            this.getMinXandYForLabel(label.getX(), label.getY());
        }
    }

    private void getMinXandYForNode(int nodeX, int nodeY) {
        if (nodeX < this.nodeMinX) {
            this.nodeMinX = nodeX;
        }
        if (nodeY < this.nodeMinY) {
            this.nodeMinY = nodeY;
        }
    }

    private void getMinXandYForLabel(int labelX, int labelY) {
        if (labelX < this.labelMinX) {
            this.nodeMinX = labelX;
        }
        if (labelY < this.labelMinY) {
            this.labelMinY = labelY;
        }
    }

    private void addNewNodePosition(List<Rectangle> nodeConstraintsToCreate, WorkflowNode node) {
        WorkflowDescription model = (WorkflowDescription)this.viewer.getContents().getModel();
        if (this.pasteTriggeredByMouse) {
            if (this.hasConnections) {
                nodeConstraintsToCreate.add(this.nodeConstraintPositionCounter, new Rectangle(node.getX() - this.nodeMinX + this.editor.getMouseX() + this.editorOffsetPoint.x, node.getY() - this.nodeMinY + this.editor.getMouseY() + this.editorOffsetPoint.y, 0, 0));
            } else {
                this.findFreeSpotForNode(this.editor.getMouseX() + this.editorOffsetPoint.x, this.editor.getMouseY() + this.editorOffsetPoint.y, node.getComponentDescription().getSize(), nodeConstraintsToCreate);
            }
        } else if (!model.getWorkflowNodes().contains(node) && !this.hasConnections) {
            this.findFreeSpotForNode(20, 20, node.getComponentDescription().getSize(), nodeConstraintsToCreate);
        } else {
            this.findFreeSpotForNode(node.getX(), node.getY(), node.getComponentDescription().getSize(), nodeConstraintsToCreate);
        }
    }

    private void findFreeSpotForNode(int x, int y, ComponentSize componentSize, List<Rectangle> nodeConstraintsToCreate) {
        if (!this.isNodePositionValid(x, y, componentSize)) {
            this.findFreeSpotForNode(x + 20, y + 20, componentSize, nodeConstraintsToCreate);
        } else {
            for (Rectangle rectangle : nodeConstraintsToCreate) {
                if (!rectangle.equals(x, y, 0, 0)) continue;
                x += 20;
                y += 20;
            }
            nodeConstraintsToCreate.add(this.nodeConstraintPositionCounter, new Rectangle(x, y, 0, 0));
        }
    }

    private void addNewLabelPosition(List<Rectangle> labelConstraintsToCreate, WorkflowLabel label) {
        if (!this.viewer.getContextMenu().isDirty()) {
            this.findFreeSpotForLabel(this.editor.getMouseX(), this.editor.getMouseY(), new Dimension(label.getWidth(), label.getHeight()), labelConstraintsToCreate);
        } else if (this.viewer.getContextMenu().isDirty()) {
            this.findFreeSpotForLabel(label.getX(), label.getY(), new Dimension(label.getWidth(), label.getHeight()), labelConstraintsToCreate);
        }
    }

    private void findFreeSpotForLabel(int x, int y, Dimension labelSize, List<Rectangle> labelConstraintsToCreate) {
        if (!this.isLabelPositionValid(x, y)) {
            this.findFreeSpotForLabel(x + 20, y + 20, labelSize, labelConstraintsToCreate);
        } else {
            for (Rectangle rectangle : labelConstraintsToCreate) {
                if (!rectangle.equals(x, y, labelSize.width, labelSize.height)) continue;
                x += 40;
                y += 40;
            }
            if (this.isLabelPositionValid(x, y)) {
                labelConstraintsToCreate.add(this.labelConstraintPositionCounter, new Rectangle(x, y, labelSize.width, labelSize.height));
            } else {
                this.findFreeSpotForLabel(x + 20, y + 20, labelSize, labelConstraintsToCreate);
            }
        }
    }

    private boolean isNodePositionValid(int x, int y, ComponentSize componentSize) {
        WorkflowDescription model = (WorkflowDescription)this.viewer.getContents().getModel();
        for (WorkflowNode node : model.getWorkflowNodes()) {
            this.componentSizeOffset = node.getComponentDescription().getSize() != null && componentSize != null ? (node.getComponentDescription().getSize().equals((Object)ComponentSize.MEDIUM) && !componentSize.equals((Object)ComponentSize.MEDIUM) ? 81 : 20) : 81;
            if (x < node.getX() || x > node.getX() + this.componentSizeOffset || y < node.getY() || y > node.getY() + this.componentSizeOffset) continue;
            return false;
        }
        return true;
    }

    private boolean isLabelPositionValid(int x, int y) {
        WorkflowDescription model = (WorkflowDescription)this.viewer.getContents().getModel();
        for (WorkflowLabel label : model.getWorkflowLabels()) {
            if (x < label.getX() || x > label.getX() + 20 || y < label.getY() || y > label.getY() + 20) continue;
            return false;
        }
        return true;
    }

    private List parseJson(ObjectNode rootJsonNode) throws IOException, JsonParseException, ParseException {
        ArrayList<EditPart> combinedList = new ArrayList<EditPart>();
        WorkflowDescriptionPersistenceHandler descriptionHandler = new WorkflowDescriptionPersistenceHandler();
        WorkflowEditorEditPartFactory factory = new WorkflowEditorEditPartFactory();
        Map parsedNodes = null;
        if (rootJsonNode.has("nodes")) {
            parsedNodes = descriptionHandler.parseNodes((ArrayNode)rootJsonNode.get("nodes"));
            for (String key : parsedNodes.keySet()) {
                EditPart createEditPart = factory.createEditPart(null, parsedNodes.get(key));
                if (!(createEditPart instanceof WorkflowNodePart)) continue;
                combinedList.add(createEditPart);
            }
        }
        List parsedConnections = null;
        if (rootJsonNode.has("connections")) {
            parsedConnections = descriptionHandler.parseConnections((ArrayNode)rootJsonNode.get("connections"), parsedNodes);
            combinedList.addAll(parsedConnections);
        }
        if (rootJsonNode.has("bendpoints")) {
            descriptionHandler.parseBendpoints((ArrayNode)rootJsonNode.get("bendpoints"), parsedNodes, parsedConnections);
        }
        if (rootJsonNode.has("labels")) {
            Set parsedLabel = descriptionHandler.parseLabels((ArrayNode)rootJsonNode.get("labels"));
            combinedList.addAll(parsedLabel);
        }
        return combinedList;
    }

    private WorkflowLabel createCopiedWorkflowLabel(WorkflowLabel origin) {
        WorkflowLabel copied = new WorkflowLabel(origin.getText());
        copied.setHeaderText(origin.getHeaderText());
        copied.setAlpha(origin.getAlphaDisplay());
        copied.setColorBackground(origin.getColorBackground());
        copied.setColorText(origin.getColorText());
        copied.setSize(origin.getWidth(), origin.getHeight());
        copied.setLabelPosition(origin.getLabelPosition());
        copied.setTextAlignmentType(origin.getTextAlignmentType());
        copied.setHeaderAlignmentType(origin.getHeaderAlignmentType());
        copied.setHasBorder(origin.hasBorder());
        copied.setTextSize(origin.getTextSize());
        copied.setHeaderTextSize(origin.getHeaderTextSize());
        copied.setColorHeader(origin.getColorHeader());
        return copied;
    }

    private ComponentDescription copyComponentDescription(ComponentDescription origin) {
        ComponentDescription copied = new ComponentDescription(origin.getComponentInstallation());
        copied.setIsNodeIdTransient(origin.getIsNodeIdTransient());
        for (EndpointDescription ep : origin.getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            copied.getInputDescriptionsManager().addDynamicEndpointDescription(ep.getDynamicEndpointIdentifier(), ep.getName(), ep.getDataType(), ep.getMetaData(), ep.getParentGroupName(), false);
        }
        for (EndpointDescription ep : origin.getInputDescriptionsManager().getStaticEndpointDescriptions()) {
            copied.getInputDescriptionsManager().editStaticEndpointDescription(ep.getName(), ep.getDataType(), ep.getMetaData(), false);
        }
        for (EndpointDescription ep : origin.getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            copied.getOutputDescriptionsManager().addDynamicEndpointDescription(ep.getDynamicEndpointIdentifier(), ep.getName(), ep.getDataType(), ep.getMetaData(), ep.getParentGroupName(), false);
        }
        for (EndpointDescription ep : origin.getOutputDescriptionsManager().getStaticEndpointDescriptions()) {
            copied.getOutputDescriptionsManager().editStaticEndpointDescription(ep.getName(), ep.getDataType(), ep.getMetaData(), false);
        }
        for (EndpointGroupDescription epG : origin.getInputDescriptionsManager().getDynamicEndpointGroupDescriptions()) {
            copied.getInputDescriptionsManager().addDynamicEndpointGroupDescription(epG.getDynamicEndpointIdentifier(), epG.getName(), false);
        }
        copied.getConfigurationDescription().setConfiguration(new HashMap(origin.getConfigurationDescription().getConfiguration()));
        return copied;
    }
}

