/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.connections;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.workflow.EndpointContentProvider;
import de.rcenvironment.core.gui.workflow.EndpointHandlingHelper;
import de.rcenvironment.core.gui.workflow.EndpointLabelProvider;
import de.rcenvironment.core.gui.workflow.editor.commands.ConnectionAddCommand;
import de.rcenvironment.core.gui.workflow.editor.connections.ConnectionCanvas;
import de.rcenvironment.core.gui.workflow.editor.connections.EndpointTreeViewer;
import de.rcenvironment.core.gui.workflow.editor.connections.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConnectionDialogComposite
extends Composite {
    private static final Log LOGGER = LogFactory.getLog(ConnectionDialogComposite.class);
    private static final String SLASH = "/";
    private static final String SEMICOLON = ";";
    private static final String ENDPOINT_SEPARATOR = "###";
    private String selectionData;
    private EndpointTreeViewer sourceTreeViewer;
    private EndpointTreeViewer targetTreeViewer;
    private Tree sourceTree;
    private Tree targetTree;
    private ConnectionCanvas canvas;
    private ComponentViewerFilter sourceFilter;
    private ComponentViewerFilter targetFilter;
    private Text sourceFilterText;
    private Text targetFilterText;
    private WorkflowDescription workflowDescription;
    private Group targetGroup;
    private Group sourceGroup;
    private String sourceFilterString = "";
    private String targetFilterString = "";
    private FilterMode defaultFilterMode;
    private FilterMode sourceFilterMode = this.defaultFilterMode = FilterMode.ISEXACTLY;
    private FilterMode targetFilterMode = this.defaultFilterMode;
    private boolean wasDoubleClicked;
    private Cursor targetTreeDefaultCursor;
    private Cursor crossCursor = new Cursor((Device)Display.getCurrent(), 2);
    private TypedDatumConverter datumConverter;
    private CommandStack editorsCommandStack;
    private boolean initializedSection;

    public ConnectionDialogComposite(Composite parent, int style) {
        super(parent, style);
        this.sourceGroup = new Group((Composite)this, 0);
        this.sourceGroup.setText(Messages.source);
        GridData gridDataSourceGroup = new GridData(4, 4, true, true, 1, 1);
        gridDataSourceGroup.widthHint = 1;
        this.sourceGroup.setLayoutData((Object)gridDataSourceGroup);
        GridLayout gridLayoutSourceGroup = new GridLayout(1, false);
        gridLayoutSourceGroup.marginTop = 5;
        gridLayoutSourceGroup.marginWidth = 0;
        gridLayoutSourceGroup.verticalSpacing = 0;
        gridLayoutSourceGroup.marginHeight = 0;
        gridLayoutSourceGroup.horizontalSpacing = 0;
        this.sourceGroup.setLayout((Layout)gridLayoutSourceGroup);
        this.sourceTreeViewer = new EndpointTreeViewer((Composite)this.sourceGroup, 0);
        this.sourceTree = this.sourceTreeViewer.getTree();
        this.sourceTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sourceTree.setLinesVisible(true);
        this.sourceFilter = new ComponentViewerFilter();
        this.sourceTreeViewer.addFilter(this.sourceFilter);
        Group connectionGroup = new Group((Composite)this, 0);
        connectionGroup.setText(Messages.connections);
        GridData gridDataConnectionGroup = new GridData(4, 4, true, true, 1, 1);
        gridDataConnectionGroup.widthHint = 1;
        connectionGroup.setLayoutData((Object)gridDataConnectionGroup);
        GridLayout gridLayoutConnectionGroup = new GridLayout(1, false);
        gridLayoutConnectionGroup.marginTop = 5;
        gridLayoutConnectionGroup.verticalSpacing = 0;
        gridLayoutConnectionGroup.marginWidth = 0;
        gridLayoutConnectionGroup.marginHeight = 0;
        gridLayoutConnectionGroup.horizontalSpacing = 0;
        connectionGroup.setLayout((Layout)gridLayoutConnectionGroup);
        this.canvas = new ConnectionCanvas((Composite)connectionGroup, 0);
        this.canvas.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.canvas.setBackground(Display.getCurrent().getSystemColor(1));
        this.targetGroup = new Group((Composite)this, 0);
        this.targetGroup.setText(Messages.target);
        GridData gridDataTargetGroup = new GridData(4, 4, true, true, 1, 1);
        gridDataTargetGroup.widthHint = 1;
        this.targetGroup.setLayoutData((Object)gridDataTargetGroup);
        GridLayout gridLayoutTargetGroup = new GridLayout(1, false);
        gridLayoutTargetGroup.marginTop = 5;
        gridLayoutTargetGroup.verticalSpacing = 0;
        gridLayoutTargetGroup.marginWidth = 0;
        gridLayoutTargetGroup.marginHeight = 0;
        gridLayoutTargetGroup.horizontalSpacing = 0;
        this.targetGroup.setLayout((Layout)gridLayoutTargetGroup);
        this.targetTreeViewer = new EndpointTreeViewer((Composite)this.targetGroup, 0);
        this.targetTree = this.targetTreeViewer.getTree();
        this.targetTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.targetTree.setLinesVisible(true);
        this.targetFilter = new ComponentViewerFilter();
        this.targetTreeViewer.addFilter(this.targetFilter);
    }

    public void setWasDoubleClicked(boolean wasDoubleClicked) {
        this.wasDoubleClicked = wasDoubleClicked;
    }

    public void setSourceFilterMode(FilterMode sourceFilterMode) {
        this.sourceFilterMode = sourceFilterMode;
    }

    public void setTargetFilterMode(FilterMode targetFilterMode) {
        this.targetFilterMode = targetFilterMode;
    }

    public Group getTargetGroup() {
        return this.targetGroup;
    }

    public Group getSourceGroup() {
        return this.sourceGroup;
    }

    public void applyTargetFilter() {
        this.targetFilter.setExact(false);
        this.targetFilter.setFilterMode(this.targetFilterMode);
        this.targetFilter.setFilterString(this.targetFilterString);
        if (this.wasDoubleClicked) {
            this.targetFilter.setFilterMode(FilterMode.DOUBLECLICK);
            this.targetFilter.setFilterString(this.targetFilterString);
        }
        this.sourceTreeViewer.refresh();
        this.canvas.redraw();
        this.targetTreeViewer.refresh();
        this.targetTreeViewer.expandAll();
        this.sourceTreeViewer.expandAll();
    }

    public void applySourceFilter() {
        this.sourceFilter.setExact(false);
        this.sourceFilter.setFilterMode(this.sourceFilterMode);
        this.sourceFilter.setFilterString(this.sourceFilterString);
        if (this.wasDoubleClicked) {
            this.sourceFilter.setFilterMode(FilterMode.DOUBLECLICK);
            this.sourceFilter.setFilterString(this.sourceFilterString);
        }
        this.sourceTreeViewer.refresh();
        this.canvas.redraw();
        this.targetTreeViewer.refresh();
        this.targetTreeViewer.expandAll();
        this.sourceTreeViewer.expandAll();
    }

    public void setSourceFilterString(String sourceFilterString) {
        this.sourceFilterString = sourceFilterString;
    }

    public void setTargetFilterString(String targetFilterString) {
        this.targetFilterString = targetFilterString;
    }

    public Text getSourceFilterText() {
        return this.sourceFilterText;
    }

    public Text getTargetFilterText() {
        return this.targetFilterText;
    }

    public void setWorkflowDescription(WorkflowDescription workflowDescription) {
        this.workflowDescription = workflowDescription;
    }

    public void markSectionAsInitialized() {
        this.initializedSection = true;
    }

    private void selectOutputSource() {
        Object selectedElement = ((ITreeSelection)this.sourceTreeViewer.getSelection()).getFirstElement();
        this.selectionData = null;
        if (selectedElement instanceof EndpointContentProvider.Endpoint) {
            this.selectionData = ConnectionDialogComposite.getDataString((EndpointContentProvider.Endpoint)selectedElement);
        } else if (selectedElement instanceof WorkflowNode) {
            this.selectionData = ConnectionDialogComposite.getDataString((WorkflowNode)selectedElement);
        }
    }

    private static String getDataString(String nodeId, String endpointName) {
        return String.valueOf(nodeId) + SLASH + endpointName;
    }

    private static String getDataString(EndpointContentProvider.Endpoint endpoint) {
        return ConnectionDialogComposite.getDataString(endpoint.getWorkflowNode().getIdentifier(), endpoint.getEndpointDescription().getName());
    }

    private static String getDataString(WorkflowNode workflowNode) {
        StringBuffer data = new StringBuffer();
        for (EndpointDescription endpointDesc : workflowNode.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
            data.append(String.valueOf(ConnectionDialogComposite.getDataString(workflowNode.getIdentifier(), endpointDesc.getName())) + SEMICOLON);
        }
        return new String(data);
    }

    private boolean performEndpointDrop(String sourceNodeId, String sourceEndpointName, Object targetObject) {
        Connection connection2;
        WorkflowNode sourceNode = null;
        for (WorkflowNode node : this.workflowDescription.getWorkflowNodes()) {
            if (!node.getIdentifier().equals(sourceNodeId)) continue;
            sourceNode = node;
            break;
        }
        if (sourceNode == null) {
            LOGGER.warn((Object)("Connection could not be created because workflow node with id " + sourceNodeId + " was not found."));
            return false;
        }
        if (this.initializedSection) {
            return false;
        }
        EndpointContentProvider.Endpoint targetEndpoint = null;
        Object currentTarget = targetObject;
        if (currentTarget instanceof EndpointContentProvider.Endpoint) {
            targetEndpoint = (EndpointContentProvider.Endpoint)currentTarget;
        } else if (currentTarget instanceof WorkflowNode) {
            targetEndpoint = this.findEndpoint((WorkflowNode)currentTarget, sourceEndpointName);
        }
        if (targetEndpoint == null) {
            this.selectionData = "";
            return false;
        }
        EndpointDescriptionsManager endpointManager = sourceNode.getComponentDescription().getOutputDescriptionsManager();
        DataType sourceDataType = endpointManager.getEndpointDescription(sourceEndpointName).getDataType();
        if (sourceDataType != targetEndpoint.getEndpointDescription().getDataType() && !this.datumConverter.isConvertibleTo(sourceDataType, targetEndpoint.getEndpointDescription().getDataType())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.error, (String)StringUtils.format((String)Messages.incompatibleTypes, (Object[])new Object[]{sourceDataType.getDisplayName(), targetEndpoint.getEndpointDescription().getDataType().getDisplayName()}));
            return false;
        }
        Connection connectedTo = null;
        for (Connection c : this.workflowDescription.getConnections()) {
            if (!c.getTargetNode().equals((Object)targetEndpoint.getWorkflowNode()) || !targetEndpoint.getEndpointDescription().getIdentifier().equals(c.getInput().getIdentifier())) continue;
            connectedTo = c;
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.error, (String)StringUtils.format((String)Messages.alreadyConnected, (Object[])new Object[]{targetEndpoint.getName(), connectedTo.getOutput().getName(), connectedTo.getSourceNode().getName()}));
            return false;
        }
        List alreadyExistentBendpoints = new ArrayList();
        for (Connection connection2 : this.workflowDescription.getConnections()) {
            if (!connection2.getSourceNode().getIdentifier().equals(sourceNode.getIdentifier()) || !connection2.getTargetNode().getIdentifier().equals(targetEndpoint.getWorkflowNode().getIdentifier())) continue;
            alreadyExistentBendpoints = connection2.getBendpoints();
            break;
        }
        connection2 = new Connection(sourceNode, endpointManager.getEndpointDescription(sourceEndpointName), targetEndpoint.getWorkflowNode(), targetEndpoint.getEndpointDescription(), alreadyExistentBendpoints);
        ConnectionAddCommand command = new ConnectionAddCommand(this.workflowDescription, connection2);
        if (this.editorsCommandStack != null) {
            this.editorsCommandStack.execute((Command)command);
        } else {
            command.execute();
        }
        return true;
    }

    private EndpointContentProvider.Endpoint findEndpoint(WorkflowNode workflowNode, String name) {
        for (EndpointContentProvider.Endpoint e : EndpointHandlingHelper.getEndpoints(workflowNode, EndpointType.INPUT)) {
            if (!e.getEndpointDescription().getName().equals(name)) continue;
            return e;
        }
        for (EndpointContentProvider.Endpoint e : EndpointHandlingHelper.getEndpoints(workflowNode, EndpointType.INPUT)) {
            DataType sourceOutputDataType;
            DataType targetInputDataType;
            TreeSelection selection;
            int targetInputs = workflowNode.getInputDescriptionsManager().getEndpointDescriptions().size();
            WorkflowNode sourceNode = null;
            if (this.sourceTreeViewer.getSelection() instanceof TreeSelection && (selection = (TreeSelection)this.sourceTreeViewer.getSelection()).getFirstElement() instanceof WorkflowNode) {
                sourceNode = (WorkflowNode)selection.getFirstElement();
            }
            if (sourceNode == null) continue;
            int sourceOutputs = sourceNode.getOutputDescriptionsManager().getEndpointDescriptions().size();
            if (targetInputs != 1 || sourceOutputs != 1 || !(targetInputDataType = ((EndpointDescription)workflowNode.getInputDescriptionsManager().getEndpointDescriptions().toArray()[0]).getDataType()).equals((Object)(sourceOutputDataType = ((EndpointDescription)sourceNode.getOutputDescriptionsManager().getEndpointDescriptions().toArray()[0]).getDataType()))) continue;
            return e;
        }
        return null;
    }

    private void expandSelectedSourceNode() {
        TreeSelection selection;
        if (this.sourceTreeViewer.getSelection() instanceof TreeSelection && (selection = (TreeSelection)this.sourceTreeViewer.getSelection()).getFirstElement() instanceof WorkflowNode) {
            WorkflowNode node = (WorkflowNode)selection.getFirstElement();
            TreeItem[] treeItemArray = this.sourceTree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getText().equals(node.getName())) {
                    item.setExpanded(true);
                    this.sourceTreeViewer.refresh();
                }
                ++n2;
            }
        }
    }

    private void expandTargetNode(Object target) {
        if (target instanceof WorkflowNode) {
            WorkflowNode node = (WorkflowNode)target;
            TreeItem[] treeItemArray = this.targetTree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getText().equals(node.getName())) {
                    item.setExpanded(true);
                    this.targetTreeViewer.refresh();
                }
                ++n2;
            }
        }
    }

    public void updateConnectionViewer(WorkflowDescription newModel) {
        if (!(this.sourceTree.isDisposed() || this.targetTree.isDisposed() || this.canvas.isDisposed())) {
            this.targetTreeViewer.refresh(true);
            this.sourceTreeViewer.refresh(true);
            this.canvas.repaint();
        }
    }

    public void initialize(WorkflowDescription model, WorkflowNode sourceWorkflowNode, WorkflowNode targetWorkflowNode) {
        this.workflowDescription = model;
        this.sourceTreeViewer.setLabelProvider((IBaseLabelProvider)new EndpointLabelProvider(EndpointType.OUTPUT));
        this.targetTreeViewer.setLabelProvider((IBaseLabelProvider)new EndpointLabelProvider(EndpointType.INPUT));
        this.sourceTreeViewer.setContentProvider((IContentProvider)new EndpointContentProvider(EndpointType.OUTPUT));
        this.targetTreeViewer.setContentProvider((IContentProvider)new EndpointContentProvider(EndpointType.INPUT));
        this.sourceTreeViewer.setInput(this.workflowDescription);
        this.targetTreeViewer.setInput(this.workflowDescription);
        if (sourceWorkflowNode != null) {
            this.sourceFilterString = sourceWorkflowNode.getName();
            this.sourceTreeViewer.expandToLevel(sourceWorkflowNode, 2);
            this.sourceTreeViewer.setSelection((ISelection)new StructuredSelection((Object)sourceWorkflowNode));
        }
        if (targetWorkflowNode != null) {
            this.targetFilterString = targetWorkflowNode.getName();
            this.targetTreeViewer.expandToLevel(targetWorkflowNode, 2);
            this.targetTreeViewer.setSelection((ISelection)new StructuredSelection((Object)targetWorkflowNode));
        }
        this.canvas.initialize(this.workflowDescription, this.sourceTreeViewer, this.targetTreeViewer);
        this.sourceTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ConnectionDialogComposite.this.canvas.repaint();
            }
        });
        this.targetTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ConnectionDialogComposite.this.canvas.repaint();
            }
        });
        this.canvas.repaint();
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        TypedDatumService typedDatumService = (TypedDatumService)serviceRegistryAccess.getService(TypedDatumService.class);
        this.datumConverter = typedDatumService.getConverter();
        int operations = 3;
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        this.sourceTreeViewer.addDragSupport(operations, transfer, new OutputDragSourceListener());
        InputViewerDropAdapter dropAdapter = new InputViewerDropAdapter();
        dropAdapter.setFeedbackEnabled(false);
        Transfer[] dropTransfer = new Transfer[]{TextTransfer.getInstance()};
        this.targetTreeViewer.addDropSupport(operations, dropTransfer, (DropTargetListener)dropAdapter);
        this.targetTreeViewer.addSelectionChangedListener(new InputTargetSelectionListener());
        this.sourceTreeViewer.addSelectionChangedListener(new OutputSourceSelectionListener());
        this.targetTreeDefaultCursor = this.targetTree.getCursor();
        this.targetTree.addMouseMoveListener((MouseMoveListener)new TargetTreeMouseMoveListener());
        this.sourceTreeViewer.expandAll();
        this.targetTreeViewer.expandAll();
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }

    public ConnectionCanvas getCanvas() {
        return this.canvas;
    }

    public EndpointTreeViewer getSourceTreeViewer() {
        return this.sourceTreeViewer;
    }

    public EndpointTreeViewer getTargetTreeViewer() {
        return this.targetTreeViewer;
    }

    private void setTargetTreeCursorToDefault() {
        this.targetTree.setCursor(this.targetTreeDefaultCursor);
    }

    public void setCommandStack(CommandStack editorsCommandStack2) {
        this.editorsCommandStack = editorsCommandStack2;
    }

    public class ComponentViewerFilter
    extends ViewerFilter {
        private String filterString = "";
        private boolean exact = false;
        private FilterMode filterMode;

        public ComponentViewerFilter() {
            this.filterMode = ConnectionDialogComposite.this.defaultFilterMode;
        }

        public void setFilterMode(FilterMode filterMode) {
            this.filterMode = filterMode;
        }

        public boolean select(Viewer arg0, Object arg1, Object arg2) {
            if (arg2 instanceof WorkflowNode) {
                WorkflowNode item = (WorkflowNode)arg2;
                if (this.filterString.isEmpty()) {
                    return true;
                }
                if (this.filterMode.equals((Object)FilterMode.CONTAINS) ? !item.getName().toLowerCase().contains(this.filterString.toLowerCase()) : (this.filterMode.equals((Object)FilterMode.STARTSWITH) ? !item.getName().toLowerCase().startsWith(this.filterString.toLowerCase()) : (this.filterMode.equals((Object)FilterMode.ISEXACTLY) ? !item.getName().toLowerCase().equals(this.filterString.toLowerCase()) : this.filterMode.equals((Object)FilterMode.DOUBLECLICK) && !item.getName().toLowerCase().equals(this.filterString.toLowerCase())))) {
                    return false;
                }
            }
            return true;
        }

        public String getFilterString() {
            return this.filterString;
        }

        public void setFilterString(String filterString) {
            this.filterString = filterString;
        }

        public boolean isExact() {
            return this.exact;
        }

        public void setExact(boolean exact) {
            this.exact = exact;
        }

        public void configureFilter(String filter, FilterMode filterModus) {
            this.filterString = filter;
            this.filterMode = filterModus;
        }
    }

    public static enum FilterMode {
        CONTAINS,
        STARTSWITH,
        ISEXACTLY,
        DOUBLECLICK;

    }

    public class InputTargetSelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            if (!event.getSelection().isEmpty() && ConnectionDialogComposite.this.selectionData != null) {
                Object currentTarget = ((ITreeSelection)event.getSelection()).getFirstElement();
                Object currentSource = ((ITreeSelection)ConnectionDialogComposite.this.sourceTreeViewer.getSelection()).getFirstElement();
                boolean selectionTypesEqual = false;
                if (currentSource != null) {
                    if (currentSource.getClass() == currentTarget.getClass()) {
                        selectionTypesEqual = true;
                    }
                    if (selectionTypesEqual && (currentTarget instanceof EndpointContentProvider.Endpoint || currentTarget instanceof WorkflowNode)) {
                        this.connectEqualTypes(currentTarget);
                    }
                }
                ConnectionDialogComposite.this.canvas.repaint();
                ConnectionDialogComposite.this.targetTreeViewer.refresh();
                ConnectionDialogComposite.this.sourceTreeViewer.refresh();
            }
        }

        private void connectEqualTypes(Object currentTarget) {
            String[] stringArray = ConnectionDialogComposite.this.selectionData.split(Pattern.quote(ConnectionDialogComposite.SEMICOLON));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sourceString = stringArray[n2];
                String[] splittedSourceString = sourceString.split(Pattern.quote(ConnectionDialogComposite.SLASH), 2);
                if (splittedSourceString.length > 1 && ConnectionDialogComposite.this.performEndpointDrop(splittedSourceString[0], splittedSourceString[1], currentTarget)) {
                    ConnectionDialogComposite.this.setTargetTreeCursorToDefault();
                }
                ++n2;
            }
        }
    }

    public class InputViewerDropAdapter
    extends ViewerDropAdapter {
        public InputViewerDropAdapter() {
            super((Viewer)ConnectionDialogComposite.this.targetTreeViewer);
        }

        public boolean performDrop(Object element) {
            boolean performed = false;
            boolean successful = false;
            Object currentTarget = this.getCurrentTarget();
            if (currentTarget instanceof EndpointContentProvider.Endpoint || currentTarget instanceof WorkflowNode) {
                String[] stringArray = ((String)element).split(Pattern.quote(ConnectionDialogComposite.SEMICOLON));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String sourceString = stringArray[n2];
                    String[] splittedSourceString = sourceString.split(Pattern.quote(ConnectionDialogComposite.SLASH), 2);
                    successful = ConnectionDialogComposite.this.performEndpointDrop(splittedSourceString[0], splittedSourceString[1], currentTarget);
                    ++n2;
                }
                performed = true;
            }
            if (!successful) {
                ConnectionDialogComposite.this.expandTargetNode(this.getCurrentTarget());
                ConnectionDialogComposite.this.expandSelectedSourceNode();
            }
            ConnectionDialogComposite.this.canvas.repaint();
            ConnectionDialogComposite.this.targetTreeViewer.refresh();
            ConnectionDialogComposite.this.sourceTreeViewer.refresh();
            if (ConnectionDialogComposite.this.selectionData != null) {
                if (ConnectionDialogComposite.this.selectionData.isEmpty()) {
                    ConnectionDialogComposite.this.setTargetTreeCursorToDefault();
                }
            } else if (ConnectionDialogComposite.this.selectionData == null) {
                ConnectionDialogComposite.this.setTargetTreeCursorToDefault();
            }
            return performed;
        }

        public boolean validateDrop(Object dest, int operation, TransferData transferType) {
            int endpoints = 0;
            if (dest instanceof WorkflowNode) {
                endpoints = ((WorkflowNode)dest).getComponentDescription().getInputDescriptionsManager().getEndpointDescriptions().size();
            }
            boolean selectionValid = false;
            if (ConnectionDialogComposite.this.selectionData != null && !ConnectionDialogComposite.this.selectionData.isEmpty()) {
                selectionValid = true;
            }
            Object currentSource = ((ITreeSelection)ConnectionDialogComposite.this.sourceTreeViewer.getSelection()).getFirstElement();
            boolean selectionTypesEqual = false;
            if (currentSource != null && dest != null && currentSource.getClass() == dest.getClass()) {
                selectionTypesEqual = true;
            }
            boolean valid = TextTransfer.getInstance().isSupportedType(transferType) && (dest instanceof EndpointContentProvider.Endpoint || dest instanceof WorkflowNode && endpoints > 0) && selectionValid && selectionTypesEqual;
            return valid;
        }
    }

    public class OutputDragSourceListener
    implements DragSourceListener {
        public void dragFinished(DragSourceEvent event) {
        }

        public void dragSetData(DragSourceEvent event) {
            Object selectedElement = ((ITreeSelection)ConnectionDialogComposite.this.sourceTreeViewer.getSelection()).getFirstElement();
            if (selectedElement instanceof EndpointContentProvider.Endpoint) {
                ConnectionDialogComposite.this.selectionData = ConnectionDialogComposite.getDataString((EndpointContentProvider.Endpoint)selectedElement);
            } else if (selectedElement instanceof WorkflowNode) {
                ConnectionDialogComposite.this.selectionData = ConnectionDialogComposite.getDataString((WorkflowNode)selectedElement);
            }
            event.data = ConnectionDialogComposite.this.selectionData;
        }

        public void dragStart(DragSourceEvent event) {
            Object item = ((ITreeSelection)ConnectionDialogComposite.this.sourceTreeViewer.getSelection()).getFirstElement();
            event.doit = item instanceof EndpointContentProvider.Endpoint || item instanceof WorkflowNode;
        }
    }

    public class OutputSourceSelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent e) {
            if (ConnectionDialogComposite.this.initializedSection) {
                ConnectionDialogComposite.this.initializedSection = false;
            } else {
                ConnectionDialogComposite.this.selectOutputSource();
            }
        }
    }

    private final class TargetTreeMouseMoveListener
    implements MouseMoveListener {
        private TargetTreeMouseMoveListener() {
        }

        public void mouseMove(MouseEvent event) {
            if (ConnectionDialogComposite.this.selectionData != null) {
                int n;
                int n2;
                Object[] objectArray;
                Class<EndpointContentProvider.Endpoint> endpointClass = EndpointContentProvider.Endpoint.class;
                Class<WorkflowNode> workflowNodeClass = WorkflowNode.class;
                Object currentSource = ((ITreeSelection)ConnectionDialogComposite.this.sourceTreeViewer.getSelection()).getFirstElement();
                Class targetType = null;
                boolean selectionTypesEqual = false;
                String hoveredComponentName = "";
                String hoveredEndpointName = "";
                Point pt = new Point(event.x, event.y);
                TreeItem[] treeItemArray = ConnectionDialogComposite.this.targetTree.getItems();
                int n3 = treeItemArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem firstLevelItem = treeItemArray[n4];
                    if (firstLevelItem.getBounds().contains(pt)) {
                        targetType = workflowNodeClass;
                        hoveredComponentName = firstLevelItem.getText();
                        break;
                    }
                    objectArray = firstLevelItem.getItems();
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        TreeItem secondLevelItem = objectArray[n];
                        if (secondLevelItem.getBounds().contains(pt)) {
                            targetType = endpointClass;
                            hoveredEndpointName = secondLevelItem.getText();
                            hoveredComponentName = secondLevelItem.getParentItem().getText();
                            break;
                        }
                        ++n;
                    }
                    ++n4;
                }
                if (currentSource != null && targetType != null && currentSource.getClass() == targetType) {
                    selectionTypesEqual = true;
                }
                if (hoveredComponentName.isEmpty() || hoveredEndpointName.isEmpty()) {
                    ConnectionDialogComposite.this.setTargetTreeCursorToDefault();
                }
                if (selectionTypesEqual) {
                    for (WorkflowNode node : ConnectionDialogComposite.this.workflowDescription.getWorkflowNodes()) {
                        if (node.getName().equals(hoveredComponentName) && targetType == endpointClass) {
                            EndpointDescription targetEndpoint = node.getInputDescriptionsManager().getEndpointDescription(hoveredEndpointName);
                            String[] sourceCandidates = ConnectionDialogComposite.this.selectionData.split(ConnectionDialogComposite.SEMICOLON);
                            objectArray = sourceCandidates;
                            n2 = sourceCandidates.length;
                            n = 0;
                            while (n < n2) {
                                TreeItem candidate = objectArray[n];
                                this.checkCandidateForCursorSetting(targetEndpoint, (String)candidate);
                                ++n;
                            }
                            continue;
                        }
                        if (!node.getName().equals(hoveredComponentName) || targetType != workflowNodeClass || ConnectionDialogComposite.this.initializedSection) continue;
                        ConnectionDialogComposite.this.targetTreeDefaultCursor = ConnectionDialogComposite.this.targetTree.getParent().getCursor();
                        ConnectionDialogComposite.this.targetTree.setCursor(ConnectionDialogComposite.this.crossCursor);
                        break;
                    }
                } else {
                    ConnectionDialogComposite.this.setTargetTreeCursorToDefault();
                }
            }
        }

        private void checkCandidateForCursorSetting(EndpointDescription targetEndpoint, String candidate) {
            boolean isConnected = targetEndpoint.isConnected();
            if (candidate.split(ConnectionDialogComposite.SLASH).length > 1) {
                boolean typeCompatible;
                String sourceComponent = candidate.split(ConnectionDialogComposite.SLASH)[0];
                String sourceEndpoint = candidate.split(ConnectionDialogComposite.SLASH)[1];
                DataType sourceDataType = ConnectionDialogComposite.this.workflowDescription.getWorkflowNode(sourceComponent).getOutputDescriptionsManager().getEndpointDescription(sourceEndpoint).getDataType();
                DataType targetDataType = targetEndpoint.getDataType();
                boolean bl = typeCompatible = ConnectionDialogComposite.this.datumConverter.isConvertibleTo(sourceDataType, targetDataType) || sourceDataType.equals((Object)targetDataType);
                if (!isConnected && typeCompatible && !ConnectionDialogComposite.this.initializedSection) {
                    ConnectionDialogComposite.this.targetTreeDefaultCursor = ConnectionDialogComposite.this.targetTree.getParent().getCursor();
                    ConnectionDialogComposite.this.targetTree.setCursor(ConnectionDialogComposite.this.crossCursor);
                } else {
                    ConnectionDialogComposite.this.setTargetTreeCursorToDefault();
                }
            }
        }
    }
}

