/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands.endpoint;

import de.rcenvironment.core.gui.workflow.editor.properties.Refreshable;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import java.util.ArrayList;
import java.util.List;

public class ProcessEndpointsGroupCommand
extends WorkflowNodeCommand {
    protected WorkflowNodeCommand.Executor executor;
    protected Refreshable[] refreshable;
    protected List<WorkflowNodeCommand> commands = new ArrayList<WorkflowNodeCommand>();
    private boolean executable = true;
    private boolean undoable = false;

    public ProcessEndpointsGroupCommand(WorkflowNodeCommand.Executor executor, Refreshable ... refreshable) {
        this.executor = executor;
        this.refreshable = refreshable;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean canExecute() {
        return this.executable;
    }

    @Override
    public void execute() {
        if (this.executable) {
            for (WorkflowNodeCommand command : this.commands) {
                command.setWorkflowNode(super.getWorkflowNode());
                command.setCommandStack(this.commandStack);
                command.execute();
            }
            this.executable = false;
            this.undoable = true;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    @Override
    public boolean canUndo() {
        return this.undoable;
    }

    @Override
    public void undo() {
        if (this.undoable) {
            for (WorkflowNodeCommand command : this.commands) {
                command.undo();
            }
            this.executable = true;
            this.undoable = false;
        }
        if (this.refreshable != null) {
            Refreshable[] refreshableArray = this.refreshable;
            int n = this.refreshable.length;
            int n2 = 0;
            while (n2 < n) {
                Refreshable r = refreshableArray[n2];
                r.refresh();
                ++n2;
            }
        }
    }

    public void add(WorkflowNodeCommand command) {
        if (this.undoable) {
            return;
        }
        this.commands.add(command);
    }
}

