/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class WorkflowEditorHelpContextProvider
implements IContextProvider {
    private GraphicalViewer viewer;
    private ToolIntegrationContextRegistry toolIntegrationRegistry;

    public WorkflowEditorHelpContextProvider(GraphicalViewer viewer) {
        this.viewer = viewer;
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        this.toolIntegrationRegistry = (ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
    }

    public IContext getContext(Object arg0) {
        Object object = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (object instanceof WorkflowNodePart) {
            WorkflowNodePart nodePart = (WorkflowNodePart)object;
            String componentIdentifier = ((WorkflowNode)nodePart.getModel()).getComponentDescription().getIdentifier();
            if (this.toolIntegrationRegistry.hasId(componentIdentifier)) {
                return HelpSystem.getContext((String)"de.rcenvironment.integration.*");
            }
            if (componentIdentifier.contains("de.rcenvironment.remoteaccess")) {
                return HelpSystem.getContext((String)"de.rcenvironment.remoteaccess.*");
            }
            return HelpSystem.getContext((String)componentIdentifier.substring(0, componentIdentifier.lastIndexOf("/")));
        }
        if (object instanceof ConnectionPart) {
            return HelpSystem.getContext((String)"de.rcenvironment.connectionEditorContext");
        }
        if (object instanceof WorkflowLabelPart) {
            return HelpSystem.getContext((String)"de.rcenvironment.workflowLabelContext");
        }
        if (object instanceof WorkflowPart) {
            return HelpSystem.getContext((String)"de.rcenvironment.workflowEditorContext");
        }
        if (object instanceof WorkflowExecutionInformationPart) {
            return HelpSystem.getContext((String)"de.rcenvironment.runtimeWorkflowEditorContext");
        }
        return HelpSystem.getContext((String)"de.rcenvironment.rce.gui.workflow.editor");
    }

    public int getContextChangeMask() {
        return 1;
    }

    public String getSearchExpression(Object arg0) {
        return null;
    }
}

