/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views;

import de.rcenvironment.core.communication.common.NetworkGraphLink;
import de.rcenvironment.core.communication.common.NetworkGraphNode;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NetworkViewLabelProvider
extends LabelProvider {
    private Image nodeImage;
    private Image folderImage;
    private Image infoImage;
    private Image networkImage;
    private Image connectionImage;
    private Image disconnectImage;
    private boolean optionNodeIdsVisible;

    public NetworkViewLabelProvider() {
        this.createImages();
    }

    public void setNodeIdsVisible(boolean value) {
        this.optionNodeIdsVisible = value;
    }

    public String getText(Object element) {
        if (element instanceof SelfRenderingNetworkViewNode) {
            return ((SelfRenderingNetworkViewNode)element).getText();
        }
        if (element instanceof ContributedNetworkViewNode && ((ContributedNetworkViewNode)element).getContributor() != null) {
            return ((ContributedNetworkViewNode)element).getContributor().getText(element);
        }
        if (element == AnchorPoints.INSTANCES_PARENT_NODE) {
            return "Instances";
        }
        if (element == AnchorPoints.MAIN_NETWORK_SECTION_PARENT_NODE) {
            return "RCE Network";
        }
        if (element == AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE) {
            return "SSH Remote Access";
        }
        if (element instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)element;
            switch (typedNode.getContext()) {
                case ROOT: {
                    NetworkGraphNode node = typedNode.getNode();
                    String result = typedNode.getDisplayNameOfNode();
                    if (this.optionNodeIdsVisible) {
                        result = String.valueOf(result) + "  [" + node.getNodeId().getInstanceNodeSessionIdString() + "] ";
                    }
                    if (typedNode.isWorkflowHost()) {
                        result = String.valueOf(result) + " <Workflow Host>";
                    }
                    if (typedNode.isLocalNode()) {
                        result = String.valueOf(result) + " <Self>";
                    }
                    return result;
                }
                case RAW_NODE_PROPERTIES_FOLDER: {
                    return "Raw Node Properties";
                }
                case RAW_NODE_PROPERTY: {
                    return typedNode.getDisplayText();
                }
            }
            return "<error>";
        }
        String result = element instanceof NetworkGraphLink ? ((NetworkGraphLink)element).getLinkId() : element.toString();
        return result;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof SelfRenderingNetworkViewNode) {
            return ((SelfRenderingNetworkViewNode)element).getImage();
        }
        if (element instanceof ContributedNetworkViewNode && ((ContributedNetworkViewNode)element).getContributor() != null) {
            return ((ContributedNetworkViewNode)element).getContributor().getImage(element);
        }
        if (element instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)element;
            switch (typedNode.getContext()) {
                case ROOT: {
                    result = this.nodeImage;
                    break;
                }
                case RAW_NODE_PROPERTIES_FOLDER: 
                case RESOURCE_MONITORING_FOLDER: {
                    result = this.folderImage;
                    break;
                }
                case RAW_NODE_PROPERTY: {
                    result = this.infoImage;
                    break;
                }
                default: {
                    result = null;
                    break;
                }
            }
        } else if (element instanceof NetworkGraphLink) {
            result = this.connectionImage;
        } else if (element == AnchorPoints.INSTANCES_PARENT_NODE) {
            result = this.nodeImage;
        } else if (element == AnchorPoints.MAIN_NETWORK_SECTION_PARENT_NODE) {
            result = this.networkImage;
        } else if (element == AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE) {
            result = this.networkImage;
        }
        if (result == null) {
            result = super.getImage(element);
        }
        return result;
    }

    public void dispose() {
        this.disposeImages();
    }

    private void createImages() {
        ImageManager imageManager = ImageManager.getInstance();
        this.folderImage = imageManager.getSharedImage((ImageSource)StandardImages.FOLDER_16);
        this.infoImage = imageManager.getSharedImage((ImageSource)StandardImages.INFORMATION_16);
        this.nodeImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/node.png")).createImage();
        this.networkImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/network.gif")).createImage();
        this.connectionImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/connect.png")).createImage();
        this.disconnectImage = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/resources/icons/disconnect.png")).createImage();
    }

    private void disposeImages() {
        this.nodeImage.dispose();
        this.networkImage.dispose();
        this.connectionImage.dispose();
        this.disconnectImage.dispose();
    }
}

