/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionContext;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionStatsService;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class ComponentExecutionStatsServiceImpl
implements ComponentExecutionStatsService {
    private static final int THOUSAND = 1000;
    private static final String CAT_COMP_EXEC = "Workflow Component Execution: Component runs";
    private static final String CAT_COMP_EXEC_USAGE_PER_WF = "Workflow Component Execution: Usage count by workflows";
    private static final String CAT_COMP_EXEC_DURATION = "Workflow Component Execution: Duration [sec]";
    private static final String CAT_COMP_EXEC_CTRL = "Workflow Component Execution: Location of workflow controller";
    private static final String CAT_COMP_EXEC_FINAL_STATES = "Workflow Component Execution: Final states";
    private static final String KEY_LOCAL_WF_CTRL = "[local]";
    private PlatformService platformService;
    private Map<String, Long> compExeStartTimestamps = Collections.synchronizedMap(new HashMap());

    @Override
    public void addStatsAtComponentStart(ComponentExecutionContext compExeCtx) {
        StatsCounter.count((String)CAT_COMP_EXEC_USAGE_PER_WF, (String)compExeCtx.getComponentDescription().getName());
        if (this.platformService.matchesLocalInstance((ResolvableNodeId)compExeCtx.getWorkflowNodeId())) {
            StatsCounter.count((String)CAT_COMP_EXEC_CTRL, (String)KEY_LOCAL_WF_CTRL);
        } else {
            StatsCounter.count((String)CAT_COMP_EXEC_CTRL, (String)compExeCtx.getWorkflowNodeId().toString());
        }
    }

    @Override
    public void addStatsAtComponentRunStart(ComponentExecutionContext compExeCtx) {
        if (this.compExeStartTimestamps.containsKey(compExeCtx.getExecutionIdentifier())) {
            LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Stats about duration for component '%s' (%s) not recorded properly: last time (start record but no termination record existed)", (Object[])new Object[]{compExeCtx.getInstanceName(), compExeCtx.getExecutionIdentifier()}));
        }
        this.compExeStartTimestamps.put(compExeCtx.getExecutionIdentifier(), System.currentTimeMillis());
        StatsCounter.count((String)CAT_COMP_EXEC, (String)compExeCtx.getComponentDescription().getName());
    }

    @Override
    public void addStatsAtComponentRunTermination(ComponentExecutionContext compExeCtx) {
        if (this.compExeStartTimestamps.containsKey(compExeCtx.getExecutionIdentifier())) {
            StatsCounter.registerValue((String)CAT_COMP_EXEC_DURATION, (String)compExeCtx.getComponentDescription().getName(), (long)Math.abs((System.currentTimeMillis() - this.compExeStartTimestamps.get(compExeCtx.getExecutionIdentifier())) / 1000L));
            this.compExeStartTimestamps.remove(compExeCtx.getExecutionIdentifier());
        } else {
            LogFactory.getLog(this.getClass()).error((Object)StringUtils.format((String)"Failed to add stats about duration for component '%s' (%s)", (Object[])new Object[]{compExeCtx.getInstanceName(), compExeCtx.getExecutionIdentifier()}));
        }
    }

    @Override
    public void addStatsAtComponentTermination(ComponentExecutionContext compExeCtx, ComponentState finalCompState) {
        StatsCounter.count((String)CAT_COMP_EXEC_FINAL_STATES, (String)finalCompState.getDisplayName());
    }

    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }
}

