/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionUtils;
import de.rcenvironment.core.component.execution.internal.InternalTDImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentContextBridge {
    private static final String NOT_CONVERTIBLE_MESSAGE = "Datum of type '%s' is not convertible to data type '%s' expected by input '%s'";
    private static final Log LOG = LogFactory.getLog(ComponentContextBridge.class);
    private static TypedDatumService typedDatumService;
    private final Map<String, DataType> inputDataTypes = new HashMap<String, DataType>();
    private ComponentExecutionRelatedInstances compExeRelatedInstances;
    private Map<String, EndpointDatum> endpointDatumsForExecution = Collections.synchronizedMap(new HashMap());
    private Map<String, Boolean> closedOutputs = Collections.synchronizedMap(new HashMap());
    private List<OutputHolder> outputsOnHold = Collections.synchronizedList(new ArrayList());
    private final Object historyDataLock = new Object();

    @Deprecated
    public ComponentContextBridge() {
    }

    public ComponentContextBridge(ComponentExecutionRelatedInstances compExeRelatedInstances) {
        this.compExeRelatedInstances = compExeRelatedInstances;
        for (EndpointDescription epDesc : compExeRelatedInstances.compExeCtx.getComponentDescription().getInputDescriptionsManager().getEndpointDescriptions()) {
            this.inputDataTypes.put(epDesc.getName(), epDesc.getDataType());
        }
    }

    public synchronized void writeOutput(String outputName, TypedDatum datumToSend) {
        EndpointDescription endpointDescription = this.compExeRelatedInstances.compExeCtx.getComponentDescription().getOutputDescriptionsManager().getEndpointDescription(outputName);
        Long outputDmId = null;
        try {
            outputDmId = this.compExeRelatedInstances.compExeStorageBridge.addOutput(outputName, typedDatumService.getSerializer().serialize(datumToSend));
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeException(e);
        }
        if (endpointDescription.isConnected()) {
            this.validateOutputDataType(outputName, endpointDescription.getDataType(), datumToSend);
            if (ComponentExecutionUtils.isManualOutputVerificationRequired(this.compExeRelatedInstances.compExeCtx.getComponentDescription().getConfigurationDescription())) {
                this.holdOutput(outputName, datumToSend, outputDmId);
            } else {
                this.sendOutput(outputName, datumToSend, outputDmId);
            }
        }
        this.closedOutputs.put(outputName, false);
    }

    private void sendOutput(String outputName, TypedDatum datumToSend, Long outputDmId) {
        this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutput(outputName, datumToSend, outputDmId);
        if (datumToSend.getDataType().equals((Object)DataType.NotAValue)) {
            this.compExeRelatedInstances.compExeScheduler.addNotAValueDatumSent(((NotAValueTD)datumToSend).getIdentifier());
        }
    }

    protected void holdOutput(String outputName, TypedDatum datumToSend, Long outputDmId) {
        this.outputsOnHold.add(new OutputHolder(outputName, datumToSend, outputDmId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushOutputs() {
        List<OutputHolder> list = this.outputsOnHold;
        synchronized (list) {
            for (OutputHolder outputHolder : this.outputsOnHold) {
                this.sendOutput(outputHolder.outputName, outputHolder.datumToSend, outputHolder.outputDmId);
            }
        }
    }

    protected void setEndpointDatumsForExecution(Map<String, EndpointDatum> endpointDatumsForExecution) throws ComponentExecutionException {
        this.endpointDatumsForExecution.clear();
        this.endpointDatumsForExecution.putAll(endpointDatumsForExecution);
        this.validateEndpointDatumsForExecution();
    }

    protected Map<String, EndpointDatum> getEndpointDatumsForExecution() {
        return Collections.unmodifiableMap(this.endpointDatumsForExecution);
    }

    private void validateIfNestedLoopComponent() {
        if (!this.compExeRelatedInstances.isNestedLoopDriver) {
            throw new RuntimeException(String.valueOf(this.getLogMessagesPrefix()) + StringUtils.format((String)"Received reset datum for a non nested loop component. Reset datums are only allowed to send by nested loop components.", (Object[])new Object[0]));
        }
    }

    private void validateEndpointDatumsForExecution() throws ComponentExecutionException {
        for (EndpointDatum endpointDatum : this.endpointDatumsForExecution.values()) {
            DataType inputDataType = this.inputDataTypes.get(endpointDatum.getInputName());
            if (endpointDatum.getValue().getDataType() == inputDataType || endpointDatum.getValue().getDataType() == DataType.NotAValue || typedDatumService.getConverter().isConvertibleTo(endpointDatum.getValue(), inputDataType)) continue;
            throw new ComponentExecutionException(StringUtils.format((String)NOT_CONVERTIBLE_MESSAGE, (Object[])new Object[]{endpointDatum.getValue().getDataType(), inputDataType, endpointDatum.getInputName()}));
        }
    }

    private void validateOutputDataType(String outputName, DataType dataType, TypedDatum datumToSent) {
        if (!datumToSent.getDataType().equals((Object)DataType.NotAValue) && !datumToSent.getDataType().equals((Object)DataType.Internal) && datumToSent.getDataType() != dataType) {
            TypedDatumConverter converter = typedDatumService.getConverter();
            if (converter.isConvertibleTo(datumToSent, dataType)) {
                try {
                    datumToSent = converter.castOrConvert(datumToSent, dataType);
                }
                catch (DataTypeException dataTypeException) {
                    throw new RuntimeException(String.valueOf(this.getLogMessagesPrefix()) + StringUtils.format((String)("Failed to convert the value for output '" + outputName + "' from type " + datumToSent.getDataType() + " to required data type " + dataType), (Object[])new Object[0]));
                }
            } else {
                throw new RuntimeException(String.valueOf(this.getLogMessagesPrefix()) + StringUtils.format((String)("Value for output '" + outputName + "' has invalid data type. Output requires " + dataType + " or a convertible one, but it is of type " + datumToSent.getDataType()), (Object[])new Object[0]));
            }
        }
    }

    public Set<String> getInputsWithDatum() {
        return new HashSet<String>(this.endpointDatumsForExecution.keySet());
    }

    public TypedDatum readInput(String inputName) {
        if (this.endpointDatumsForExecution.containsKey(inputName)) {
            EndpointDatum endpointDatum = this.endpointDatumsForExecution.get(inputName);
            DataType inputDataType = this.inputDataTypes.get(endpointDatum.getInputName());
            if (endpointDatum.getValue().getDataType() == inputDataType || endpointDatum.getValue().getDataType() == DataType.NotAValue) {
                return endpointDatum.getValue();
            }
            try {
                return typedDatumService.getConverter().castOrConvert(endpointDatum.getValue(), inputDataType);
            }
            catch (DataTypeException dataTypeException) {
                throw new RuntimeException(StringUtils.format((String)NOT_CONVERTIBLE_MESSAGE, (Object[])new Object[]{endpointDatum.getValue().getDataType(), inputDataType, inputName}));
            }
        }
        throw new NoSuchElementException(String.valueOf(this.getLogMessagesPrefix()) + StringUtils.format((String)"No datum at input '%s'", (Object[])new Object[]{inputName}));
    }

    public void printConsoleRow(String line, ConsoleRow.Type consoleRowType) {
        if (consoleRowType.equals((Object)ConsoleRow.Type.LIFE_CYCLE_EVENT)) {
            this.compExeRelatedInstances.consoleRowsSender.sendTimelineEventAsConsoleRow(consoleRowType, line);
        } else {
            this.compExeRelatedInstances.consoleRowsSender.sendLogMessageAsConsoleRow(consoleRowType, line, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get());
        }
    }

    public void closeAllOutputs() {
        for (EndpointDescription output : this.compExeRelatedInstances.compExeCtx.getComponentDescription().getOutputDescriptionsManager().getEndpointDescriptions()) {
            this.closeOutput(output.getName());
        }
    }

    public synchronized void closeOutput(String outputName) {
        if (!this.closedOutputs.containsKey(outputName) || !this.closedOutputs.get(outputName).booleanValue()) {
            this.closedOutputs.put(outputName, true);
            this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutput(outputName, (TypedDatum)new InternalTDImpl(InternalTDImpl.InternalTDType.WorkflowFinish));
        } else {
            this.printConsoleRow(StringUtils.format((String)"Output '%s' already closed. Ignored further closing request.", (Object[])new Object[]{outputName}), ConsoleRow.Type.COMPONENT_WARN);
        }
    }

    public synchronized boolean isOutputClosed(String outputName) {
        return this.closedOutputs.containsKey(outputName) && this.closedOutputs.get(outputName) != false;
    }

    public void resetOutputs() {
        this.validateIfNestedLoopComponent();
        this.writeResetOutputData();
    }

    private boolean circular(Queue<WorkflowGraphHop> hops) {
        WorkflowGraphHop firstElement = hops.peek();
        WorkflowGraphHop lastElement = null;
        Iterator iterator = hops.iterator();
        while (iterator.hasNext()) {
            WorkflowGraphHop hop;
            lastElement = hop = (WorkflowGraphHop)iterator.next();
        }
        if (lastElement == null) {
            return false;
        }
        return firstElement.getHopExecutionIdentifier().equals(lastElement.getTargetExecutionIdentifier());
    }

    private void writeResetOutputData() {
        Set<Deque<WorkflowGraphHop>> hopsSet = this.compExeRelatedInstances.compExeCtx.getWorkflowGraph().getHopsToTraverseWhenResetting(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier());
        for (Queue queue : hopsSet) {
            boolean circular = this.circular(queue);
            WorkflowGraphHop firstHop = (WorkflowGraphHop)queue.poll();
            InternalTDImpl resetDatum = new InternalTDImpl(InternalTDImpl.InternalTDType.NestedLoopReset, queue);
            if (circular) {
                this.compExeRelatedInstances.compExeScheduler.addResetDataIdSent(resetDatum.getIdentifier());
            }
            this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutputConsideringOnlyCertainInputs(firstHop.getHopOuputName(), (TypedDatum)resetDatum, firstHop.getTargetExecutionIdentifier(), firstHop.getTargetInputName());
        }
    }

    public int getExecutionCount() {
        return this.compExeRelatedInstances.compExeRelatedStates.executionCount.get();
    }

    public void writeIntermediateHistoryData(ComponentHistoryDataItem compHistoryDataItem) {
        if (this.writeHistoryDataItem(compHistoryDataItem)) {
            this.compExeRelatedInstances.compExeRelatedStates.intermediateHistoryDataWritten.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFinalHistoryDataItem(ComponentHistoryDataItem compHistoryDataItem) {
        Object object = this.historyDataLock;
        synchronized (object) {
            if (this.writeHistoryDataItem(compHistoryDataItem)) {
                this.compExeRelatedInstances.compExeRelatedStates.finalHistoryDataItemWritten.set(true);
            }
        }
    }

    public Long getComponentExecutionDataManagementId() {
        ComponentState compState = (ComponentState)this.compExeRelatedInstances.compStateMachine.getState();
        if ((compState.equals((Object)ComponentState.STARTING) || compState.equals((Object)ComponentState.PROCESSING_INPUTS)) && this.compExeRelatedInstances.compExeRelatedStates.isComponentCancelled.get()) {
            return null;
        }
        return this.compExeRelatedInstances.compExeStorageBridge.getComponentExecutionDataManagementId();
    }

    private boolean writeHistoryDataItem(ComponentHistoryDataItem componentHistoryDataItem) {
        if (componentHistoryDataItem == null) {
            this.printConsoleRow("Failed to store additional workflow data, because data item was 'null' which is a developer error", ConsoleRow.Type.COMPONENT_ERROR);
            LOG.error((Object)StringUtils.format((String)"Failed to store history data item for component '%s' (%s) of workflow '%s' (%s) because it was null", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()}));
            return false;
        }
        try {
            this.compExeRelatedInstances.compExeStorageBridge.setOrUpdateHistoryDataItem(componentHistoryDataItem.serialize(typedDatumService.getSerializer()));
            return true;
        }
        catch (ComponentExecutionException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getLogMessagesPrefix() {
        return StringUtils.format((String)"Component '%s' (%s) of workflow '%s' (%s): ", (Object[])new Object[]{this.compExeRelatedInstances.compExeCtx.getInstanceName(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier(), this.compExeRelatedInstances.compExeCtx.getWorkflowInstanceName(), this.compExeRelatedInstances.compExeCtx.getWorkflowExecutionIdentifier()});
    }

    protected void bindTypedDatumService(TypedDatumService newService) {
        typedDatumService = newService;
    }

    class OutputHolder {
        private final String outputName;
        private final TypedDatum datumToSend;
        private final Long outputDmId;

        OutputHolder(String outputName, TypedDatum datumToSend, Long outputDmId) {
            this.outputName = outputName;
            this.datumToSend = datumToSend;
            this.outputDmId = outputDmId;
        }
    }
}

