/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;

public class XmlComponentHistoryDataItem
extends CommonComponentHistoryDataItem {
    protected static final String FORMAT_VERSION_1 = "1";
    protected static final String CURRENT_FORMAT_VERSION = "1";
    private static final long serialVersionUID = -6610340731496850793L;
    private static final String PLAIN_XML_FILE_REFERENCE = "plainXML";
    private static final String XML_WITH_VARIABLES_FILE_REFERENCE = "xmlWithVariables";
    private String xmlWithVariablesFileReference;
    private String plainXMLFileReference;
    private String identifier;

    public XmlComponentHistoryDataItem(String identifier) {
        this.identifier = identifier;
    }

    public String getFormatVersion() {
        return StringUtils.escapeAndConcat((String[])new String[]{super.getFormatVersion(), "1"});
    }

    public String serialize(TypedDatumSerializer serializer) throws IOException {
        JsonNode rootNode;
        String commonDataString = super.serialize(serializer);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(commonDataString);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        if (this.xmlWithVariablesFileReference != null) {
            ((ObjectNode)rootNode).put(XML_WITH_VARIABLES_FILE_REFERENCE, this.xmlWithVariablesFileReference);
        }
        if (this.plainXMLFileReference != null) {
            ((ObjectNode)rootNode).put(PLAIN_XML_FILE_REFERENCE, this.plainXMLFileReference);
        }
        return rootNode.toString();
    }

    public static XmlComponentHistoryDataItem fromString(String historyData, TypedDatumSerializer serializer, String identifier) throws IOException {
        XmlComponentHistoryDataItem historyDataItem = new XmlComponentHistoryDataItem(identifier);
        CommonComponentHistoryDataItem.initializeCommonHistoryDataFromString((CommonComponentHistoryDataItem)historyDataItem, (String)historyData, (TypedDatumSerializer)serializer);
        XmlComponentHistoryDataItem.readXMLFileReferencesFromString(historyData, historyDataItem);
        return historyDataItem;
    }

    private static void readXMLFileReferencesFromString(String historyData, XmlComponentHistoryDataItem historyDataItem) throws IOException {
        JsonNode rootNode;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            rootNode = mapper.readTree(historyData);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
        if (((ObjectNode)rootNode).get(XML_WITH_VARIABLES_FILE_REFERENCE) != null) {
            historyDataItem.xmlWithVariablesFileReference = ((ObjectNode)rootNode).get(XML_WITH_VARIABLES_FILE_REFERENCE).textValue();
        }
        if (((ObjectNode)rootNode).get(PLAIN_XML_FILE_REFERENCE) != null) {
            historyDataItem.plainXMLFileReference = ((ObjectNode)rootNode).get(PLAIN_XML_FILE_REFERENCE).textValue();
        }
    }

    public String getXmlWithVariablesFileReference() {
        return this.xmlWithVariablesFileReference;
    }

    public void setXmlWithVariablesFileReference(String xmlWithVariablesFileReference) {
        this.xmlWithVariablesFileReference = xmlWithVariablesFileReference;
    }

    public void setPlainXMLFileReference(String plainXMLFileReference) {
        this.plainXMLFileReference = plainXMLFileReference;
    }

    public String getPlainXmlFileReference() {
        return this.plainXMLFileReference;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

