/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.virtual.testutils;

import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.routing.internal.NetworkFormatter;
import de.rcenvironment.core.communication.testutils.CommonVirtualInstanceControl;
import de.rcenvironment.core.communication.testutils.NetworkContactPointGenerator;
import de.rcenvironment.core.communication.testutils.VirtualInstance;
import de.rcenvironment.core.communication.testutils.VirtualInstanceGroup;
import de.rcenvironment.core.communication.testutils.VirtualInstanceSkeleton;
import de.rcenvironment.core.communication.testutils.VirtualInstanceState;
import de.rcenvironment.core.communication.transport.spi.NetworkTransportProvider;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.CallablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualInstanceTestUtils {
    private static final int UPPER_UNIQUE_TOKEN_LIMIT = 10000000;
    private final Random randomGenerator = new Random();
    private NetworkTransportProvider transportProvider;
    private NetworkContactPointGenerator contactPointGenerator;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());

    public VirtualInstanceTestUtils(NetworkTransportProvider transportProvider, NetworkContactPointGenerator contactPointGenerator) {
        this.transportProvider = transportProvider;
        this.contactPointGenerator = contactPointGenerator;
    }

    @Deprecated
    public VirtualInstance[] spawnDefaultInstances(int size) throws InterruptedException {
        return this.spawnDefaultInstances(size, false, true);
    }

    public VirtualInstance[] spawnDefaultInstances(int size, boolean useDuplexTransport, boolean startInstances) throws InterruptedException {
        if (size < 2) {
            throw new IllegalArgumentException("Illegal number of instances: " + size);
        }
        CommonVirtualInstanceControl[] instances = new VirtualInstance[size];
        CallablesGroup callablesGroup = ConcurrencyUtils.getFactory().createCallablesGroup(VirtualInstance.class);
        int i = 1;
        while (i <= size) {
            final int i2 = i++;
            callablesGroup.add((Callable)new Callable<VirtualInstance>(){

                @Override
                @TaskDescription(value="Default VirtualInstance creation")
                public VirtualInstance call() throws Exception {
                    if (VirtualInstanceTestUtils.this.verboseLogging) {
                        VirtualInstanceTestUtils.this.log.debug((Object)("Creating instance " + i2));
                    }
                    VirtualInstance instance = new VirtualInstance("Instance " + i2);
                    if (VirtualInstanceTestUtils.this.verboseLogging) {
                        VirtualInstanceTestUtils.this.log.debug((Object)("Finished creating instance " + i2));
                    }
                    return instance;
                }
            });
        }
        instances = callablesGroup.executeParallel(null).toArray(instances);
        VirtualInstanceGroup group = new VirtualInstanceGroup(instances);
        group.registerNetworkTransportProvider(this.transportProvider);
        CommonVirtualInstanceControl[] commonVirtualInstanceControlArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CommonVirtualInstanceControl vi = commonVirtualInstanceControlArray[n2];
            ((VirtualInstanceSkeleton)vi).addServerConfigurationEntry(this.contactPointGenerator.createContactPoint());
            ++n2;
        }
        if (startInstances) {
            this.startAll((VirtualInstance[])instances);
        }
        return instances;
    }

    public void startAll(VirtualInstance[] instances) throws InterruptedException {
        VirtualInstanceGroup group = new VirtualInstanceGroup(instances);
        group.setTargetState(VirtualInstanceState.STARTED);
        group.waitForStateChangesToFinish();
    }

    public String getFormattedName(VirtualInstance[] instances, int index) {
        return this.getFormattedName(instances[index]);
    }

    @Deprecated
    public String getFormattedName(VirtualInstance instance) {
        return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{instance.getInstanceNodeSessionId(), instance.getConfigurationService().getInitialNodeInformation().getLogDescription()});
    }

    public String generateUniqueMessageToken() {
        return StringUtils.format((String)"Unique message token: %s", (Object[])new Object[]{this.randomGenerator.nextInt(10000000)});
    }

    public VirtualInstance getRandomInstance(VirtualInstance[] instances) {
        return instances[this.randomGenerator.nextInt(instances.length)];
    }

    public VirtualInstance getRandomInstance(VirtualInstance[] instances, VirtualInstance ... not) {
        int i = 0;
        int rand = this.randomGenerator.nextInt(instances.length);
        boolean run = true;
        while (run) {
            if (i++ > instances.length * 2) break;
            rand = this.randomGenerator.nextInt(instances.length);
            run = false;
            VirtualInstance[] virtualInstanceArray = not;
            int n = not.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualInstance vi = virtualInstanceArray[n2];
                run |= vi.equals(instances[rand]);
                ++n2;
            }
        }
        return instances[rand];
    }

    public boolean allInstancesHaveSameRawNetworkGraph(VirtualInstance[] instances) {
        int differences = 0;
        VirtualInstance instance0 = instances[0];
        NetworkGraph networkGraph0 = instance0.getRawNetworkGraph();
        String compact0 = networkGraph0.getCompactRepresentation();
        int i = 1;
        while (i < instances.length) {
            VirtualInstance instanceN = instances[i];
            NetworkGraph networkGraphN = instanceN.getRawNetworkGraph();
            String compactN = networkGraphN.getCompactRepresentation();
            if (!compactN.equals(compact0) && ++differences == 1) {
                this.log.warn((Object)StringUtils.format((String)"At least two instances do not share a common view of the network topology; first difference:\nInstance 0 (%s):\n%s\n%s\n%s\nInstance %d (%s):\n %s\n%s\n%s", (Object[])new Object[]{instance0.getInstanceNodeSessionId(), compact0, NetworkFormatter.networkGraphToGraphviz(networkGraph0, true), instance0.getFormattedLSAKnowledge(), i, instanceN.getInstanceNodeSessionId(), compactN, NetworkFormatter.networkGraphToGraphviz(networkGraphN, true), instanceN.getFormattedLSAKnowledge()}));
            }
            ++i;
        }
        if (differences == 0) {
            return true;
        }
        this.log.warn((Object)("Total number of differences (from instance 0): " + differences + " out of " + instances.length));
        return false;
    }

    public void connectToChainTopology(VirtualInstance[] instances) {
        int i = 0;
        while (i < instances.length - 1) {
            instances[i].connectAsync(instances[i + 1].getConfigurationService().getServerContactPoints().get(0));
            ++i;
        }
    }

    public void connectToRingTopology(VirtualInstance[] instances) {
        this.connectToChainTopology(instances);
        instances[instances.length - 1].connectAsync(instances[0].getConfigurationService().getServerContactPoints().get(0));
    }

    public void connectToDoubleChainTopology(VirtualInstance[] instances, int min, int max) {
        int i = min;
        while (i <= max - 1) {
            instances[i].connectAsync(instances[i + 1].getConfigurationService().getServerContactPoints().get(0));
            instances[i + 1].connectAsync(instances[i].getConfigurationService().getServerContactPoints().get(0));
            ++i;
        }
    }

    public void connectToDoubleChainTopology(VirtualInstance[] instances) {
        this.connectToDoubleChainTopology(instances, 0, instances.length - 1);
    }

    public void connectToDoubleRingTopology(VirtualInstance[] instances) {
        this.connectToDoubleRingTopology(instances, 0, instances.length - 1);
    }

    public void connectToDoubleRingTopology(VirtualInstance[] instances, int min, int max) {
        this.connectToDoubleChainTopology(instances, min, max);
        instances[max].connectAsync(instances[min].getConfigurationService().getServerContactPoints().get(0));
        instances[min].connectAsync(instances[max].getConfigurationService().getServerContactPoints().get(0));
    }

    public void connectToDoubleStarTopology(VirtualInstance[] instances) {
        int i = 0;
        while (i < instances.length - 1) {
            instances[i].connectAsync(instances[instances.length - 1].getConfigurationService().getServerContactPoints().get(0));
            instances[instances.length - 1].connectAsync(instances[i].getConfigurationService().getServerContactPoints().get(0));
            ++i;
        }
    }

    public void connectToInwardStarTopology(VirtualInstance[] instances) {
        NetworkContactPoint hubServerNCP = instances[0].getConfigurationService().getServerContactPoints().get(0);
        int i = 1;
        while (i < instances.length) {
            instances[i].connectAsync(hubServerNCP);
            ++i;
        }
    }

    public void randomlyConcatenateTopologies(VirtualInstance[] instances1, VirtualInstance[] instances2) {
        int index1 = this.randomGenerator.nextInt(instances1.length);
        int index2 = this.randomGenerator.nextInt(instances2.length);
        instances1[index1].connectAsync(instances2[index2].getConfigurationService().getServerContactPoints().get(0));
        instances2[index2].connectAsync(instances1[index1].getConfigurationService().getServerContactPoints().get(0));
    }

    public void concatenateInstances(VirtualInstance[] instances, int first, int second) {
        instances[first].connectAsync(instances[second].getConfigurationService().getServerContactPoints().get(0));
    }

    public void doubleConcatenateInstances(VirtualInstance[] instances, int first, int second) {
        instances[first].connectAsync(instances[second].getConfigurationService().getServerContactPoints().get(0));
        instances[second].connectAsync(instances[first].getConfigurationService().getServerContactPoints().get(0));
    }
}

