/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.spi;

import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageChannel
implements MessageChannel {
    protected static final int NETWORK_PAYLOAD_SIZE_WARNING_THRESHOLD = 0x100000;
    protected ServerContactPoint associatedSCP;
    private volatile MessageChannelState state = MessageChannelState.CONNECTING;
    private volatile boolean simulatingBreakdown = false;
    private InitialNodeInformation remoteNodeInformation;
    private boolean initiatedByRemote = false;
    private String associatedMirrorChannelId;
    private String connectionId;
    private boolean closedBecauseMirrorChannelClosed = false;

    @Override
    public MessageChannelState getState() {
        return this.state;
    }

    @Override
    public InitialNodeInformation getRemoteNodeInformation() {
        return this.remoteNodeInformation;
    }

    @Override
    public void setRemoteNodeInformation(InitialNodeInformation nodeInformation) {
        this.remoteNodeInformation = nodeInformation;
    }

    @Override
    public void setAssociatedSCP(ServerContactPoint networkContactPoint) {
        this.associatedSCP = networkContactPoint;
    }

    @Override
    public boolean getInitiatedByRemote() {
        return this.initiatedByRemote;
    }

    @Override
    public void setInitiatedByRemote(boolean value) {
        this.initiatedByRemote = value;
    }

    @Override
    public String getAssociatedMirrorChannelId() {
        return this.associatedMirrorChannelId;
    }

    @Override
    public boolean isClosedBecauseMirrorChannelClosed() {
        return this.closedBecauseMirrorChannelClosed;
    }

    @Override
    public void setAssociatedMirrorChannelId(String initiatingChannelId) {
        this.associatedMirrorChannelId = initiatingChannelId;
    }

    @Override
    public void markAsClosedBecauseMirrorChannelClosed() {
        this.closedBecauseMirrorChannelClosed = true;
    }

    @Override
    public String getChannelId() {
        return this.connectionId;
    }

    @Override
    public void setChannelId(String id) {
        if (this.connectionId != null) {
            throw new IllegalArgumentException("Duplicate id assignment");
        }
        this.connectionId = id;
    }

    @Override
    public synchronized void markAsEstablished() {
        MessageChannelState oldState = this.state;
        if (oldState != MessageChannelState.CONNECTING) {
            throw new IllegalStateException(oldState.toString());
        }
        this.state = MessageChannelState.ESTABLISHED;
    }

    @Override
    public boolean isReadyToUse() {
        return this.state == MessageChannelState.ESTABLISHED;
    }

    @Override
    public final synchronized boolean close() {
        MessageChannelState oldState = this.state;
        switch (oldState) {
            case ESTABLISHED: {
                this.state = MessageChannelState.CLOSED;
                this.asyncFireOnClosedOrBroken();
                return true;
            }
            case MARKED_AS_BROKEN: {
                return false;
            }
            case CLOSED: {
                return false;
            }
        }
        throw new IllegalStateException(oldState.toString());
    }

    @Override
    public synchronized boolean markAsBroken() {
        MessageChannelState oldState = this.state;
        switch (oldState) {
            case CONNECTING: {
                LogFactory.getLog(this.getClass()).warn((Object)("Channel " + this.getChannelId() + " marked as broken while in state " + oldState.toString()));
                return true;
            }
            case ESTABLISHED: {
                this.state = MessageChannelState.MARKED_AS_BROKEN;
                this.asyncFireOnClosedOrBroken();
                return true;
            }
            case MARKED_AS_BROKEN: {
                return false;
            }
            case CLOSED: {
                return false;
            }
        }
        throw new IllegalStateException(oldState.toString());
    }

    private void asyncFireOnClosedOrBroken() {
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Communication Layer: Asynchronous handling of connection breakdown")
            public void run() {
                AbstractMessageChannel.this.onClosedOrBroken();
            }
        });
    }

    public String toString() {
        String suffix = "";
        if (this.simulatingBreakdown) {
            suffix = "; simulating breakdown";
        }
        return StringUtils.format((String)"Channel %s (%s%s)", (Object[])new Object[]{this.connectionId, this.state, suffix});
    }

    protected abstract void onClosedOrBroken();

    public void setSimulatingBreakdown(boolean simulatingBreakdown) {
        this.simulatingBreakdown = simulatingBreakdown;
    }

    public boolean isSimulatingBreakdown() {
        return this.simulatingBreakdown;
    }

    protected final void failOnIncompatibleVersions(String remoteProtocolVersion, String expectedProtocolVersion) throws CommunicationException {
        if (remoteProtocolVersion == null) {
            throw new CommunicationException("The remote instance sent a response, but it did not contain a proper version code. You are probably trying to connect to an instance running an incompatible version of the software.");
        }
        if (!remoteProtocolVersion.equals(expectedProtocolVersion)) {
            throw new CommunicationException("The remote instance is running a software version that is not compatible with the local instance: The remote version is '" + remoteProtocolVersion + "' and the local version is '" + expectedProtocolVersion + "'.");
        }
    }
}

