/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.management.CommunicationManagementService;
import de.rcenvironment.core.communication.messaging.internal.HealthCheckNetworkRequestHandler;
import de.rcenvironment.core.communication.messaging.internal.MessageEndpointHandlerImpl;
import de.rcenvironment.core.communication.messaging.internal.RPCNetworkRequestHandler;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.routing.NetworkRoutingService;
import de.rcenvironment.core.communication.rpc.spi.RemoteServiceCallHandlerService;
import de.rcenvironment.core.communication.transport.spi.AbstractMessageChannel;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Version;

public class CommunicationManagementServiceImpl
implements CommunicationManagementService {
    private static final int DELAY_AFTER_SHUTDOWN_ANNOUNCE_MSEC = 200;
    private MessageChannelService connectionService;
    private NetworkRoutingService networkRoutingService;
    private InitialNodeInformation ownNodeInformation;
    private NodeConfigurationService nodeConfigurationService;
    private List<ServerContactPoint> initializedServerContactPoints = new ArrayList<ServerContactPoint>();
    private ScheduledFuture<?> connectionHealthCheckTaskHandle;
    private RemoteServiceCallHandlerService serviceCallHandler;
    private NodePropertiesService nodePropertiesService;
    private ConnectionSetupService connectionSetupService;
    private long sessionStartTimeMsec;
    private boolean autoStartNetworkOnActivation = true;
    private boolean started;
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startUpNetwork() {
        this.sessionStartTimeMsec = System.currentTimeMillis();
        Map<String, String> localMetadata = this.createLocalMetadataContribution();
        this.nodePropertiesService.addOrUpdateLocalNodeProperties(localMetadata);
        this.log.debug((Object)"Starting server contact points");
        for (NetworkContactPoint ncp : this.nodeConfigurationService.getServerContactPoints()) {
            try {
                List<ServerContactPoint> list = this.initializedServerContactPoints;
                synchronized (list) {
                    ServerContactPoint newSCP = this.connectionService.startServer(ncp);
                    this.initializedServerContactPoints.add(newSCP);
                }
            }
            catch (CommunicationException e) {
                this.log.warn((Object)("Error while starting server at " + ncp), (Throwable)e);
            }
        }
        try {
            Thread.sleep(this.nodeConfigurationService.getDelayBeforeStartupConnectAttempts());
        }
        catch (InterruptedException e1) {
            this.log.error((Object)"Interrupted while waiting during startup; not connecting to neighbors", (Throwable)e1);
            return;
        }
        this.connectionService.setShutdownFlag(false);
        this.log.debug((Object)"Starting preconfigured connections");
        for (NetworkContactPoint ncp : this.nodeConfigurationService.getInitialNetworkContactPoints()) {
            String displayName = StringUtils.format((String)"%s:%s", (Object[])new Object[]{ncp.getHost(), ncp.getPort()});
            boolean connectOnStartup = !"false".equals(ncp.getAttributes().get("connectOnStartup"));
            ConnectionSetup setup = this.connectionSetupService.createConnectionSetup(ncp, displayName, connectOnStartup);
            this.log.debug((Object)StringUtils.format((String)"Loaded pre-configured network connection \"%s\" (Settings: %s)", (Object[])new Object[]{setup.getDisplayName(), ncp.getAttributes()}));
            if (!setup.getConnnectOnStartup()) continue;
            setup.signalStartIntent();
        }
        this.connectionHealthCheckTaskHandle = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedRate(new Runnable(){

            @Override
            @TaskDescription(value="Communication Layer: Connection health check (trigger task)")
            public void run() {
                try {
                    CommunicationManagementServiceImpl.this.connectionService.triggerHealthCheckForAllChannels();
                }
                catch (RuntimeException e) {
                    CommunicationManagementServiceImpl.this.log.error((Object)"Uncaught exception during connection health check", (Throwable)e);
                }
            }
        }, 20000L);
        this.started = true;
    }

    @Override
    @Deprecated
    public MessageChannel connectToRuntimePeer(NetworkContactPoint ncp) throws CommunicationException {
        Future<MessageChannel> future = this.connectionService.connect(ncp, true);
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw new CommunicationException(e);
        }
        catch (InterruptedException e) {
            throw new CommunicationException(e);
        }
    }

    @Override
    @Deprecated
    public void asyncConnectToNetworkPeer(final NetworkContactPoint ncp) {
        ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

            @Override
            @TaskDescription(value="Communication Layer: Connect to remote node (trigger task)")
            public void run() {
                try {
                    CommunicationManagementServiceImpl.this.log.debug((Object)("Initiating asynchronous connection to " + ncp));
                    CommunicationManagementServiceImpl.this.connectToRuntimePeer(ncp);
                }
                catch (CommunicationException e) {
                    CommunicationManagementServiceImpl.this.log.warn((Object)("Failed to contact initial peer at NCP " + ncp), (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutDownNetwork() {
        if (!this.started) {
            this.log.debug((Object)"Network layer was not started, ignoring request to shut down");
            return;
        }
        this.started = false;
        this.connectionService.setShutdownFlag(true);
        this.connectionHealthCheckTaskHandle.cancel(true);
        this.nodePropertiesService.addOrUpdateLocalNodeProperty("state", "shutting down");
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Interrupted while waiting", (Throwable)e);
        }
        this.connectionService.closeAllOutgoingChannels();
        List<ServerContactPoint> list = this.initializedServerContactPoints;
        synchronized (list) {
            for (ServerContactPoint scp : this.initializedServerContactPoints) {
                scp.shutDown();
            }
            this.initializedServerContactPoints.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void simulateUncleanShutdown() {
        for (MessageChannel channel : this.connectionService.getAllOutgoingChannels()) {
            ((AbstractMessageChannel)channel).setSimulatingBreakdown(true);
        }
        this.connectionService.closeAllOutgoingChannels();
        List<ServerContactPoint> list = this.initializedServerContactPoints;
        synchronized (list) {
            for (ServerContactPoint scp : this.initializedServerContactPoints) {
                scp.setSimulatingBreakdown(true);
            }
            this.initializedServerContactPoints.clear();
        }
    }

    public void bindMessageChannelService(MessageChannelService newService) {
        if (this.connectionService != null) {
            throw new IllegalStateException();
        }
        this.connectionService = newService;
    }

    public void bindNetworkRoutingService(NetworkRoutingService newService) {
        if (this.networkRoutingService != null) {
            throw new IllegalStateException();
        }
        this.networkRoutingService = newService;
    }

    public void bindNodeConfigurationService(NodeConfigurationService newService) {
        if (this.nodeConfigurationService != null) {
            throw new IllegalStateException();
        }
        this.nodeConfigurationService = newService;
    }

    public void bindServiceCallHandler(RemoteServiceCallHandlerService newInstance) {
        this.serviceCallHandler = newInstance;
    }

    public void bindNodePropertiesService(NodePropertiesService newInstance) {
        this.nodePropertiesService = newInstance;
    }

    public void bindConnectionSetupService(ConnectionSetupService newInstance) {
        this.connectionSetupService = newInstance;
    }

    public void activate() {
        this.ownNodeInformation = this.nodeConfigurationService.getInitialNodeInformation();
        MessageEndpointHandlerImpl messageEndpointHandler = new MessageEndpointHandlerImpl(this.nodeConfigurationService.getNodeIdentifierService());
        messageEndpointHandler.registerRequestHandler("rpc", new RPCNetworkRequestHandler(this.serviceCallHandler));
        messageEndpointHandler.registerRequestHandler("healthCheck", new HealthCheckNetworkRequestHandler());
        this.connectionService.setMessageEndpointHandler(messageEndpointHandler);
        messageEndpointHandler.registerRequestHandlers(this.nodePropertiesService.getNetworkRequestHandlers());
        if (this.autoStartNetworkOnActivation && !CommandLineArguments.isDoNotStartNetworkRequested()) {
            ConcurrencyUtils.getAsyncTaskService().execute(new Runnable(){

                @Override
                @TaskDescription(value="Communication Layer: Main startup")
                public void run() {
                    CommunicationManagementServiceImpl.this.startUpNetwork();
                }
            });
        } else {
            this.log.debug((Object)"Network startup is disabled");
        }
    }

    public void deactivate() {
    }

    public void setAutoStartNetworkOnActivation(boolean autoStartNetworkOnActivation) {
        this.autoStartNetworkOnActivation = autoStartNetworkOnActivation;
    }

    private Map<String, String> createLocalMetadataContribution() {
        HashMap<String, String> localData = new HashMap<String, String>();
        localData.put("nodeId", this.ownNodeInformation.getInstanceNodeSessionIdString());
        localData.put("displayName", this.ownNodeInformation.getDisplayName());
        localData.put("sessionStartTime", Long.toString(this.sessionStartTimeMsec));
        localData.put("debug.sessionStartInfo", DateFormat.getDateTimeInstance(1, 1).format(new Date(this.sessionStartTimeMsec)));
        Version coreVersion = VersionUtils.getVersionOfCoreBundles();
        if (coreVersion != null) {
            localData.put("debug.coreVersion", coreVersion.toString());
        } else {
            localData.put("debug.coreVersion", "<unknown>");
        }
        localData.put("debug.osInfo", StringUtils.format((String)"%s (%s/%s)", (Object[])new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")}));
        localData.put("debug.isRelay", Boolean.toString(this.nodeConfigurationService.isRelay()));
        if (this.nodeConfigurationService.getLocationCoordinates() != null) {
            localData.put("coordinates", "[" + this.nodeConfigurationService.getLocationCoordinates()[0] + "," + this.nodeConfigurationService.getLocationCoordinates()[1] + "]");
        }
        localData.put("locationName", this.nodeConfigurationService.getLocationName());
        localData.put("contact", this.nodeConfigurationService.getInstanceContact());
        localData.put("additionalInformation", this.nodeConfigurationService.getInstanceAdditionalInformation());
        return localData;
    }
}

