/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.BenchmarkService;
import de.rcenvironment.core.communication.management.BenchmarkSetup;
import de.rcenvironment.core.communication.management.RemoteBenchmarkService;
import de.rcenvironment.core.communication.management.internal.BenchmarkProcess;
import de.rcenvironment.core.communication.management.internal.BenchmarkSubtaskImpl;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class BenchmarkServiceImpl
implements BenchmarkService,
RemoteBenchmarkService {
    private CommunicationService commService;
    private PlatformService platformService;
    private LiveNetworkIdResolutionService idResolutionService;

    @Override
    public BenchmarkSetup parseBenchmarkDescription(String definition) {
        ArrayList<BenchmarkSubtaskImpl> subtasks = new ArrayList<BenchmarkSubtaskImpl>();
        Pattern cmdPattern = Pattern.compile("([0-9a-f]{32}(?::[0-9a-f]{10})?|\\*|\\*\\*)\\((\\d*),(\\d*),(\\d*),(\\d*),(\\d*)\\)");
        Matcher matcher = cmdPattern.matcher(definition);
        while (matcher.find()) {
            String targetNodeString = matcher.group(1);
            int numMessages = this.parseInt(matcher.group(2), 1);
            int requestSize = this.parseInt(matcher.group(3), 1);
            int responseSize = this.parseInt(matcher.group(4), 1);
            int responseDelay = this.parseInt(matcher.group(5), 0);
            int numSenders = this.parseInt(matcher.group(6), 1);
            ArrayList<InstanceNodeSessionId> targetNodes = new ArrayList<InstanceNodeSessionId>();
            if (targetNodeString.equals("*")) {
                HashSet<InstanceNodeSessionId> knownNodes = new HashSet<InstanceNodeSessionId>(this.commService.getReachableInstanceNodes());
                knownNodes.remove(this.platformService.getLocalInstanceNodeSessionId());
                targetNodes.addAll(knownNodes);
            } else if (targetNodeString.equals("**")) {
                targetNodes.addAll(this.commService.getReachableInstanceNodes());
            } else {
                try {
                    targetNodes.add(this.idResolutionService.resolveInstanceNodeIdStringToInstanceNodeSessionId(targetNodeString));
                }
                catch (IdentifierException identifierException) {
                    throw new IllegalArgumentException("Could not resolve '" + targetNodeString + "' to a valid node within the current network");
                }
            }
            BenchmarkSubtaskImpl subtask = new BenchmarkSubtaskImpl(targetNodes, numMessages, requestSize, responseSize, responseDelay, numSenders);
            subtasks.add(subtask);
        }
        if (subtasks.isEmpty()) {
            throw new IllegalArgumentException("Malformed task definition: '" + definition + "'");
        }
        return new BenchmarkSetupImpl(subtasks);
    }

    @Override
    public void executeBenchmark(BenchmarkSetup setup, TextOutputReceiver outputReceiver) {
        BenchmarkProcess benchmark = this.createBenchmarkProcess(setup, outputReceiver);
        benchmark.run();
    }

    @Override
    public void asyncExecBenchmark(BenchmarkSetup setup, TextOutputReceiver outputReceiver) {
        BenchmarkProcess benchmark = this.createBenchmarkProcess(setup, outputReceiver);
        ConcurrencyUtils.getAsyncTaskService().execute((Runnable)benchmark);
    }

    @Override
    @AllowRemoteAccess
    public Serializable respond(Serializable input, Integer respSize, Integer respDelay) {
        try {
            Thread.sleep(respDelay.intValue());
        }
        catch (InterruptedException e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Interrupted while waiting to send benchmark response", (Throwable)e);
        }
        return new byte[respSize.intValue()];
    }

    protected void activate(BundleContext context) {
    }

    protected void bindCommunicationService(CommunicationService newCommunicationService) {
        this.commService = newCommunicationService;
    }

    protected void bindLiveNetworkIdResolutionService(LiveNetworkIdResolutionService newInstance) {
        this.idResolutionService = newInstance;
    }

    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    private BenchmarkProcess createBenchmarkProcess(BenchmarkSetup setup, TextOutputReceiver outputReceiver) {
        BenchmarkProcess benchmark = new BenchmarkProcess(setup, outputReceiver, this.commService);
        return benchmark;
    }

    private int parseInt(String input, int defValue) {
        if (input.length() == 0) {
            return defValue;
        }
        return Integer.parseInt(input);
    }

    private class BenchmarkSetupImpl
    implements BenchmarkSetup {
        private List<BenchmarkSubtaskImpl> subtasks;

        BenchmarkSetupImpl(List<BenchmarkSubtaskImpl> subtasks) {
            this.subtasks = subtasks;
        }

        public List<BenchmarkSubtaskImpl> getSubtasks() {
            return this.subtasks;
        }
    }
}

