/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.transport.jms.common.AbstractJmsMessageChannel;
import de.rcenvironment.core.communication.transport.jms.common.JMSHandshakeInformation;
import de.rcenvironment.core.communication.transport.jms.common.JmsProtocolUtils;
import de.rcenvironment.core.communication.transport.jms.common.RequestInboxConsumer;
import de.rcenvironment.core.communication.transport.jms.common.RequestResponseQueuesManager;
import de.rcenvironment.core.communication.transport.spi.BrokenMessageChannelListener;
import de.rcenvironment.core.communication.transport.spi.HandshakeInformation;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;

public class SelfInitiatedJmsMessageChannel
extends AbstractJmsMessageChannel {
    private static final int INITIAL_HANDSHAKE_TIMEOUT_MSEC = 15000;
    private ConnectionFactory connectionFactory;
    private BrokenMessageChannelListener brokenConnectionListener;

    public SelfInitiatedJmsMessageChannel(InstanceNodeSessionId localNodeId, ConnectionFactory connectionFactory, BrokenMessageChannelListener brokenConnectionListener) {
        super(localNodeId);
        this.connectionFactory = connectionFactory;
        this.brokenConnectionListener = brokenConnectionListener;
    }

    void connectToJmsBroker() throws JMSException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                SelfInitiatedJmsMessageChannel.this.log.warn((Object)StringUtils.format((String)"Asynchronous JMS exception in outgoing connection %s: %s ", (Object[])new Object[]{SelfInitiatedJmsMessageChannel.this.getChannelId(), exception.toString()}));
            }
        });
        this.connection.start();
    }

    @Override
    protected void onClosedOrBroken() {
        this.log.debug((Object)("Closing self-initiated channel " + this.getChannelId()));
        super.onClosedOrBroken();
        final boolean isActiveShutdown = this.getState() == MessageChannelState.CLOSED;
        this.log.debug((Object)("Triggering asynchronous JMS disconnect of message channel " + this.getChannelId()));
        this.threadPool.execute(new Runnable(){

            @Override
            @TaskDescription(value="JMS Network Transport: Asynchronous disconnect")
            public void run() {
                SelfInitiatedJmsMessageChannel.this.tearDownJmsConnection(isActiveShutdown);
            }
        }, this.getChannelId());
    }

    private void tearDownJmsConnection(boolean isActiveShutdown) {
        if (isActiveShutdown) {
            this.sendShutdownMessageToRemoteRequestInbox();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.log.warn((Object)"Interrupted between sending the shutdown notice and closing the JMS connection");
            }
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            } else {
                this.log.debug((Object)("No JMS connection for channel " + this.getChannelId() + " when asked to tear it down"));
            }
        }
        catch (JMSException e) {
            this.log.debug((Object)"Exception while closing JMS connection", (Throwable)e);
        }
    }

    HandshakeInformation performInitialHandshake(JMSHandshakeInformation ownHandshakeInformation, MessageChannelEndpointHandler remoteInitiatedConnectionEndpointHandler) throws JMSException, CommunicationException, TimeoutException, IOException {
        try (Session initialSession = this.connection.createSession(false, 1);){
            Queue initialInbox = initialSession.createQueue("initial/c2b");
            RequestResponseQueuesManager tempQueueManager = new RequestResponseQueuesManager();
            String clientQueueInfo = tempQueueManager.initClientSide(initialSession);
            ownHandshakeInformation.setTemporaryQueueInformation(clientQueueInfo);
            Message handshakeRequestMessage = JmsProtocolUtils.createHandshakeMessage(ownHandshakeInformation, initialSession);
            ObjectMessage handshakeResponseMessage = (ObjectMessage)this.performBlockingJmsRequestResponse(initialSession, handshakeRequestMessage, initialInbox, 15000);
            JMSHandshakeInformation remoteHandshakeInformation = JmsProtocolUtils.parseHandshakeMessage((Message)handshakeResponseMessage, ownHandshakeInformation.getProtocolVersionString());
            this.failOnIncompatibleVersions(remoteHandshakeInformation.getProtocolVersionString(), ownHandshakeInformation.getProtocolVersionString());
            tempQueueManager.finishClientSide(remoteHandshakeInformation.getTemporaryQueueInformation());
            this.setAssociatedMirrorChannelId(remoteHandshakeInformation.getChannelId());
            ConcurrencyUtils.getAsyncTaskService().execute((Runnable)new RequestInboxConsumer(tempQueueManager.getB2CRequestQueue(), this.connection, remoteInitiatedConnectionEndpointHandler), StringUtils.format((String)"B2C Request Inbox Consumer for channel %s @ %s", (Object[])new Object[]{remoteHandshakeInformation.getChannelId(), tempQueueManager.getB2CRequestQueue()}));
            String outgoingRequestQueueName = tempQueueManager.getC2BRequestQueue();
            String incomingResponseQueueName = tempQueueManager.getC2BResponseQueue();
            this.setupNonBlockingRequestSending(outgoingRequestQueueName, incomingResponseQueueName);
            JMSHandshakeInformation jMSHandshakeInformation = remoteHandshakeInformation;
            return jMSHandshakeInformation;
        }
    }
}

