/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authorization.internal;

import de.rcenvironment.core.authorization.AuthorizationService;
import de.rcenvironment.core.authorization.AuthorizationStore;
import de.rcenvironment.core.authorization.internal.AuthorizationConfiguration;
import de.rcenvironment.core.authorization.rbac.Permission;
import de.rcenvironment.core.authorization.rbac.Role;
import de.rcenvironment.core.authorization.rbac.Subject;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class AuthorizationServiceImpl
implements AuthorizationService {
    private static final String ERROR_SERVICE_NOT_REGISTERED = "A service providing the desired authorization store \"%s\" is not registered.";
    private static final String ERROR_BUNDLE_NOT_INSTALLED = "A bundle providing the desired authorization store \"%s\" is not installed.";
    private static final Log LOGGER = LogFactory.getLog(AuthorizationStore.class);
    private static final String SUBJECT_ID = "subjectID";
    private static final String ERROR_PARAMETERS_NULL = "The parameter \"%s\" must not be null.";
    private static AuthorizationStore myStore = null;
    private AuthorizationConfiguration myConfiguration;
    private ConfigurationService configurationService;
    private BundleContext bundleContext;

    protected void activate(BundleContext context) {
        this.bundleContext = context;
        this.myConfiguration = new AuthorizationConfiguration();
    }

    protected void bindConfigurationService(ConfigurationService newConfigurationService) {
        this.configurationService = newConfigurationService;
    }

    @Override
    public Permission getPermission(String permissionID) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)permissionID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"permissionID"}));
        Permission permission = myStore.lookupPermission(permissionID);
        return permission;
    }

    @Override
    public Set<Permission> getPermissions(String subjectID) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)subjectID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{SUBJECT_ID}));
        HashSet<Permission> permissions = new HashSet<Permission>();
        Set<Role> roles = myStore.lookupSubject(subjectID).getRoles();
        for (Role role : roles) {
            for (Permission permission : role.getPermissions()) {
                permissions.add(permission);
            }
        }
        return Collections.unmodifiableSet(permissions);
    }

    @Override
    public Role getRole(String roleID) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)roleID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"roleID"}));
        Role role = myStore.lookupRole(roleID);
        return role;
    }

    @Override
    public Set<Role> getRoles(String subjectID) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)subjectID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{SUBJECT_ID}));
        Set<Role> roles = myStore.lookupSubject(subjectID).getRoles();
        return Collections.unmodifiableSet(roles);
    }

    @Override
    public Subject getSubject(String subjectID) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)subjectID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{SUBJECT_ID}));
        Subject subject = myStore.lookupSubject(subjectID);
        return subject;
    }

    @Override
    public boolean hasPermission(String subjectID, Permission permission) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)subjectID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{SUBJECT_ID}));
        Assertions.isDefined((Object)permission, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"permission"}));
        boolean hasPermission = false;
        Set<Role> roles = myStore.lookupSubject(subjectID).getRoles();
        for (Role role : roles) {
            if (!role.hasPermission(permission)) continue;
            hasPermission = true;
            break;
        }
        return hasPermission;
    }

    @Override
    public boolean hasRole(String subjectID, Role role) {
        myStore = this.getAuthorizationStore();
        Assertions.isDefined((Object)subjectID, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{SUBJECT_ID}));
        Assertions.isDefined((Object)role, (String)StringUtils.format((String)ERROR_PARAMETERS_NULL, (Object[])new Object[]{"role"}));
        return myStore.lookupSubject(subjectID).hasRole(role);
    }

    private AuthorizationStore getAuthorizationStore() {
        String store = this.myConfiguration.getStore();
        Bundle[] bundles = this.bundleContext.getBundles();
        if (bundles == null) {
            throw new RuntimeException(StringUtils.format((String)ERROR_BUNDLE_NOT_INSTALLED, (Object[])new Object[]{store}));
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(store)) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    throw new RuntimeException(StringUtils.format((String)ERROR_BUNDLE_NOT_INSTALLED, (Object[])new Object[]{store}), e);
                }
            }
            ++n2;
        }
        String protocolFilter = "(store=" + store + ")";
        ServiceReference[] storeReferences = null;
        try {
            storeReferences = this.bundleContext.getAllServiceReferences(AuthorizationStore.class.getName(), protocolFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            LOGGER.error((Object)"Failed to get an authorization store service. Invalid protocol filter syntax.");
        }
        if (storeReferences == null || storeReferences.length < 1) {
            throw new RuntimeException(StringUtils.format((String)ERROR_SERVICE_NOT_REGISTERED, (Object[])new Object[]{store}));
        }
        return (AuthorizationStore)this.bundleContext.getService(storeReferences[0]);
    }
}

