/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.authentication;

import de.rcenvironment.core.authentication.User;
import java.security.cert.X509Certificate;

public class CertificateUser
extends User {
    private static final long serialVersionUID = 6949816833219681401L;
    private static final User.Type TYPE = User.Type.certificate;
    private final String userId;
    private final String domain;

    public CertificateUser(X509Certificate certificate, int validityInDays) {
        super(validityInDays);
        this.userId = certificate.getSubjectX500Principal().toString().replace(", ", ",");
        this.domain = certificate.getIssuerX500Principal().toString().replace(", ", ",");
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public User.Type getType() {
        return TYPE;
    }
}

