/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.xml.merger.gui;

import de.rcenvironment.components.xml.merger.gui.Messages;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeUtil;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.AbstractWorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodeCommand;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.executor.properties.AbstractEditScriptRunnable;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class XmlMergerSection
extends ValidatingWorkflowNodePropertySection {
    private static final int MINIMUM_HEIGHT_OF_FILE_CONTENT_TEXT = 300;
    private Button fileChooser;
    private Button fileEditor;
    private Composite fileGroup;
    private Composite contentGroup;
    private CLabel fileContentLabel;
    private StyledText fileContentText;
    private boolean mappingFileAsInput;
    private Button mappingFileAsInputButton;
    private Button loadMappingFileButton;
    private EditScriptRunnable esr;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        WorkflowNodePropertySection.LayoutComposite content = new WorkflowNodePropertySection.LayoutComposite(parent);
        content.setLayout((Layout)new GridLayout(1, true));
        Composite fileChoosingSection = toolkit.createFlatFormComposite((Composite)content);
        this.initFileChoosingSection(toolkit, fileChoosingSection);
    }

    private void initFileChoosingSection(TabbedPropertySheetWidgetFactory toolkit, Composite container) {
        GridData layoutData = new GridData(770);
        container.setLayoutData((Object)layoutData);
        container.setLayout((Layout)new FillLayout());
        Section section = toolkit.createSection(container, 320);
        section.setText(Messages.fileChoosingSectionName);
        Composite client = toolkit.createComposite((Composite)section);
        layoutData = new GridData(768);
        client.setLayoutData((Object)layoutData);
        client.setLayout((Layout)new GridLayout(1, false));
        Composite radioGroup = toolkit.createComposite(client);
        radioGroup.setLayout((Layout)new GridLayout(2, false));
        this.mappingFileAsInputButton = new Button(radioGroup, 16);
        this.mappingFileAsInputButton.setText(Messages.mappingFileAsInputButton);
        this.loadMappingFileButton = new Button(radioGroup, 16);
        this.loadMappingFileButton.setText(Messages.mappingFileLoadedButton);
        this.fileGroup = toolkit.createComposite(client);
        this.fileGroup.setLayout((Layout)new GridLayout(2, false));
        this.fileGroup.setEnabled(!this.mappingFileAsInput);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.grabExcessHorizontalSpace = false;
        this.fileChooser = toolkit.createButton(this.fileGroup, Messages.fileLinkButtonLabel, 8);
        this.fileEditor = toolkit.createButton(this.fileGroup, Messages.fileEditorButtonLabel, 8);
        layoutData = new GridData(1808);
        this.contentGroup = toolkit.createComposite(client);
        this.contentGroup.setLayoutData((Object)layoutData);
        this.contentGroup.setLayout((Layout)new GridLayout(1, false));
        this.fileContentLabel = toolkit.createCLabel(this.contentGroup, Messages.actuallyLoadedLabel);
        gridData = new GridData(1808);
        gridData.heightHint = 300;
        this.fileContentText = new StyledText(this.contentGroup, 2816);
        this.fileContentText.setEditable(false);
        this.fileContentText.setLayoutData((Object)gridData);
        this.fileContentText.setCaret(null);
        this.fileContentText.setData("property.control", (Object)"xmlContent");
        section.setClient((Control)client);
    }

    private void fileChoosing() {
        IFile file = PropertyTabGuiHelper.selectFileFromProjects((Shell)this.fileGroup.getShell(), (String)Messages.loadTitle, (String)Messages.loadMessage);
        if (file != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)file.getContents(), (Writer)writer);
                String theString = writer.toString();
                this.setScriptProperties(this.node, theString, this.getMappingType(file.getName()));
            }
            catch (IOException | CoreException e) {
                this.logger.error((Object)StringUtils.format((String)Messages.logReadFromFileError, (Object[])new Object[]{Messages.cannotReadContentFromFile, e.getMessage()}));
                MessageDialog.openError((Shell)this.getComposite().getShell(), (String)Messages.cannotReadContentFromFile, (String)StringUtils.format((String)Messages.dialogMessageReadFromFileError, (Object[])new Object[]{e.getMessage(), Messages.refreshProjectExplorer}));
            }
            this.refreshSection();
        }
    }

    private String getMappingType(String fileName) {
        if (fileName.endsWith("xml")) {
            return "Classic";
        }
        return "XSLT";
    }

    protected WorkflowNodePropertySection.Updater createUpdater() {
        return new MergerGUIUpdater();
    }

    protected WorkflowNodePropertySection.Synchronizer createSynchronizer() {
        return new MergerGUISynchronizer();
    }

    private void setXMLFileContent() {
        this.mappingFileAsInput = this.node.getConfigurationDescription().getConfigurationValue("mappingFileDeployment").equals("input");
        this.mappingFileAsInputButton.setSelection(this.mappingFileAsInput);
        this.loadMappingFileButton.setSelection(!this.mappingFileAsInput);
        this.fileChooser.setEnabled(!this.mappingFileAsInput);
        this.fileEditor.setEnabled(!this.mappingFileAsInput && !this.fileContentText.getText().equals(""));
        this.fileContentLabel.setEnabled(!this.mappingFileAsInput);
        this.fileContentText.setEnabled(!this.mappingFileAsInput);
        if (this.mappingFileAsInput) {
            this.fileContentLabel.setForeground(Display.getDefault().getSystemColor(33));
            if (this.loadMappingFileButton.isFocusControl()) {
                this.mappingFileAsInputButton.setFocus();
            }
        } else {
            this.fileContentLabel.setForeground(Display.getDefault().getSystemColor(30));
            if (this.mappingFileAsInputButton.isFocusControl()) {
                this.loadMappingFileButton.setFocus();
            }
        }
        this.fileGroup.pack(true);
    }

    protected void refreshBeforeValidation() {
        this.updateEditor(this.node);
        this.setXMLFileContent();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.setXMLFileContent();
        this.updateEditor(this.node);
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new FileController();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.refresh();
    }

    private void updateEditor(WorkflowNode node) {
        if (this.esr != null && this.fileContentText != null && this.esr.getNode().equals((Object)node)) {
            this.esr.update(this.fileContentText.getText());
        }
    }

    private void addMappingFileInput(WorkflowNode workflowNode) {
        EndpointDescriptionsManager manager = workflowNode.getInputDescriptionsManager();
        HashMap metaData = new HashMap();
        manager.addDynamicEndpointDescription("mappingFile", "Mapping file", DataType.FileReference, metaData);
    }

    private void removeMappingFileInput(WorkflowNode workflowNode) {
        EndpointDescriptionsManager manager = workflowNode.getInputDescriptionsManager();
        manager.removeDynamicEndpointDescription("Mapping file");
    }

    private void setScriptProperties(WorkflowNode node, String newScriptValue, String newTypeValue) {
        String oldScriptValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)node, (String)"xmlContent");
        String oldTypeValue = WorkflowNodeUtil.getConfigurationValue((ComponentInstanceProperties)node, (String)"mappingType");
        if (oldScriptValue != null && !oldScriptValue.equals(newScriptValue) || oldScriptValue == null && oldScriptValue != newScriptValue) {
            SetScriptPropertiesValueCommand command = new SetScriptPropertiesValueCommand(oldScriptValue, newScriptValue, oldTypeValue, newTypeValue);
            this.execute(node, (WorkflowNodeCommand)command);
        }
    }

    private class ChangeToLoadedMappingFileCommand
    extends AbstractWorkflowNodeCommand {
        private WorkflowNode node;

        ChangeToLoadedMappingFileCommand(WorkflowNode node) {
            this.node = node;
        }

        protected void execute2() {
            ConfigurationDescription configDesc = this.node.getConfigurationDescription();
            configDesc.setConfigurationValue("mappingFileDeployment", "loaded");
            XmlMergerSection.this.removeMappingFileInput(this.getWorkflowNode());
        }

        protected void undo2() {
            ConfigurationDescription configDesc = this.node.getConfigurationDescription();
            configDesc.setConfigurationValue("mappingFileDeployment", "input");
            XmlMergerSection.this.addMappingFileInput(this.getWorkflowNode());
        }
    }

    private class ChangeToMappingFileAsInputCommand
    extends AbstractWorkflowNodeCommand {
        private String oldXmlContent;
        private WorkflowNode node;

        ChangeToMappingFileAsInputCommand(WorkflowNode node) {
            this.node = node;
        }

        protected void execute2() {
            ConfigurationDescription configDesc = this.node.getConfigurationDescription();
            configDesc.setConfigurationValue("mappingFileDeployment", "input");
            this.oldXmlContent = configDesc.getConfigurationValue("xmlContent");
            configDesc.setConfigurationValue("xmlContent", "");
            XmlMergerSection.this.addMappingFileInput(this.node);
        }

        protected void undo2() {
            ConfigurationDescription configDesc = this.node.getConfigurationDescription();
            configDesc.setConfigurationValue("mappingFileDeployment", "loaded");
            configDesc.setConfigurationValue("xmlContent", this.oldXmlContent);
            XmlMergerSection.this.removeMappingFileInput(this.node);
        }
    }

    private class EditScriptRunnable
    extends AbstractEditScriptRunnable {
        private final WorkflowNode node;

        EditScriptRunnable(WorkflowNode node) {
            this.node = node;
        }

        public WorkflowNode getNode() {
            return this.node;
        }

        protected void setScript(String script) {
            XmlMergerSection.this.setScriptProperties(this.node, script, this.node.getConfigurationDescription().getConfigurationValue("mappingType"));
        }

        protected String getScript() {
            return this.node.getConfigurationDescription().getConfigurationValue("xmlContent");
        }

        protected String getScriptName() {
            String suffix = this.node.getConfigurationDescription().getConfigurationValue("mappingType") != null && this.node.getConfigurationDescription().getConfigurationValue("mappingType").equals("Classic") ? ".xml" : ".xsl";
            return "Mapping" + suffix;
        }
    }

    private final class FileController
    extends WorkflowNodePropertySection.DefaultController {
        private FileController() {
            super((WorkflowNodePropertySection)XmlMergerSection.this);
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
            if (source == XmlMergerSection.this.loadMappingFileButton && XmlMergerSection.this.loadMappingFileButton.getSelection()) {
                if ("input".equals(this.getProperty("mappingFileDeployment"))) {
                    XmlMergerSection.this.execute((WorkflowNodeCommand)new ChangeToLoadedMappingFileCommand(XmlMergerSection.this.node));
                }
            } else if (source == XmlMergerSection.this.mappingFileAsInputButton && XmlMergerSection.this.mappingFileAsInputButton.getSelection()) {
                if ("loaded".equals(this.getProperty("mappingFileDeployment"))) {
                    XmlMergerSection.this.execute((WorkflowNodeCommand)new ChangeToMappingFileAsInputCommand(XmlMergerSection.this.node));
                }
            } else {
                super.widgetSelected(event, source);
                if (source == XmlMergerSection.this.fileChooser) {
                    XmlMergerSection.this.fileChoosing();
                } else if (source == XmlMergerSection.this.fileEditor) {
                    XmlMergerSection.this.esr = new EditScriptRunnable(XmlMergerSection.this.node);
                    XmlMergerSection.this.esr.run();
                }
            }
        }
    }

    private class MergerGUISynchronizer
    extends WorkflowNodePropertySection.DefaultSynchronizer {
        private MergerGUISynchronizer() {
            super((WorkflowNodePropertySection)XmlMergerSection.this);
        }

        public void handlePropertyChange(String propertyName, String newValue, String oldValue) {
            if (!propertyName.equals("mappingFileDeployment")) {
                super.handlePropertyChange(propertyName, newValue, oldValue);
            } else {
                XmlMergerSection.this.getUpdater().updateControl(null, propertyName, newValue, oldValue);
            }
        }

        protected void handlePropertyChange(Control control, String key, String newValue, String oldValue) {
            if (!key.equals("mappingFileDeployment")) {
                super.handlePropertyChange(control, key, newValue, oldValue);
            } else {
                XmlMergerSection.this.getUpdater().updateControl(control, key, newValue, oldValue);
            }
        }
    }

    private class MergerGUIUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        private MergerGUIUpdater() {
            super((WorkflowNodePropertySection)XmlMergerSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            if (!propertyName.equals("mappingFileDeployment")) {
                super.updateControl(control, propertyName, newValue, oldValue);
            }
            XmlMergerSection.this.setXMLFileContent();
        }
    }

    protected static class SetScriptPropertiesValueCommand
    extends AbstractWorkflowNodeCommand {
        private final String oldScriptValue;
        private final String newScriptValue;
        private String oldTypeValue;
        private String newTypeValue;

        public SetScriptPropertiesValueCommand(String oldScriptValue, String newScriptValue, String oldTypeValue, String newTypeValue) {
            this.oldScriptValue = oldScriptValue;
            this.newScriptValue = newScriptValue;
            this.oldTypeValue = oldTypeValue;
            this.newTypeValue = newTypeValue;
        }

        public void execute2() {
            ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
            configDesc.setConfigurationValue("xmlContent", this.newScriptValue);
            configDesc.setConfigurationValue("mappingType", this.newTypeValue);
        }

        public void undo2() {
            ConfigurationDescription configDesc = this.getProperties().getConfigurationDescription();
            configDesc.setConfigurationValue("xmlContent", this.oldScriptValue);
            configDesc.setConfigurationValue("mappingType", this.oldTypeValue);
        }
    }
}

