/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.common.internal;

import de.rcenvironment.components.parametricstudy.common.Study;
import de.rcenvironment.components.parametricstudy.common.StudyDataset;
import de.rcenvironment.components.parametricstudy.common.StudyPublisher;
import de.rcenvironment.components.parametricstudy.common.internal.ParametricStudyUtils;
import de.rcenvironment.core.notification.NotificationService;
import java.io.Serializable;

public final class StudyPublisherImpl
implements StudyPublisher {
    private static final long serialVersionUID = 6027553291193203997L;
    private final Study study;
    private final String notificationId;
    private NotificationService notificationService;

    public StudyPublisherImpl(Study study, NotificationService notificationService) {
        this.study = study;
        this.notificationService = notificationService;
        this.notificationId = ParametricStudyUtils.createDataIdentifier(study);
        this.setBufferSize(10000);
    }

    @Override
    public Study getStudy() {
        return this.study;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.notificationService.setBufferSize(this.notificationId, bufferSize);
    }

    @Override
    public void add(StudyDataset dataset) {
        this.notificationService.send(this.notificationId, (Serializable)dataset);
    }

    @Override
    public void clearStudy() {
        this.notificationService.removePublisher(this.notificationId);
    }
}

