/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution;

import de.rcenvironment.components.outputwriter.common.OutputWriterComponentConstants;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;

public class OutputLocationWriter {
    private static final String ITERATION = " - iteration ";
    private static final String BACKSLASHES = "\\";
    private static final String DOT = ".";
    private static final String DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss-S";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private File outputFile;
    private String basicName;
    private FileOutputStream outputStream;
    private List<String> inputNames;
    private final String header;
    private final String formatString;
    private final OutputWriterComponentConstants.HandleExistingFile handleExistingFile;
    private final ComponentLog componentLog;
    private long iterations;

    protected OutputLocationWriter(List<String> inputNames, String header, String formatString, OutputWriterComponentConstants.HandleExistingFile handle, ComponentLog componentLog) {
        this.header = header;
        this.formatString = formatString;
        this.handleExistingFile = handle;
        this.iterations = 0L;
        this.inputNames = inputNames;
        this.componentLog = componentLog;
    }

    protected void initializeFile(File fileToWrite) throws ComponentException {
        this.basicName = fileToWrite.getName();
        List<String> forbiddenFilenames = Arrays.asList(OutputWriterComponentConstants.PROBLEMATICFILENAMES_WIN);
        if (forbiddenFilenames.contains(this.basicName) || this.basicName.contains("/") || this.basicName.contains(BACKSLASHES)) {
            throw new ComponentException(StringUtils.format((String)"Failed to write file because '%s' is a forbidden filename", (Object[])new Object[]{this.basicName}));
        }
        this.outputFile = fileToWrite;
        if (this.handleExistingFile == OutputWriterComponentConstants.HandleExistingFile.APPEND || this.handleExistingFile == OutputWriterComponentConstants.HandleExistingFile.OVERRIDE) {
            if (fileToWrite.exists()) {
                this.outputFile = fileToWrite = this.autoRename(fileToWrite);
            }
            try {
                this.outputStream = FileUtils.openOutputStream((File)fileToWrite, (boolean)true);
                if (this.handleExistingFile == OutputWriterComponentConstants.HandleExistingFile.APPEND && !this.header.isEmpty()) {
                    Date dt = new Date();
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                    String timeStamp = df.format(dt);
                    FileUtils.writeStringToFile((File)this.outputFile, (String)(String.valueOf(this.formatHeader(timeStamp, 0)) + LINE_SEP), (boolean)true);
                }
            }
            catch (IOException e) {
                throw new ComponentException("Failed to create/initialize file used as target for simple data types: " + this.outputFile.getAbsolutePath(), (Throwable)e);
            }
        }
        this.componentLog.componentInfo("Created and initialized file used as target for simple data types: " + this.outputFile.getAbsolutePath());
    }

    protected void writeOutput(Map<String, TypedDatum> inputMap, String timestamp, int executionCount) throws ComponentException {
        String outputString = this.formatOutput(inputMap, timestamp, executionCount);
        ++this.iterations;
        try {
            if (this.handleExistingFile == OutputWriterComponentConstants.HandleExistingFile.APPEND) {
                FileUtils.writeStringToFile((File)this.outputFile, (String)outputString, (boolean)true);
            } else if (this.handleExistingFile == OutputWriterComponentConstants.HandleExistingFile.OVERRIDE) {
                if (!this.header.isEmpty()) {
                    Date dt = new Date();
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                    String timeStamp = df.format(dt);
                    FileUtils.writeStringToFile((File)this.outputFile, (String)(String.valueOf(this.formatHeader(timeStamp, executionCount)) + LINE_SEP + outputString), (boolean)false);
                } else {
                    FileUtils.writeStringToFile((File)this.outputFile, (String)outputString, (boolean)false);
                }
            } else if (this.handleExistingFile == OutputWriterComponentConstants.HandleExistingFile.AUTORENAME) {
                if (!this.header.isEmpty()) {
                    Date dt = new Date();
                    SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                    String timeStamp = df.format(dt);
                    this.outputFile = this.getNamePerIteration(this.outputFile);
                    FileUtils.writeStringToFile((File)this.outputFile, (String)(String.valueOf(this.formatHeader(timeStamp, executionCount)) + LINE_SEP + outputString), (boolean)false);
                } else {
                    this.outputFile = this.getNamePerIteration(this.outputFile);
                    FileUtils.writeStringToFile((File)this.outputFile, (String)outputString, (boolean)false);
                }
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to write file used as target for simple data types: " + this.outputFile.getAbsolutePath(), (Throwable)e);
        }
        this.componentLog.componentInfo(StringUtils.format((String)"Wrote '%s' to: %s", (Object[])new Object[]{inputMap, this.outputFile.getAbsolutePath()}));
    }

    protected String formatOutput(Map<String, TypedDatum> inputMap, String timestamp, int executionCount) {
        String outputString = this.formatString;
        outputString = outputString.replaceAll(this.escapePlaceholder("[Timestamp]"), timestamp);
        outputString = outputString.replaceAll(this.escapePlaceholder("[Linebreak]"), LINE_SEP);
        outputString = outputString.replaceAll(this.escapePlaceholder("[Execution count]"), Integer.toString(executionCount));
        for (Map.Entry<String, TypedDatum> entry : inputMap.entrySet()) {
            outputString = outputString.replaceAll(String.valueOf(this.escapePlaceholder("[")) + entry.getKey() + this.escapePlaceholder("]"), entry.getValue().toString());
            outputString = outputString.replaceAll(String.valueOf(this.escapePlaceholder("[")) + "Input name" + " - " + entry.getKey() + this.escapePlaceholder("]"), entry.getKey());
        }
        return outputString;
    }

    protected String formatHeader(String timestamp, int executionCount) {
        String outputString = this.header;
        outputString = outputString.replaceAll(this.escapePlaceholder("[Timestamp]"), timestamp);
        outputString = outputString.replaceAll(this.escapePlaceholder("[Linebreak]"), LINE_SEP);
        outputString = outputString.replaceAll(this.escapePlaceholder("[Execution count]"), Integer.toString(executionCount));
        for (String inputName : this.inputNames) {
            outputString = outputString.replaceAll(String.valueOf(this.escapePlaceholder("[")) + "Input name" + " - " + inputName + this.escapePlaceholder("]"), inputName);
        }
        return outputString;
    }

    private String escapePlaceholder(String placeholder) {
        placeholder = placeholder.replace("[", "\\[");
        return placeholder.replace("]", "\\]");
    }

    protected File getNamePerIteration(File fileToWrite) {
        File possibleFile;
        String folderpath = fileToWrite.getParent();
        String fileName = this.basicName;
        String extension = "";
        if (fileName.contains(DOT)) {
            extension = fileName.substring(fileName.lastIndexOf(DOT));
            fileName = fileName.substring(0, fileName.lastIndexOf(DOT));
        }
        if ((possibleFile = new File(folderpath, String.valueOf(fileName) + ITERATION + this.iterations + extension)).exists()) {
            possibleFile = this.autoRename(possibleFile);
        }
        return possibleFile;
    }

    protected void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Failed to close output stream: ", (Throwable)e);
        }
    }

    protected File autoRename(File fileToWrite) {
        String folderpath = fileToWrite.getParent();
        String fileName = fileToWrite.getName();
        String extension = "";
        if (fileName.contains(DOT)) {
            extension = fileName.substring(fileName.lastIndexOf(DOT));
            fileName = fileName.substring(0, fileName.lastIndexOf(DOT));
        }
        int i = 1;
        File possibleFile = new File(folderpath, String.valueOf(fileName) + " (" + i + ")" + extension);
        while (possibleFile.exists()) {
            possibleFile = new File(folderpath, String.valueOf(fileName) + " (" + ++i + ")" + extension);
        }
        this.componentLog.componentInfo(StringUtils.format((String)"File '%s' already exists, renamed to: %s", (Object[])new Object[]{fileToWrite.getAbsolutePath(), possibleFile.getAbsolutePath()}));
        return possibleFile;
    }
}

