/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.joiner.execution;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.joiner.common.JoinerComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.UUID;

public class JoinerPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String DATATYPE = "datatype";
    private static final String CONFIGURATION = "configuration";
    private static final String MERGED = "Merged";
    private static final String IDENTIFIER = "identifier";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String NAME = "name";
    private static final String DYNAMIC_ADD_INPUTS = "addInput";
    private static final String V1_0 = "1.0";
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private static final String V3_2 = "3.2";
    private static final String V3_3 = "3.3";
    private final JsonFactory jsonFactory = new JsonFactory();

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return JoinerComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (silent && (persistentComponentDescriptionVersion == null || persistentComponentDescriptionVersion.compareTo(V1_0) < 0)) {
            versionsToUpdate |= 1;
        } else if (silent && persistentComponentDescriptionVersion.compareTo(V3_3) < 0) {
            versionsToUpdate |= 4;
        } else if (!silent && persistentComponentDescriptionVersion != null) {
            if (persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
                versionsToUpdate |= 2;
            }
            if (persistentComponentDescriptionVersion.compareTo(V3_2) < 0) {
                versionsToUpdate |= 4;
            }
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        block24: {
            block22: {
                if (silent && formatVersion == 1) {
                    return this.updateToV1(description);
                }
                if (!silent && formatVersion == 2) {
                    return this.updateToV3(description);
                }
                if (silent || formatVersion != 4) break block22;
                switch (description.getComponentVersion()) {
                    case "3.0": {
                        description = this.updateFromV3ToV31(description);
                    }
                    case "3.1": {
                        description = this.updateFromV31ToV32(description);
                    }
                    case "3.2": {
                        description = this.updateFromV32ToV33(description);
                        break;
                    }
                }
                break block24;
            }
            if (!silent || formatVersion != 4) break block24;
            switch (description.getComponentVersion()) {
                case "3.2": {
                    description = this.updateFromV32ToV33(description);
                    break;
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFromV32ToV33(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectNode configuration;
        String inputCount;
        String dataType;
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        ObjectNode node = (ObjectNode)mapper.readTree(description.getComponentDescriptionAsString());
        if (node.has(DYNAMIC_INPUTS)) {
            ArrayNode dynInputs = (ArrayNode)node.get(DYNAMIC_INPUTS);
            ObjectNode firstInput = (ObjectNode)dynInputs.get(0);
            dataType = firstInput.get(DATATYPE).textValue();
            inputCount = String.valueOf(dynInputs.size());
        } else {
            dataType = "Float";
            inputCount = "0";
        }
        if (node.has(CONFIGURATION)) {
            configuration = (ObjectNode)node.get(CONFIGURATION);
            configuration.removeAll();
        } else {
            configuration = node.putObject(CONFIGURATION);
        }
        configuration.put("inputCount", inputCount);
        configuration.put(DATATYPE, dataType);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        description.setComponentVersion(V3_3);
        return description;
    }

    private PersistentComponentDescription updateFromV31ToV32(PersistentComponentDescription description) throws JsonParseException, IOException {
        ObjectNode configuration;
        JsonParser jsonParser = this.jsonFactory.createParser(description.getComponentDescriptionAsString());
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readTree(jsonParser);
        TextNode nameNode = (TextNode)rootNode.get(NAME);
        String nodeName = nameNode.textValue();
        if (nodeName.contains("Merger")) {
            nodeName = nodeName.replaceAll("Merger", "Joiner");
            ((ObjectNode)rootNode).set(NAME, (JsonNode)TextNode.valueOf((String)nodeName));
        }
        ArrayNode staticOutputs = (ArrayNode)rootNode.get("staticOutputs");
        ObjectNode staticOutput = (ObjectNode)staticOutputs.get(0);
        staticOutput.set(NAME, (JsonNode)TextNode.valueOf((String)"Joined"));
        JsonNode dynInputs = rootNode.get(DYNAMIC_INPUTS);
        if (dynInputs != null) {
            for (JsonNode dynInput : dynInputs) {
                ((ObjectNode)dynInput).set("epIdentifier", (JsonNode)TextNode.valueOf((String)"toJoin"));
            }
        }
        if ((configuration = (ObjectNode)rootNode.get(CONFIGURATION)) != null) {
            String number = configuration.get(MERGED).textValue();
            configuration.remove(MERGED);
            configuration.set("Joined", (JsonNode)TextNode.valueOf((String)number));
        } else {
            configuration = mapper.createObjectNode();
            configuration.set("Joined", (JsonNode)TextNode.valueOf((String)"2"));
            ((ObjectNode)rootNode).set(CONFIGURATION, (JsonNode)configuration);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)rootNode));
        description.setComponentVersion(V3_2);
        jsonParser.close();
        return description;
    }

    private PersistentComponentDescription updateFromV3ToV31(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonParser jsonParser = this.jsonFactory.createParser(description.getComponentDescriptionAsString());
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readTree(jsonParser);
        JsonNode staticInputs = rootNode.get("staticInputs");
        if (staticInputs != null) {
            for (JsonNode staticInput : staticInputs) {
                String name = staticInput.get(NAME).textValue();
                String number = name.substring(name.length() - 3);
                for (JsonNode dynInput : rootNode.get(DYNAMIC_INPUTS)) {
                    if (!dynInput.get(NAME).textValue().endsWith(number)) continue;
                    ((ObjectNode)dynInput).set(IDENTIFIER, staticInput.get(IDENTIFIER));
                }
            }
        }
        ((ObjectNode)rootNode).remove("staticInputs");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)rootNode));
        description.setComponentVersion(V3_1);
        jsonParser.close();
        return description;
    }

    private PersistentComponentDescription updateToV3(PersistentComponentDescription description) throws JsonParseException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)DYNAMIC_INPUTS, (String)"toJoin", (PersistentComponentDescription)description);
        JsonParser jsonParser = this.jsonFactory.createParser(description.getComponentDescriptionAsString());
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readTree(jsonParser);
        ArrayNode staticOutputs = JsonNodeFactory.instance.arrayNode();
        ObjectNode output = JsonNodeFactory.instance.objectNode();
        output.set(NAME, (JsonNode)TextNode.valueOf((String)MERGED));
        output.set(IDENTIFIER, (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        output.set(DATATYPE, (JsonNode)TextNode.valueOf((String)rootNode.get(DYNAMIC_INPUTS).get(0).get(DATATYPE).textValue()));
        staticOutputs.add((JsonNode)output);
        ((ObjectNode)rootNode).set("staticOutputs", (JsonNode)staticOutputs);
        ((ObjectNode)rootNode).remove("dynamicOutputs");
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)rootNode));
        description.setComponentVersion(V3_0);
        jsonParser.close();
        return description;
    }

    private PersistentComponentDescription updateToV1(PersistentComponentDescription description) throws IOException, JsonParseException, JsonProcessingException, JsonGenerationException, JsonMappingException {
        JsonParser jsonParser = this.jsonFactory.createParser(description.getComponentDescriptionAsString());
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readTree(jsonParser);
        ArrayNode dynamicInputsNode = (ArrayNode)rootNode.findPath(DYNAMIC_ADD_INPUTS);
        ArrayNode newDynamicInputsNode = JsonNodeFactory.instance.arrayNode();
        for (JsonNode endpoint : dynamicInputsNode) {
            String newString = "Input " + endpoint.textValue().substring(endpoint.textValue().indexOf("_") + 1);
            newDynamicInputsNode.add((JsonNode)TextNode.valueOf((String)newString));
        }
        ((ObjectNode)rootNode).remove(DYNAMIC_ADD_INPUTS);
        ((ObjectNode)rootNode).set(DYNAMIC_ADD_INPUTS, (JsonNode)newDynamicInputsNode);
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)rootNode));
        description.setComponentVersion(V1_0);
        jsonParser.close();
        return description;
    }
}

