/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.common.internal;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.activeX.ActiveXDispatchEvents;
import com.jacob.activeX.ActiveXInvocationProxy;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import de.rcenvironment.components.excel.common.ExcelException;
import de.rcenvironment.components.excel.common.ExcelServiceGUIEvents;
import de.rcenvironment.components.excel.common.internal.ExcelServicePOI;
import de.rcenvironment.core.datamodel.api.TypedDatumFactory;
import java.io.File;
import java.util.HashSet;

public class ExcelServiceOLE
extends ExcelServicePOI
implements ExcelServiceGUIEvents {
    private static final String OLE_DISPLAY_ALERTS = "DisplayAlerts";
    private static final String OLE_ACTIVE_WORKBOOK = "ActiveWorkbook";
    private static final String OLE_ACTIVE_SHEET = "ActiveSheet";
    private static final String OLE_OPEN = "Open";
    private static final String OLE_WORKBOOKS = "Workbooks";
    private static final String OLE_VISIBLE = "Visible";
    private static final String EXCELAPPLICATION_PROGRAMID = "Excel.Application";
    private static final String EXCELAPPLICATION_EXE = "\\EXCEL.EXE";
    private String typeLibLocation = "C:\\Program Files (x86)\\Microsoft Office\\OFFICE14\\EXCEL.EXE";

    public ExcelServiceOLE() {
    }

    public ExcelServiceOLE(TypedDatumFactory typedDatumFactory) {
        super(typedDatumFactory);
    }

    @Override
    public String[] getMacros(File xlFile) throws ExcelException {
        HashSet<String> macros = new HashSet<String>();
        ComThread.InitSTA();
        ActiveXComponent objExcel = null;
        try {
            try {
                objExcel = new ActiveXComponent(EXCELAPPLICATION_PROGRAMID);
                objExcel.setProperty(OLE_VISIBLE, new Variant(false));
                Dispatch workbooks = objExcel.getProperty(OLE_WORKBOOKS).toDispatch();
                workbooks = Dispatch.call((Dispatch)workbooks, (String)OLE_OPEN, (Object[])new Object[]{xlFile.getAbsolutePath()}).toDispatch();
                Dispatch activeWorkbook = objExcel.getProperty(OLE_ACTIVE_WORKBOOK).toDispatch();
                Variant varVbproject = Dispatch.get((Dispatch)activeWorkbook, (String)"VBProject");
                if (varVbproject != null) {
                    Dispatch vbproject = varVbproject.toDispatch();
                    Dispatch vbcomponents = Dispatch.get((Dispatch)vbproject, (String)"VBComponents").toDispatch();
                    Variant varCount = Dispatch.get((Dispatch)vbcomponents, (String)"Count");
                    int i = 1;
                    while (i <= varCount.getInt()) {
                        Dispatch vbComponent = Dispatch.call((Dispatch)vbcomponents, (String)"Item", (Object[])new Object[]{new Variant(i)}).toDispatch();
                        String name = Dispatch.get((Dispatch)vbComponent, (String)"Name").getString();
                        Dispatch codeModule = Dispatch.get((Dispatch)vbComponent, (String)"CodeModule").getDispatch();
                        int noOfLines = Dispatch.get((Dispatch)codeModule, (String)"CountOfLines").getInt();
                        int j = 1;
                        while (j <= noOfLines) {
                            String line = Dispatch.invoke((Dispatch)codeModule, (String)"ProcOfLine", (int)2, (Object[])new Object[]{j, 0}, (int[])new int[1]).toString();
                            macros.add(String.valueOf(name) + "." + line);
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (RuntimeException e) {
                String[] noMacroFoundArray = new String[]{"Failed to access macros - see log for details."};
                LOGGER.warn((Object)("Failed to load macros. Possibly your security setting prevent you from accessing macros with your Excel installation. Excel response: " + e.getMessage()));
                String[] stringArray = noMacroFoundArray;
                this.quitExcel(objExcel, false);
                ComThread.Release();
                return stringArray;
            }
        }
        finally {
            this.quitExcel(objExcel, false);
            ComThread.Release();
        }
        return macros.toArray(new String[0]);
    }

    @Override
    public void runMacro(File xlFile, String macroname) throws ExcelException {
        if (macroname != null && !macroname.isEmpty()) {
            ComThread.InitSTA();
            ActiveXComponent objExcel = null;
            try {
                try {
                    objExcel = new ActiveXComponent(EXCELAPPLICATION_PROGRAMID);
                    objExcel.setProperty(OLE_VISIBLE, new Variant(false));
                    Dispatch workbooks = objExcel.getProperty(OLE_WORKBOOKS).toDispatch();
                    workbooks = Dispatch.call((Dispatch)workbooks, (String)OLE_OPEN, (Object[])new Object[]{xlFile.getAbsolutePath()}).toDispatch();
                    Dispatch activeWorkbook = objExcel.getProperty(OLE_ACTIVE_WORKBOOK).toDispatch();
                    Dispatch.call((Dispatch)objExcel, (String)"run", (Object[])new Object[]{macroname});
                    int i = 0;
                    while (i < 600) {
                        try {
                            objExcel.setProperty(OLE_DISPLAY_ALERTS, false);
                            objExcel.setProperty("CalculateBeforeSave", false);
                            Dispatch.call((Dispatch)activeWorkbook, (String)"Save");
                            break;
                        }
                        catch (RuntimeException e) {
                            if (i == 599) {
                                LOGGER.error((Object)("Cannot save file with result data after running macro: " + macroname + "."));
                                throw e;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e2) {
                                LOGGER.error((Object)e2);
                            }
                            ++i;
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw new ExcelException("Cannot run macro with OLE interface.", e);
                }
            }
            finally {
                this.quitExcel(objExcel, false);
                ComThread.Release();
            }
        }
    }

    @Override
    public void recalculateFormulas(File xlFile) throws ExcelException {
        ComThread.InitSTA();
        ActiveXComponent objExcel = null;
        try {
            try {
                objExcel = new ActiveXComponent(EXCELAPPLICATION_PROGRAMID);
                objExcel.setProperty(OLE_VISIBLE, new Variant(false));
                Dispatch workbooks = objExcel.getProperty(OLE_WORKBOOKS).toDispatch();
                workbooks = Dispatch.call((Dispatch)workbooks, (String)OLE_OPEN, (Object[])new Object[]{xlFile.getAbsolutePath()}).toDispatch();
                Dispatch activeWorkbook = objExcel.getProperty(OLE_ACTIVE_WORKBOOK).toDispatch();
                Dispatch.call((Dispatch)objExcel, (String)"CalculateFullRebuild");
                objExcel.setProperty(OLE_DISPLAY_ALERTS, false);
                objExcel.setProperty("CalculateBeforeSave", false);
                Dispatch.call((Dispatch)activeWorkbook, (String)"Save");
            }
            catch (RuntimeException e) {
                throw new ExcelException("Cannot recalculate formulas with OLE interface.", e);
            }
        }
        finally {
            this.quitExcel(objExcel, false);
            ComThread.Release();
        }
    }

    @Override
    public ActiveXComponent openExcelApplicationRegisterListener(File xlFile, String address, ActiveXInvocationProxy listener) {
        ActiveXComponent objExcel = null;
        try {
            objExcel = new ActiveXComponent(EXCELAPPLICATION_PROGRAMID);
            this.typeLibLocation = String.valueOf(objExcel.getProperty("Path").getString()) + EXCELAPPLICATION_EXE;
            objExcel.setProperty(OLE_VISIBLE, new Variant(true));
            Dispatch workbooks = objExcel.getProperty(OLE_WORKBOOKS).toDispatch();
            Dispatch.call((Dispatch)workbooks, (String)OLE_OPEN, (Object[])new Object[]{xlFile.getAbsolutePath()}).toDispatch();
            if (address != null && !address.isEmpty() && address.split("!").length == 2) {
                String[] rawAddress = address.split("!");
                Dispatch sheet = Dispatch.call((Dispatch)objExcel, (String)"Sheets", (Object[])new Object[]{new Variant((Object)rawAddress[0])}).toDispatch();
                Dispatch.call((Dispatch)sheet, (String)"Activate");
                Dispatch range = Dispatch.call((Dispatch)sheet, (String)"Range", (Object[])new Object[]{new Variant((Object)rawAddress[1])}).toDispatch();
                Dispatch.call((Dispatch)range, (String)"Select");
            } else {
                Dispatch sheet = objExcel.getProperty(OLE_ACTIVE_SHEET).toDispatch();
                Dispatch range = Dispatch.call((Dispatch)sheet, (String)"Range", (Object[])new Object[]{new Variant((Object)"A1")}).toDispatch();
                Dispatch.call((Dispatch)range, (String)"Select");
            }
            if (listener != null) {
                new ActiveXDispatchEvents((Dispatch)objExcel, (Object)listener, EXCELAPPLICATION_PROGRAMID, this.typeLibLocation);
            }
            return objExcel;
        }
        catch (RuntimeException e) {
            this.quitExcel(objExcel, false);
            throw new ExcelException("Cannot open Excel Application with GUI and event listener with OLE interface.", e);
        }
    }

    @Override
    public void quitExcel(ActiveXComponent axc, boolean displayAlerts) {
        if (axc != null) {
            axc.setProperty(OLE_DISPLAY_ALERTS, displayAlerts);
            axc.invoke("Quit", new Variant[0]);
        }
    }
}

