/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TypedProperties<KeyType extends Serializable> {
    private Map<KeyType, Serializable> values = new LinkedHashMap<KeyType, Serializable>();
    private Map<KeyType, Class<? extends Serializable>> types = new LinkedHashMap<KeyType, Class<? extends Serializable>>();

    public int size() {
        return this.values.size();
    }

    public void put(KeyType propertyName, Serializable value) throws IllegalStateException {
        this.put(propertyName, value, true);
    }

    protected void put(KeyType propertyName, Serializable value, boolean throwException) throws IllegalStateException {
        assert (propertyName != null);
        assert (value != null);
        Class<?> newType = value.getClass();
        if (throwException) {
            Class<? extends Serializable> type = this.types.get(propertyName);
            if (type != null) {
                if (type != newType && !type.isAssignableFrom(newType)) {
                    throw new IllegalStateException("The provided type differs from the type already contained or not a subclass");
                }
            } else {
                this.types.put(propertyName, newType);
            }
        } else {
            this.types.put(propertyName, newType);
        }
        this.values.put(propertyName, value);
    }

    public void setType(KeyType propertyName, Class<? extends Serializable> type) {
        assert (propertyName != null);
        assert (type != null);
        this.values.put(propertyName, null);
        this.types.put(propertyName, type);
    }

    public <U extends Serializable> U get(KeyType propertyName, Class<U> clazz) throws IllegalStateException {
        assert (propertyName != null);
        assert (clazz != null);
        Class<? extends Serializable> type = this.types.get(propertyName);
        if (type == null) {
            return null;
        }
        if (clazz != type && !clazz.isAssignableFrom(type)) {
            throw new IllegalStateException("The contained type differs from the type requested");
        }
        return (U)this.values.get(propertyName);
    }

    public boolean containsKey(KeyType propertyName) {
        return this.values.containsKey(propertyName);
    }

    public boolean remove(KeyType propertyName) {
        boolean found = this.values.remove(propertyName) != null || propertyName == null;
        this.types.remove(propertyName);
        return found;
    }

    public boolean remove(KeyType propertyName, Class<? extends Serializable> clazz) {
        if (!this.containsKey(propertyName) || !this.hasType(propertyName, clazz)) {
            return false;
        }
        return this.remove(propertyName);
    }

    public boolean hasType(KeyType propertyName, Class<? extends Serializable> clazz) {
        Class<? extends Serializable> type = this.types.get(propertyName);
        if (type == null) {
            throw new IllegalStateException("Property not contained");
        }
        return clazz.isAssignableFrom(type);
    }

    public Class<? extends Serializable> getType(KeyType propertyName) {
        return this.types.get(propertyName);
    }

    public Set<KeyType> keySet() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public Set<Map.Entry<KeyType, Serializable>> valuesEntrySet() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    public Set<Map.Entry<KeyType, Class<? extends Serializable>>> typesEntrySet() {
        return Collections.unmodifiableSet(this.types.entrySet());
    }

    public void clear() {
        this.values.clear();
        this.types.clear();
    }

    protected void addAll(Map<KeyType, Serializable> map, boolean disallowWrongTypes) {
        IllegalStateException exception = null;
        for (Map.Entry<KeyType, Serializable> entry : map.entrySet()) {
            try {
                this.put((Serializable)entry.getKey(), entry.getValue(), disallowWrongTypes);
            }
            catch (IllegalStateException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw new IllegalStateException("At least one entry in the provided map had the wrong type. First occurrence: " + exception.getMessage());
        }
    }

    public void addAll(Map<KeyType, Serializable> map) throws IllegalStateException {
        this.addAll(map, true);
    }

    public void addAllOverwriting(Map<KeyType, Serializable> map) {
        this.addAll(map, false);
    }

    protected void addAll(TypedProperties<KeyType> properties, boolean disallowWrongTypes) throws IllegalStateException {
        Throwable exception = null;
        for (Serializable propertyName : properties.keySet()) {
            Serializable value;
            block4: {
                Class<Serializable> type = properties.getType(propertyName);
                value = properties.get(propertyName, type);
                try {
                    this.get(propertyName, type);
                }
                catch (IllegalStateException e) {
                    if (!disallowWrongTypes) break block4;
                    exception = e;
                    continue;
                }
            }
            this.put(propertyName, value, false);
        }
        if (exception != null) {
            throw new IllegalStateException("At least one entry in the provided properties had the wrong type. First occurrence: " + exception.getMessage());
        }
    }

    public void addAll(TypedProperties<KeyType> properties) throws IllegalStateException {
        this.addAll(properties, true);
    }

    public void addAllOverwriting(TypedProperties<KeyType> properties) {
        this.addAll(properties, false);
    }

    public void hasValidTypes(Map<KeyType, Class<? extends Serializable>> typesToCheck) throws IllegalStateException {
        for (Map.Entry<KeyType, Class<Serializable>> type : typesToCheck.entrySet()) {
            if (!typesToCheck.containsKey(type.getKey())) {
                throw new IllegalStateException("Missing property " + type.getKey() + " in execution context");
            }
            if (typesToCheck.get(type.getKey()) == type.getValue()) continue;
            throw new IllegalStateException("Property " + type.getKey() + " has wrong type " + type.getClass().getTypeParameters().toString());
        }
    }
}

