/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.common.xml.impl;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.xml.XMLException;
import de.rcenvironment.core.utils.common.xml.XMLNamespaceContext;
import de.rcenvironment.core.utils.common.xml.XSLTErrorHandler;
import de.rcenvironment.core.utils.common.xml.api.XMLSupportService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSupportServiceImpl
implements XMLSupportService {
    private static final String NO_NODE_FOUND_FOR_THE_XPATH_EXPRESSION = "No element found for the xpath expression: %s.";
    private static final String GENERATE_NODE_FOR_THE_XPATH_EXPRESSION = "Generated element for xpath expression '%s' as it was not existent.";
    private static final String ERROR_WHILE_PARSING_XML_FILE = "Error while parsing XML file: ";
    private static final String ERROR_WHILE_PARSING_XML_STRING = "Error while reading XML string: ";
    private static final String XPATH_DELIMITER = "/";
    private static final String QUOTE_CHAR = "\"";
    private static final String SINGLE_QUOTE_CHAR = "'";
    private static final String NS_DELIMITER = ":";
    private DocumentBuilderFactory dbf;
    private TransformerFactory transformerFactory;
    private XPathFactory xpathFactory;
    private Log log = LogFactory.getLog(this.getClass());

    public XMLSupportServiceImpl() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setIgnoringElementContentWhitespace(true);
        this.dbf.setNamespaceAware(true);
        this.dbf.setValidating(false);
        this.transformerFactory = TransformerFactory.newInstance();
        this.transformerFactory.setErrorListener(new XSLTErrorHandler());
        this.xpathFactory = XPathFactory.newInstance();
    }

    private Transformer getNewFormatter() throws XMLException {
        try {
            StreamSource source = new StreamSource(this.getClass().getClassLoader().getResourceAsStream("XMLFormatter.xslt"));
            Transformer formatter = this.transformerFactory.newTransformer(source);
            formatter.setErrorListener(new XSLTErrorHandler());
            return formatter;
        }
        catch (TransformerConfigurationException e1) {
            throw new XMLException("Transformer for formatting could not be created: " + e1.toString());
        }
    }

    @Override
    public Document readXMLFromFile(File file) throws XMLException {
        Document doc;
        try {
            DocumentBuilder db = this.getNewDocBuilder();
            doc = db.parse(file);
        }
        catch (IOException | SAXException e) {
            throw new XMLException(ERROR_WHILE_PARSING_XML_FILE + file.getAbsolutePath() + " " + e.toString());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new XMLException(ERROR_WHILE_PARSING_XML_FILE + e.toString());
        }
        return doc;
    }

    @Override
    public Document readXMLFromStream(InputStream stream) throws XMLException {
        Document doc;
        try {
            DocumentBuilder db = this.getNewDocBuilder();
            doc = db.parse(stream);
        }
        catch (IOException | NullPointerException | SAXException e) {
            throw new XMLException(ERROR_WHILE_PARSING_XML_FILE + e.toString());
        }
        return doc;
    }

    @Override
    public Document readXMLFromString(String aString) throws XMLException {
        Document doc;
        try {
            DocumentBuilder db = this.getNewDocBuilder();
            doc = db.parse(new InputSource(new StringReader(aString)));
        }
        catch (IOException | SAXException e) {
            throw new XMLException(ERROR_WHILE_PARSING_XML_STRING + aString + " " + e.toString());
        }
        catch (NullPointerException e) {
            throw new XMLException(ERROR_WHILE_PARSING_XML_STRING + e.toString());
        }
        return doc;
    }

    @Override
    public Node createElementTree(Document doc, String xPathStr) throws XMLException {
        Node parentNode = doc.getDocumentElement();
        try {
            String[] elements;
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setNamespaceContext(new XMLNamespaceContext(doc));
            StringBuilder currPath = new StringBuilder("");
            String[] stringArray = elements = xPathStr.split(XPATH_DELIMITER);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.length() != 0) {
                    currPath.append(XPATH_DELIMITER).append(element);
                    Node tempNode = (Node)xpath.evaluate(currPath.toString(), doc, XPathConstants.NODE);
                    if (tempNode != null) {
                        parentNode = tempNode;
                    } else {
                        Element elementNode = this.createElement(doc, element);
                        if (parentNode == null) {
                            doc.appendChild(elementNode);
                        } else {
                            parentNode.appendChild(elementNode);
                        }
                        parentNode = elementNode;
                    }
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            throw new XMLException("Error while building element tree: " + e.toString());
        }
        return parentNode;
    }

    @Override
    public Element createElement(Document doc, String elementString) throws XMLException {
        if (doc == null) {
            throw new XMLException("Cannot create element, document is null");
        }
        String[] elementParts = elementString.split("\\[|\\]");
        if (elementParts.length == 0) {
            return null;
        }
        String elementName = elementParts[0].trim();
        if (elementName.length() == 0) {
            return null;
        }
        String[] nameParts = elementName.split(NS_DELIMITER);
        Element elementNode = nameParts.length == 1 ? doc.createElement(elementName) : doc.createElementNS(doc.lookupNamespaceURI(nameParts[0]), elementName);
        int j = 1;
        while (j < elementParts.length) {
            String predicate = elementParts[j].trim();
            if (predicate.length() != 0 && !Character.isDigit(predicate.charAt(0))) {
                if (predicate.startsWith("@")) {
                    String[] attrNameParts;
                    String attrStr = predicate.substring(1);
                    String[] attribute = attrStr.split("=");
                    String attrName = attribute[0];
                    String attrValue = "";
                    if (attribute.length == 2) {
                        attrValue = attribute[1];
                    }
                    if (attrValue.startsWith(QUOTE_CHAR) || attrValue.startsWith(SINGLE_QUOTE_CHAR)) {
                        attrValue = attrValue.substring(1);
                    }
                    if (attrValue.endsWith(QUOTE_CHAR) || attrValue.endsWith(SINGLE_QUOTE_CHAR)) {
                        attrValue = attrValue.substring(0, attrValue.length() - 1);
                    }
                    if ((attrNameParts = attrName.split(NS_DELIMITER)).length == 1) {
                        elementNode.setAttribute(attrName, attrValue);
                    } else {
                        elementNode.setAttributeNS(doc.lookupNamespaceURI(attrNameParts[0]), attrName, attrValue);
                    }
                } else {
                    String[] subNodeNameParts;
                    String[] subNodeParts = predicate.split("=");
                    String subNodeName = subNodeParts[0];
                    String subNodeValue = "";
                    if (subNodeParts.length == 2) {
                        subNodeValue = subNodeParts[1];
                    }
                    if (subNodeValue.startsWith(QUOTE_CHAR)) {
                        subNodeValue = subNodeValue.substring(1);
                    }
                    if (subNodeValue.endsWith(QUOTE_CHAR)) {
                        subNodeValue = subNodeValue.substring(0, subNodeValue.length() - 1);
                    }
                    Element subNode = (subNodeNameParts = predicate.split(NS_DELIMITER)).length == 1 ? doc.createElement(subNodeName) : doc.createElementNS(doc.lookupNamespaceURI(subNodeNameParts[0]), subNodeName);
                    if (subNodeValue.length() > 0) {
                        Text textNode = doc.createTextNode(subNodeValue);
                        subNode.appendChild(textNode);
                    }
                    elementNode.appendChild(subNode);
                }
            }
            ++j;
        }
        return elementNode;
    }

    @Override
    public Document createDocument() throws XMLException {
        DocumentBuilder db = this.getNewDocBuilder();
        return db.newDocument();
    }

    @Override
    public void deleteElement(Document doc, String xPathStr) throws XMLException {
        try {
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setNamespaceContext(new XMLNamespaceContext(doc));
            NodeList nodes = (NodeList)xpath.evaluate(xPathStr, doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                Node parentNode = node.getParentNode();
                if (parentNode != null) {
                    parentNode.removeChild(node);
                } else if (node.getNodeType() == 9) {
                    NodeList children = node.getChildNodes();
                    int j = 0;
                    while (j < children.getLength()) {
                        node.removeChild(children.item(j));
                        ++j;
                    }
                } else {
                    throw new XMLException("Parent node is null, but node is not the document root node.");
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            throw new XMLException("Error while deleting element: " + e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceNodeText(Document doc, String xPathStr, String newValue, Boolean generateIfNotExist) throws XMLException {
        try {
            XPath xpath = this.xpathFactory.newXPath();
            xpath.setNamespaceContext(new XMLNamespaceContext(doc));
            NodeList nodes = (NodeList)xpath.evaluate(xPathStr, doc, XPathConstants.NODESET);
            if (nodes.getLength() == 0) {
                if (!generateIfNotExist.booleanValue()) throw new XMLException(StringUtils.format(NO_NODE_FOUND_FOR_THE_XPATH_EXPRESSION, xPathStr));
                this.log.debug((Object)StringUtils.format(GENERATE_NODE_FOR_THE_XPATH_EXPRESSION, xPathStr));
                Node node = this.createElementTree(doc, xPathStr);
                node.setTextContent(newValue);
                return;
            } else {
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    if (node.isSameNode(doc)) {
                        throw new XMLException("It is not allowed to replace the documents root node.");
                    }
                    node.setTextContent(newValue);
                    ++i;
                }
            }
            return;
        }
        catch (XPathExpressionException | DOMException e) {
            throw new XMLException("Error while replacing node text: " + e.toString());
        }
    }

    @Override
    public void writeXMLtoFile(Document doc, File file) throws XMLException {
        StreamResult result = new StreamResult(file.getAbsolutePath());
        DOMSource source = new DOMSource(doc);
        try {
            this.getNewFormatter().transform(source, result);
        }
        catch (TransformerException e) {
            throw new XMLException("Error while formatting XML file " + file.getAbsolutePath() + ": " + e.toString());
        }
    }

    @Override
    public String writeXMLToString(Document doc) throws XMLException {
        if (doc == null) {
            throw new XMLException("Error while formatting XML file, input Document was null.");
        }
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        try {
            this.getNewFormatter().transform(source, result);
        }
        catch (TransformerException e) {
            throw new XMLException("Error while formatting XML file: " + e.toString());
        }
        return writer.toString();
    }

    @Override
    public String writeXMLToString(Element sourceElement) throws XMLException {
        Document tempDoc = this.createDocument();
        Element importElement = (Element)tempDoc.importNode(sourceElement, true);
        tempDoc.appendChild(importElement);
        return this.writeXMLToString(tempDoc);
    }

    @Override
    public String getElementText(Document doc, String xpathStatement) throws XMLException {
        String errorMessage = "Failed to find element for given XPath: ";
        XPath xpath = this.xpathFactory.newXPath();
        String result = null;
        try {
            Node node = (Node)xpath.evaluate(xpathStatement, doc, XPathConstants.NODE);
            if (node == null) {
                throw new XMLException(String.valueOf(errorMessage) + xpathStatement);
            }
            if (node.getFirstChild() == null) {
                throw new XMLException(String.valueOf(errorMessage) + xpathStatement);
            }
            result = node.getFirstChild().getNodeValue();
        }
        catch (XPathExpressionException e) {
            throw new XMLException(String.valueOf(errorMessage) + xpathStatement, e);
        }
        return result;
    }

    private DocumentBuilder getNewDocBuilder() throws XMLException {
        DocumentBuilder db = null;
        try {
            db = this.dbf.newDocumentBuilder();
            db.setErrorHandler(new XMLSupportErrorHandler());
            return db;
        }
        catch (ParserConfigurationException e) {
            throw new XMLException("Document builder could not be created: " + e.toString());
        }
    }

    class XMLSupportErrorHandler
    implements ErrorHandler {
        private static final String ERROR_OCCURED_IN_DOCUMENT_BUILDER = "Error occured in document builder: ";

        XMLSupportErrorHandler() {
        }

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            XMLSupportServiceImpl.this.log.warn((Object)(ERROR_OCCURED_IN_DOCUMENT_BUILDER + arg0.toString()));
        }
    }
}

