/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.validators.internal;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResultFactory;
import de.rcenvironment.core.start.common.validation.spi.DefaultInstanceValidator;
import de.rcenvironment.core.start.validators.internal.Messages;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TempDirectoryWritableValidator
extends DefaultInstanceValidator {
    private ConfigurationService configurationService;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public InstanceValidationResult validate() {
        TempFileService tempFileService = TempFileServiceAccess.getInstance();
        this.log.debug((Object)"Initializing temp file service and creating a test file");
        try {
            File tempFile = tempFileService.createTempFileFromPattern("check.*.tmp");
            boolean canRead = tempFile.canRead();
            tempFileService.disposeManagedTempDirOrFile(tempFile);
            if (canRead) {
                return InstanceValidationResultFactory.createResultForPassed((String)"RCE temp directory");
            }
            this.log.error((Object)"Creating a temporary test file succeeded, but was not readable afterwards; a validation error will be generated");
        }
        catch (IOException e) {
            this.log.error((Object)"Error creating a temporary test file; a validation error will be generated", (Throwable)e);
        }
        String errorMessage = StringUtils.format((String)Messages.failedToCreateTempFile, (Object[])new Object[]{this.configurationService.getParentTempDirectoryRoot().getAbsolutePath()});
        return InstanceValidationResultFactory.createResultForFailureWhichRequiresInstanceShutdown((String)"RCE temp directory", (String)errorMessage);
    }

    protected void bindConfigurationService(ConfigurationService configIn) {
        this.configurationService = configIn;
    }
}

