/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.start.common;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.start.common.Instance;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationResult;
import de.rcenvironment.core.start.common.validation.api.InstanceValidationService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.VersionUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.app.IApplication;

public abstract class InstanceRunner {
    protected static volatile InstanceValidationService instanceValidationService;
    private static volatile CommandExecutionService commandExecutionService;
    protected final Log log = LogFactory.getLog(this.getClass());

    public void bindCommandExecutionService(CommandExecutionService newService) {
        commandExecutionService = newService;
    }

    public void bindInstanceValidationService(InstanceValidationService newService) {
        instanceValidationService = newService;
    }

    public int run() throws Exception {
        this.log.debug((Object)("Core version: " + VersionUtils.getVersionOfCoreBundles()));
        this.log.debug((Object)("Product version: " + VersionUtils.getVersionOfProduct()));
        this.log.debug((Object)("Command line arguments passed: " + System.getProperty("sun.java.command")));
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        for (String vmArg : runtime.getInputArguments()) {
            this.log.debug((Object)("JVM argument passed: " + vmArg));
        }
        if (Instance.isShutdownRequested()) {
            return IApplication.EXIT_OK;
        }
        if (!this.validateInstance()) {
            return IApplication.EXIT_OK;
        }
        return this.performRun();
    }

    private boolean validateInstance() {
        Map<InstanceValidationResult.InstanceValidationResultType, List<InstanceValidationResult>> validationResults = instanceValidationService.validateInstance();
        int passed = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.PASSED).size();
        int failedWithProceedingAllowed = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_PROCEEDING_ALLOWED).size();
        int failedWithShutdownRequired = validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED).size();
        this.log.debug((Object)StringUtils.format((String)"Instance validation results [%d in total]: %d passed, %d failed with proceeding allowed, %d failed with shutdown required", (Object[])new Object[]{passed + failedWithProceedingAllowed + failedWithShutdownRequired, passed, failedWithProceedingAllowed, failedWithShutdownRequired}));
        if (validationResults.containsKey((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_PROCEEDING_ALLOWED)) {
            for (InstanceValidationResult result : validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_PROCEEDING_ALLOWED)) {
                this.log.error((Object)StringUtils.format((String)"Instance validation '%s' failed: %s", (Object[])new Object[]{result.getValidationDisplayName(), result.getLogMessage()}));
            }
        }
        if (validationResults.containsKey((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED)) {
            for (InstanceValidationResult result : validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED)) {
                this.log.error((Object)StringUtils.format((String)"Instance validation '%s' failed: %s. RCE is shutting down", (Object[])new Object[]{result.getValidationDisplayName(), result.getLogMessage()}));
            }
        }
        if (failedWithProceedingAllowed > 0 || failedWithShutdownRequired > 0) {
            return this.onInstanceValidationFailures(validationResults);
        }
        return true;
    }

    public abstract int performRun() throws Exception;

    public boolean onInstanceValidationFailures(Map<InstanceValidationResult.InstanceValidationResultType, List<InstanceValidationResult>> validationResults) {
        return validationResults.get((Object)InstanceValidationResult.InstanceValidationResultType.FAILED_SHUTDOWN_REQUIRED).size() <= 0;
    }

    public void beforeAwaitShutdown() {
    }

    public void triggerShutdown() {
    }

    public void triggerRestart() {
    }

    protected Future<CommandExecutionResult> initiateAsyncCommandExecution(String[] execCommandTokens, final String taskDescription, final boolean isBatchMode) {
        if (commandExecutionService == null) {
            this.log.error((Object)("Command execution service not available; ignoring provided command(s) " + execCommandTokens));
            return null;
        }
        final String taskDescriptionWithTokens = String.valueOf(taskDescription) + " (\"" + org.apache.commons.lang3.StringUtils.join((Object[])execCommandTokens, (String)" ") + "\")";
        final PrintStream stdout = System.out;
        TextOutputReceiver outputReceiver = new TextOutputReceiver(){

            public void addOutput(String line) {
                if (isBatchMode) {
                    InstanceRunner.this.log.debug((Object)("Output of command-line batch command(s): " + line));
                    stdout.println(line);
                } else {
                    InstanceRunner.this.log.info((Object)("Output of command-line startup command(s): " + line));
                }
            }

            public void onStart() {
                InstanceRunner.this.log.debug((Object)("Starting " + taskDescriptionWithTokens));
            }

            public void onFatalError(Exception e) {
                CommandException ce = (CommandException)e;
                if (ce.getType().equals((Object)CommandException.Type.HELP_REQUESTED)) {
                    stdout.println(commandExecutionService.getHelpText(false, ce.shouldPrintDeveloperHelp()));
                } else {
                    InstanceRunner.this.log.error((Object)("Error during " + taskDescription), (Throwable)e);
                }
            }

            public void onFinished() {
                InstanceRunner.this.log.debug((Object)("Finished " + taskDescriptionWithTokens));
            }
        };
        return commandExecutionService.asyncExecMultiCommand(Arrays.asList(execCommandTokens), outputReceiver, (Object)taskDescription);
    }
}

