/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.properties;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowRunNodePart;
import de.rcenvironment.core.gui.workflow.view.properties.AbstractInputSection;
import de.rcenvironment.core.gui.workflow.view.properties.EditableInputLabelProvider;
import de.rcenvironment.core.gui.workflow.view.properties.InputQueueDialogController;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;

public class ComponentInputSection
extends AbstractInputSection {
    private static ComponentInputSection instance;
    private WorkflowNode workflowNode;
    private String componentId;

    public ComponentInputSection() {
        instance = this;
    }

    public static ComponentInputSection getInstance() {
        return instance;
    }

    @Override
    protected void retrieveWorkflowInformation(IWorkbenchPart part, ISelection selection) {
        Object firstSelectionElement = ((IStructuredSelection)selection).getFirstElement();
        this.workflowNode = (WorkflowNode)((WorkflowRunNodePart)firstSelectionElement).getModel();
        this.wfExeInfo = (WorkflowExecutionInformation)((WorkflowExecutionInformationPart)((WorkflowPart)((WorkflowRunNodePart)firstSelectionElement).getParent()).getParent()).getModel();
        this.componentId = this.wfExeInfo.getComponentExecutionInformation(this.workflowNode.getIdentifier()).getExecutionIdentifier();
    }

    @Override
    protected void initializeTreeViewer(IWorkbenchPart part, ISelection selection) {
        this.inputTreeViewer.setLabelProvider((IBaseLabelProvider)new EditableInputLabelProvider(this.wfExeInfo.getExecutionIdentifier(), this.componentId));
        this.inputTreeViewer.setInput(this.workflowNode);
    }

    @Override
    protected void openInputDialog(TreeItem item) {
        new InputQueueDialogController(this.wfExeInfo, this.componentId, item.getText()).open();
    }
}

