/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.console;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.view.console.ConsoleView;
import de.rcenvironment.core.utils.common.StringUtils;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ConsoleLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final int MAXIMUM_LENGTH_OF_DISPLAYED_CONSOLEROW = 180;
    private Image errImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.ERROR_16);
    private Image warningImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.WARNING_16);
    private Image infoImage = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16);
    private Image outImage = ImageDescriptor.createFromURL((URL)ConsoleView.class.getResource("/resources/icons/stdout16.gif")).createImage();
    private SimpleDateFormat timestampDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (element instanceof ConsoleRow) {
            ConsoleRow consoleRow = (ConsoleRow)element;
            if (columnIndex == 0) {
                if (ConsoleRow.Type.WORKFLOW_ERROR == consoleRow.getType() || ConsoleRow.Type.COMPONENT_ERROR == consoleRow.getType() || ConsoleRow.Type.TOOL_ERROR == consoleRow.getType()) {
                    result = this.errImage;
                } else if (ConsoleRow.Type.COMPONENT_WARN == consoleRow.getType()) {
                    result = this.warningImage;
                } else if (ConsoleRow.Type.TOOL_OUT == consoleRow.getType() || ConsoleRow.Type.COMPONENT_INFO == consoleRow.getType() || ConsoleRow.Type.LIFE_CYCLE_EVENT == consoleRow.getType()) {
                    result = this.outImage;
                } else if (ConsoleRow.Type.LIFE_CYCLE_EVENT == consoleRow.getType()) {
                    result = this.infoImage;
                }
            }
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        String returnValue = "";
        if (element instanceof ConsoleRow) {
            ConsoleRow row = (ConsoleRow)element;
            switch (columnIndex) {
                case 0: {
                    if (row.getType() == ConsoleRow.Type.TOOL_OUT || row.getType() == ConsoleRow.Type.TOOL_ERROR) {
                        returnValue = "Tool";
                        break;
                    }
                    if (row.getType() == ConsoleRow.Type.WORKFLOW_ERROR) {
                        returnValue = "Workflow";
                        break;
                    }
                    returnValue = "Component";
                    break;
                }
                case 1: {
                    returnValue = this.timestampDateFormat.format(row.getTimestamp());
                    break;
                }
                case 2: {
                    returnValue = row.getType() == ConsoleRow.Type.LIFE_CYCLE_EVENT && ConsoleRow.WorkflowLifecyleEventType.valueOf((String)row.getPayload()) == ConsoleRow.WorkflowLifecyleEventType.COMPONENT_TERMINATED ? StringUtils.format((String)"------ End of component '%s' ------", (Object[])new Object[]{row.getComponentName()}) : row.getPayload();
                    if (returnValue.length() <= 180) break;
                    returnValue = returnValue.substring(0, 180);
                    returnValue = String.valueOf(returnValue) + " ... (line is cut, it is too long; copy and paste it to get it at full length)";
                    break;
                }
                case 3: {
                    returnValue = row.getComponentName();
                    break;
                }
                case 4: {
                    returnValue = String.valueOf(row.getWorkflowName());
                    break;
                }
            }
        }
        return returnValue;
    }

    public void dispose() {
        this.outImage.dispose();
    }
}

