/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.handlers;

import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import de.rcenvironment.core.gui.workflow.editor.WorkflowZoomManager;
import de.rcenvironment.core.gui.workflow.view.WorkflowRunEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class SaveAsImageHandler
extends AbstractHandler {
    protected GraphicalViewer viewer;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof WorkflowEditor) {
            SaveAsImageHandler.saveWorkflowAsImage(((WorkflowEditor)activeEditor).getViewer(), activeEditor.getTitle().substring(0, activeEditor.getTitle().lastIndexOf(46)));
        } else if (activeEditor instanceof WorkflowRunEditor) {
            SaveAsImageHandler.saveWorkflowAsImage(((WorkflowRunEditor)activeEditor).getViewer(), activeEditor.getTitle().substring(0, activeEditor.getTitle().lastIndexOf(58)).replaceAll(":", "-"));
        }
        return null;
    }

    private static int getFormat(String path) {
        int format = 0;
        if (path.endsWith(".jpg")) {
            format = 4;
        } else if (path.endsWith(".png")) {
            format = 5;
        }
        return format;
    }

    private static String getPath(String filename) {
        String[] filterExtensions = new String[]{"*.bmp", "*.jpg", "*.png"};
        FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        fileDialog.setFilterExtensions(filterExtensions);
        fileDialog.setFilterIndex(2);
        fileDialog.setText("Save As Image");
        fileDialog.setOverwrite(true);
        fileDialog.setFileName(filename);
        return fileDialog.open();
    }

    private static void saveWorkflowAsImage(GraphicalViewer viewer, String filename) {
        String path = SaveAsImageHandler.getPath(filename);
        ScalableFreeformRootEditPart editPart = (ScalableFreeformRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
        editPart.getZoomManager().setZoom(1.0);
        IFigure figure = editPart.getLayer((Object)"Printable Layers");
        figure.setBackgroundColor(viewer.getControl().getBackground());
        boolean opaque = figure.isOpaque();
        figure.setOpaque(true);
        Rectangle bounds = figure.getBounds();
        Image image = new Image((Device)Display.getDefault(), bounds.width, bounds.height);
        SWTGraphics graphics = new SWTGraphics(new GC((Drawable)image));
        graphics.translate(-bounds.x, -bounds.y);
        figure.paint((Graphics)graphics);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        if (path != null) {
            imageLoader.save(path, SaveAsImageHandler.getFormat(path));
        }
        figure.setOpaque(opaque);
        graphics.dispose();
        image.dispose();
        if (editPart.getZoomManager() instanceof WorkflowZoomManager) {
            ((WorkflowZoomManager)editPart.getZoomManager()).restorePreviousZoomLevel();
        }
        viewer.getControl().setFocus();
    }
}

