/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.documentation;

import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ToolIntegrationDocumentationChooserDialog
extends Dialog {
    private Map<String, String> componentInstallationsWithDocumentation;
    private String selectedHash = null;
    private Table table;
    private String toolIdentifier;

    public ToolIntegrationDocumentationChooserDialog(Shell parentShell, Map<String, String> componentInstallationsWithDocumentation, String toolIdentifier) {
        super(parentShell);
        this.componentInstallationsWithDocumentation = componentInstallationsWithDocumentation;
        this.toolIdentifier = toolIdentifier;
    }

    protected void configureShell(Shell newShell) {
        String[] split;
        super.configureShell(newShell);
        this.setShellStyle(176);
        if (!this.toolIdentifier.isEmpty() && (split = this.toolIdentifier.split("/")).length > 1) {
            String componentName = split[0].substring(split[0].lastIndexOf(".") + 1);
            String componentVersion = "";
            int i = 1;
            while (i < split.length) {
                componentVersion = String.valueOf(componentVersion) + split[i] + "/";
                ++i;
            }
            componentVersion = componentVersion.substring(0, componentVersion.length() - 1);
            newShell.setText(StringUtils.format((String)"Select Documentation For Component %s (Version %s)", (Object[])new Object[]{componentName, componentVersion}));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        ServiceRegistryPublisherAccess serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
        Label informationLabel = new Label(container, 0);
        informationLabel.setText("There is more than one version of the components documentation available.\r\nPlease choose the desired version.");
        DistributedComponentKnowledgeService componentKnowledgeService = (DistributedComponentKnowledgeService)serviceRegistryAccess.getService(DistributedComponentKnowledgeService.class);
        componentKnowledgeService.getCurrentComponentKnowledge().getAllInstallations();
        this.table = new Table(container, 67584);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tblclmnInstancename = new TableColumn(this.table, 0);
        tblclmnInstancename.setText("Instance name");
        TableColumn tblclmnLocal = new TableColumn(this.table, 0);
        tblclmnLocal.setText("Source");
        TableColumn tblclmnHashValue = new TableColumn(this.table, 0);
        tblclmnHashValue.setText("Hash value");
        String[] items = new String[this.componentInstallationsWithDocumentation.size()];
        this.componentInstallationsWithDocumentation.keySet().toArray(items);
        for (String key : this.componentInstallationsWithDocumentation.keySet()) {
            TableItem item = new TableItem(this.table, 0);
            String nodeId = this.componentInstallationsWithDocumentation.get(key);
            boolean cached = false;
            if (nodeId.endsWith("(C)")) {
                nodeId = nodeId.substring(0, nodeId.length() - 3);
                cached = true;
            }
            LogicalNodeId identifier = NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)nodeId);
            item.setText(0, identifier.getAssociatedDisplayName());
            boolean localNode = ((PlatformService)serviceRegistryAccess.getService(PlatformService.class)).matchesLocalInstance((ResolvableNodeId)identifier);
            if (cached) {
                item.setText(1, "Cached");
            } else if (localNode) {
                item.setText(1, "Local");
            } else {
                item.setText(1, "Remote");
            }
            item.setText(2, key);
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ToolIntegrationDocumentationChooserDialog.this.selectedHash = ToolIntegrationDocumentationChooserDialog.this.table.getSelection()[0].getText(2);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.selectedHash = items[0];
        serviceRegistryAccess.dispose();
        tblclmnInstancename.pack();
        tblclmnLocal.pack();
        tblclmnHashValue.pack();
        return container;
    }

    protected void verify() {
        this.getButton(0).setEnabled(this.selectedHash != null);
    }

    public String getSelectedHash() {
        return this.selectedHash;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

