/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef.commands.Command;

public class WorkflowNodeDisEnableCommand
extends Command {
    private Set<WorkflowNode> nodes;
    private Set<WorkflowNode> nodesToggled = new HashSet<WorkflowNode>();

    public WorkflowNodeDisEnableCommand(Set<WorkflowNode> nodes) {
        this.nodes = nodes;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        boolean setEnabled = false;
        for (WorkflowNode node : this.nodes) {
            if (node.isEnabled()) continue;
            setEnabled = true;
            break;
        }
        for (WorkflowNode node : this.nodes) {
            if (node.isEnabled() == setEnabled) continue;
            this.nodesToggled.add(node);
            node.setEnabled(setEnabled);
        }
    }

    public void undo() {
        for (WorkflowNode node : this.nodesToggled) {
            node.setEnabled(!node.isEnabled());
        }
    }
}

