/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.spi.ContributedNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class InstanceComponentsInfoContributor
extends NetworkViewContributorBase {
    private static final int INSTANCE_ELEMENTS_PRIORITY = 10;
    private Image folderImage;
    private final Map<String, Image> componentIconCache;
    private Image componentFallbackImage;

    public InstanceComponentsInfoContributor() {
        ImageManager imageManager = ImageManager.getInstance();
        this.folderImage = imageManager.getSharedImage((ImageSource)StandardImages.FOLDER_16);
        this.componentFallbackImage = imageManager.getSharedImage((ImageSource)StandardImages.RCE_LOGO_16);
        this.componentIconCache = new HashMap<String, Image>();
    }

    @Override
    public int getRootElementsPriority() {
        return 0;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        return null;
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 10;
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext parentNode) {
        ArrayList<ComponentFolderNode> result = new ArrayList<ComponentFolderNode>(2);
        if (this.currentModel.componentKnowledge != null) {
            Collection publishedInstallations = this.currentModel.componentKnowledge.getPublishedInstallationsOnNode((ResolvableNodeId)parentNode.getNode().getNodeId());
            if (publishedInstallations != null && publishedInstallations.size() != 0) {
                result.add(new ComponentFolderNode(parentNode, true));
            }
            if (parentNode.isLocalNode()) {
                result.add(new ComponentFolderNode(parentNode, false));
            }
        }
        return result.toArray();
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        if (parentNode instanceof ComponentFolderNode) {
            ComponentFolderNode typedNode = (ComponentFolderNode)parentNode;
            if (typedNode.getTypeIsPublic()) {
                return true;
            }
            Collection<ComponentInstallation> localInstallations = this.determineLocalComponents(typedNode.getInstanceNode());
            return !localInstallations.isEmpty();
        }
        if (parentNode instanceof NetworkGraphNodeWithContext) {
            this.assertIsComponentNode((NetworkGraphNodeWithContext)parentNode);
            return false;
        }
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object parentNode) {
        ComponentFolderNode typedParentNode = (ComponentFolderNode)parentNode;
        NetworkGraphNodeWithContext instanceNode = typedParentNode.getInstanceNode();
        if (typedParentNode.getTypeIsPublic()) {
            Collection publishedInstallations = this.currentModel.componentKnowledge.getPublishedInstallationsOnNode((ResolvableNodeId)instanceNode.getNode().getNodeId());
            return this.createNodesForComponentInstallations(instanceNode, publishedInstallations);
        }
        Collection<ComponentInstallation> localInstallations = this.determineLocalComponents(instanceNode);
        return this.createNodesForComponentInstallations(instanceNode, localInstallations);
    }

    @Override
    public Object getParent(Object node) {
        if (node instanceof ComponentFolderNode) {
            return ((ComponentFolderNode)node).getInstanceNode();
        }
        if (node instanceof NetworkGraphNodeWithContext) {
            return ((NetworkGraphNodeWithContext)node).getParent();
        }
        return null;
    }

    @Override
    public String getText(Object node) {
        if (node instanceof ComponentFolderNode) {
            ComponentFolderNode typedNode = (ComponentFolderNode)node;
            if (typedNode.getTypeIsPublic()) {
                return "Published Components";
            }
            return "Local Components";
        }
        if (node instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)node;
            this.assertIsComponentNode(typedNode);
            ComponentInterface componentInterface = typedNode.getComponentInstallation().getComponentRevision().getComponentInterface();
            if (componentInterface.getVersion() != null && componentInterface.getIdentifier().startsWith("de.rcenvironment.integration.common.") || componentInterface.getIdentifier().startsWith("de.rcenvironment.integration.cpacs.")) {
                return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{componentInterface.getDisplayName(), componentInterface.getVersion()});
            }
            return StringUtils.format((String)"%s", (Object[])new Object[]{componentInterface.getDisplayName()});
        }
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        if (node instanceof ComponentFolderNode) {
            return this.folderImage;
        }
        if (node instanceof NetworkGraphNodeWithContext) {
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)node;
            this.assertIsComponentNode(typedNode);
            ComponentInstallation installation = typedNode.getComponentInstallation();
            if (installation != null) {
                String cacheKey = installation.getInstallationId();
                Image image = this.componentIconCache.get(cacheKey);
                if (image == null) {
                    try {
                        byte[] iconData = installation.getComponentRevision().getComponentInterface().getIcon16();
                        ImageDescriptor iDescr = ImageDescriptor.createFromImage((Image)new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(iconData)));
                        image = iDescr.createImage();
                    }
                    catch (RuntimeException runtimeException) {
                        image = this.componentFallbackImage;
                    }
                    this.componentIconCache.put(cacheKey, image);
                }
                return image;
            }
            LogFactory.getLog(this.getClass()).warn((Object)("Found a network view component node without a component installation: " + typedNode.getDisplayNameOfNode()));
            return this.componentFallbackImage;
        }
        throw this.newUnexpectedCallException();
    }

    @Override
    public void dispose() {
        for (Image image : this.componentIconCache.values()) {
            if (image == this.componentFallbackImage) continue;
            image.dispose();
        }
    }

    private Object[] createNodesForComponentInstallations(NetworkGraphNodeWithContext node, Collection<ComponentInstallation> installations) {
        Object[] result = new Object[installations.size()];
        int i = 0;
        for (ComponentInstallation installation : installations) {
            if (installation == null) {
                LogFactory.getLog(this.getClass()).warn((Object)("Skipping 'null' component installation for node " + node.getNode().getNodeId()));
                continue;
            }
            NetworkGraphNodeWithContext newChild = new NetworkGraphNodeWithContext(node, NetworkGraphNodeWithContext.Context.COMPONENT_INSTALLATION, (NetworkViewContributor)this);
            newChild.setComponentInstallation(installation);
            result[i++] = newChild;
        }
        Arrays.sort(result);
        return result;
    }

    private Collection<ComponentInstallation> determineLocalComponents(NetworkGraphNodeWithContext typedParentNode) {
        ArrayList localInstallations = this.currentModel.componentKnowledge.getLocalInstallations();
        Collection publishedLocalInstallations = this.currentModel.componentKnowledge.getPublishedInstallationsOnNode((ResolvableNodeId)typedParentNode.getNode().getNodeId());
        if (publishedLocalInstallations != null) {
            localInstallations = new ArrayList(localInstallations);
            localInstallations.removeAll(publishedLocalInstallations);
        }
        return localInstallations;
    }

    private void assertIsComponentNode(NetworkGraphNodeWithContext typedNode) {
        if (typedNode.getContext() != NetworkGraphNodeWithContext.Context.COMPONENT_INSTALLATION) {
            throw new IllegalStateException("Unexpected context: " + (Object)((Object)typedNode.getContext()));
        }
    }

    private class ComponentFolderNode
    implements ContributedNetworkViewNode {
        private final NetworkGraphNodeWithContext instanceNode;
        private final boolean typeIsPublic;

        ComponentFolderNode(NetworkGraphNodeWithContext instanceNode, boolean typeIsPublic) {
            this.instanceNode = instanceNode;
            this.typeIsPublic = typeIsPublic;
        }

        @Override
        public NetworkViewContributor getContributor() {
            return InstanceComponentsInfoContributor.this;
        }

        public NetworkGraphNodeWithContext getInstanceNode() {
            return this.instanceNode;
        }

        public boolean getTypeIsPublic() {
            return this.typeIsPublic;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getContributor().hashCode();
            result = this.instanceNode == null ? (result *= 31) : 31 * result + this.instanceNode.hashCode() + Boolean.valueOf(this.typeIsPublic).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentFolderNode other = (ComponentFolderNode)obj;
            if (this.typeIsPublic != other.typeIsPublic) {
                return false;
            }
            if (!this.getContributor().equals(other.getContributor())) {
                return false;
            }
            return !(this.instanceNode == null ? other.instanceNode != null : !this.instanceNode.equals(other.instanceNode));
        }
    }
}

