/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.AbstractInteractiveCommandConsole;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConsoleOutputAdapter
extends AbstractInteractiveCommandConsole {
    private static final String OUTPUT_TAB_REPLACEMENT = "    ";
    @Deprecated
    private boolean outputEnabled = true;
    private String activeUser;
    private String consolePromptString;
    private OutputStream out;
    private OutputStream err;
    private final CommandExecutionService commandExecutionService;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public SshConsoleOutputAdapter(CommandExecutionService commandExecutionService) {
        super(commandExecutionService);
        this.commandExecutionService = commandExecutionService;
    }

    public void onStart() {
    }

    public void addOutput(String output) {
        this.addOutput(output, true, true);
    }

    public void addOutput(String output, boolean lineBreak, boolean formatString) {
        if (formatString) {
            output = output.replace("\n", "\r\n");
            output = output.replaceAll("\t", OUTPUT_TAB_REPLACEMENT);
        }
        if (lineBreak) {
            output = String.valueOf(output) + "\r\n";
        }
        this.writeToConsole(output);
    }

    public void printHelp(CommandException ce) {
        this.commandExecutionService.printHelpText(false, false, (TextOutputReceiver)this);
    }

    public void printWelcome() {
        StringBuilder welcome = new StringBuilder();
        welcome.append("Welcome to the RCE SSH console, " + this.activeUser + "!");
        welcome.append("\r\nType \"help\" for a list of console commands. Please note that depending on your \r\naccount's security settings, you may not be able to use all commands.");
        welcome.append("\r\nType \"exit\" to end the current session.");
        this.addOutput(welcome.toString(), true, false);
    }

    public void printConsolePrompt() {
        if (this.consolePromptString == null) {
            String template = "\r\n%s@RCE: ";
            this.consolePromptString = StringUtils.format((String)template, (Object[])new Object[]{this.activeUser});
        }
        this.writeToConsole(this.consolePromptString);
    }

    private void writeToConsole(String output) {
        if (this.outputEnabled) {
            try {
                this.out.write(output.getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                this.logger.error((Object)("Could not print " + output), (Throwable)e);
            }
        } else {
            this.logger.warn((Object)("Tried to add output, but output was not enabled: " + output));
        }
    }

    public void destroy() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.logger.error((Object)("Error closing stdout stream of SSH shell: " + e.toString()));
        }
        try {
            this.err.close();
        }
        catch (IOException e) {
            this.logger.error((Object)("Error closing stderr stream of SSH shell: " + e.toString()));
        }
    }

    public void setOutputStream(OutputStream outParam) {
        this.out = outParam;
    }

    public void setErrorStream(OutputStream errParam) {
        this.err = errParam;
    }

    public void setActiveUser(String activeUser) {
        this.activeUser = activeUser;
    }

    public String getActiveUser() {
        return this.activeUser;
    }
}

