/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.bootstrap.profile;

import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;

public class BaseProfile {
    public static final String PROFILE_DIR_LOCK_FILE_NAME = "instance.lock";
    public static final String PROFILE_VERSION_FILE_NAME = "profile.version";
    public static final String PROFILE_INTERNAL_DATA_SUBDIR = "internal";
    private static final String CONFIGURED_PROFILE_TEMPLATE = "The configured profile directory \"%s\"";
    private static final String PROFILE_PATH_POINTS_TO_FILE_TEMPLATE = "The configured profile directory \"%s\" points to a file. It must either point to an existing profile directory or must be a path pointing to a not yet existing directory. Please check your launch settings.";
    private static final String PROFILE_WITH_CORRUPTED_VERSION_TEMPLATE = "The configured profile directory \"%s\" has a corrupted profile version number.";
    private static final String NO_PROFILE_AND_NOT_EMPTY_TEMPLATE = "The configured profile directory \"%s\" is neither an existing profile directory nor is it empty.";
    private static final String PROFILE_NOT_ACCESSIBLE_TEMPLATE = "The configured profile directory \"%s\" is either not readable and/or not writeable.  Choose another profile directory. (See the user guide for more information about the profile directory.)";
    private static final String NO_PROFILE_TEMPLATE = "The configured profile directory \"%s\" does not contain an existing profile.";
    protected int version;
    private File profileDirectory;
    private File internalDirectory = null;
    private FileLock lock;
    private RandomAccessFile randomAccessLockFile;

    protected BaseProfile(File profileDirectory, int version) {
        this.profileDirectory = profileDirectory;
        this.version = version;
    }

    public BaseProfile(File profileDirectory, int version, boolean create) throws ProfileException {
        this.profileDirectory = profileDirectory;
        this.version = version;
        this.init(create, false);
    }

    protected void init(boolean create, boolean allowLegacyProfile) throws ProfileException {
        if (this.profileDirectory.exists() && !this.profileDirectory.isDirectory()) {
            throw new ProfileException(StringUtils.format((String)PROFILE_PATH_POINTS_TO_FILE_TEMPLATE, (Object[])new Object[]{this.profileDirectory.getAbsolutePath()}));
        }
        this.internalDirectory = new File(this.profileDirectory, PROFILE_INTERNAL_DATA_SUBDIR);
        File versionFile = new File(this.internalDirectory, PROFILE_VERSION_FILE_NAME);
        if (versionFile.isFile()) {
            try {
                String content = new String(Files.readAllBytes(versionFile.toPath()));
                this.version = Integer.parseInt(content);
            }
            catch (IOException | NumberFormatException exception) {
                throw new ProfileException(StringUtils.format((String)PROFILE_WITH_CORRUPTED_VERSION_TEMPLATE, (Object[])new Object[]{this.profileDirectory.getAbsolutePath()}));
            }
        } else {
            String[] profileDirectoryContent;
            if (!(allowLegacyProfile || !this.profileDirectory.exists() || (profileDirectoryContent = this.profileDirectory.list()) != null && (profileDirectoryContent.length == 0 || profileDirectoryContent.length == 1 && profileDirectoryContent[0].equals("startup_logs")))) {
                throw new ProfileException(StringUtils.format((String)NO_PROFILE_AND_NOT_EMPTY_TEMPLATE, (Object[])new Object[]{this.profileDirectory.getAbsolutePath()}));
            }
            if (create) {
                try {
                    this.writeProfileVersionNumberToProfile(versionFile, this.version);
                }
                catch (IOException iOException) {
                    throw new ProfileException(StringUtils.format((String)PROFILE_NOT_ACCESSIBLE_TEMPLATE, (Object[])new Object[]{this.profileDirectory.getAbsolutePath()}));
                }
            } else {
                throw new ProfileException(StringUtils.format((String)NO_PROFILE_TEMPLATE, (Object[])new Object[]{this.profileDirectory.getAbsolutePath()}));
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof BaseProfile)) {
            return false;
        }
        try {
            return ((BaseProfile)other).getProfileDirectory().getCanonicalFile().equals(this.profileDirectory.getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        throw new IllegalStateException("Not implemented.");
    }

    public String getName() {
        return this.profileDirectory.getName();
    }

    public int getVersion() {
        return this.version;
    }

    public File getProfileDirectory() {
        return this.profileDirectory;
    }

    public File getInternalDirectory() {
        return this.internalDirectory;
    }

    private void writeProfileVersionNumberToProfile(File versionFile, int versionNumber) throws IOException {
        if (!versionFile.getParentFile().exists()) {
            versionFile.getParentFile().mkdirs();
            if (!versionFile.getParentFile().isDirectory()) {
                throw new IOException("Failed to initialize internal data directory " + this.internalDirectory.getAbsolutePath());
            }
        }
        if (!versionFile.exists()) {
            versionFile.createNewFile();
        }
        FileWriter fw = new FileWriter(versionFile, false);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(String.valueOf(versionNumber));
        bw.close();
    }

    public boolean attemptToLockProfileDirectory() throws ProfileException {
        File lockfile = new File(this.profileDirectory, PROFILE_DIR_LOCK_FILE_NAME);
        this.lock = null;
        try {
            lockfile.createNewFile();
            this.randomAccessLockFile = new RandomAccessFile(lockfile, "rw");
            this.lock = this.randomAccessLockFile.getChannel().tryLock();
        }
        catch (IOException | OverlappingFileLockException exception) {
            throw new ProfileException("Unexpected error when trying to acquire a file lock on " + lockfile);
        }
        return this.lock != null;
    }

    public boolean isLocked() {
        return this.lock != null && this.lock.isValid();
    }

    public void releaseLock() throws IOException {
        if (this.isLocked()) {
            this.lock.release();
        }
        if (this.randomAccessLockFile != null) {
            this.randomAccessLockFile.close();
        }
    }
}

