/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.registration.internal;

import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public class ComponentBundleListener
implements BundleListener {
    private static final Log LOGGER = LogFactory.getLog(ComponentBundleListener.class);

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 1) {
            ComponentBundleListener.handleBundle(event.getBundle());
        }
    }

    public static void handleBundle(Bundle bundle) {
        Dictionary headers;
        String componentEntry;
        if (!CommandLineArguments.isDoNotStartComponentsRequested() && (componentEntry = (String)(headers = bundle.getHeaders()).get("RCE-Component")) != null && Boolean.valueOf(componentEntry).booleanValue() && bundle.getState() == 4) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                LOGGER.error((Object)StringUtils.format((String)"Failed to start bundle '%s' that provides a workflow component", (Object[])new Object[]{bundle.getSymbolicName()}), (Throwable)e);
            }
        }
    }
}

