/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.configuration.PersistentSettingsService;
import de.rcenvironment.core.configuration.SecurePreferencesFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class WorkflowPlaceholderHandler
implements Serializable {
    public static final String PLACEHOLDER_PREFERENCES_KEY = "placeholder_UUID";
    private static final String WORKFLOW_PLACEHOLDER_PATH = "placeholderHistory" + File.separator + "Workflow_Placeholder_";
    private static final String COULD_NOT_LOAD_PASSWORD_FROM_STORE = "Could not load password from store!";
    private static final Log LOGGER = LogFactory.getLog(WorkflowPlaceholderHandler.class);
    private static final long serialVersionUID = 1L;
    private static final String PLACEHOLDERCOMPONENT_HISTORYFILE = "placeholderComponentHistory.json";
    private static final String PLACEHOLDERINSTANCE_HISTORYFILE = "placeholderInstanceHistory.json";
    private static PersistentSettingsService persistentSettingsService;
    private static List<String> encryptedPlaceholder;
    private static String placeholderPersistentSettingsUUID;
    private Map<String, List<String>> componentTypeHistory;
    private Map<String, List<String>> componentInstanceHistory;
    private Map<String, Map<String, String>> componentInstancePlaceholders;
    private Map<String, Map<String, String>> componentTypePlaceholders;
    private Map<String, String> placeholdersDataType;
    private Map<String, List<String>> componentInstancesOfType;
    private final String dot = ".";

    static {
        placeholderPersistentSettingsUUID = null;
    }

    @Deprecated
    public WorkflowPlaceholderHandler() {
    }

    public static WorkflowPlaceholderHandler createPlaceholderDescriptionFromWorkflowDescription(WorkflowDescription wd, String preferencesUUID) {
        WorkflowPlaceholderHandler weph = new WorkflowPlaceholderHandler();
        placeholderPersistentSettingsUUID = preferencesUUID;
        weph.setComponentInstancePlaceholders(new HashMap<String, Map<String, String>>());
        weph.setComponentTypePlaceholders(new HashMap<String, Map<String, String>>());
        weph.setComponentInstancesOfType(new HashMap<String, List<String>>());
        weph.setPlaceholdersDataType(new HashMap<String, String>());
        encryptedPlaceholder = new LinkedList<String>();
        for (WorkflowNode node : wd.getWorkflowNodes()) {
            ConfigurationDescription configDesc = node.getComponentDescription().getConfigurationDescription();
            for (String key : configDesc.getConfiguration().keySet()) {
                if (configDesc.isPlaceholderSet(key)) {
                    weph.addPlaceholder(configDesc.getActualConfigurationValue(key), node.getComponentDescription().getIdentifier(), node.getIdentifier());
                    String placeholder = WorkflowPlaceholderHandler.getNameOfPlaceholder(configDesc.getActualConfigurationValue(key));
                    String dataType = configDesc.getComponentConfigurationDefinition().getPlaceholderMetaDataDefinition().getDataType(placeholder);
                    if (dataType == null) continue;
                    weph.placeholdersDataType.put(String.valueOf(node.getName()) + weph.dot + placeholder, dataType);
                    continue;
                }
                if (!key.contains("_datatype_799ef365")) continue;
                String dataType = configDesc.getActualConfigurationValue(key);
                weph.placeholdersDataType.put(String.valueOf(node.getName()) + weph.dot + key.replace("_datatype_799ef365", ""), dataType);
            }
        }
        weph.setComponentInstanceHistory(new HashMap<String, List<String>>());
        weph.setComponentTypeHistory(new HashMap<String, List<String>>());
        if (!placeholderPersistentSettingsUUID.isEmpty()) {
            String id = String.valueOf(WORKFLOW_PLACEHOLDER_PATH) + placeholderPersistentSettingsUUID;
            Map compHist = persistentSettingsService.readMapWithStringList(String.valueOf(id) + File.separator + PLACEHOLDERINSTANCE_HISTORYFILE);
            if (compHist == null) {
                compHist = persistentSettingsService.readMapWithStringList(PLACEHOLDERINSTANCE_HISTORYFILE);
            }
            weph.setComponentInstanceHistory(compHist);
            Map compTypeHist = persistentSettingsService.readMapWithStringList(String.valueOf(id) + File.separator + PLACEHOLDERCOMPONENT_HISTORYFILE);
            if (compTypeHist == null) {
                compTypeHist = persistentSettingsService.readMapWithStringList(PLACEHOLDERINSTANCE_HISTORYFILE);
            }
            weph.setComponentTypeHistory(compTypeHist);
        }
        return weph;
    }

    public static void restorePasswords(Map<String, List<String>> componentHistory) {
        for (String key : componentHistory.keySet()) {
            List<String> currentList = componentHistory.get(key);
            if (currentList.isEmpty() || !currentList.get(0).equals("*")) continue;
            try {
                ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
                ISecurePreferences placeholderNode = prefs.node("placeholder");
                String path = key;
                String value = placeholderNode.get(path, "");
                LinkedList<String> list = new LinkedList<String>();
                list.add(value);
                componentHistory.put(key, list);
            }
            catch (IOException e) {
                LOGGER.error((Object)COULD_NOT_LOAD_PASSWORD_FROM_STORE, (Throwable)e);
            }
            catch (StorageException e) {
                LOGGER.error((Object)COULD_NOT_LOAD_PASSWORD_FROM_STORE, (Throwable)e);
            }
        }
    }

    public void addPlaceholder(String placeholder, String componentID, String componentUUID) {
        Matcher matcher = ComponentUtils.getMatcherForPlaceholder((String)placeholder);
        if (matcher.matches()) {
            List<String> componentInstanceList = this.componentInstancesOfType.get(componentID);
            if (componentInstanceList != null) {
                if (!componentInstanceList.contains(componentUUID)) {
                    componentInstanceList.add(componentUUID);
                }
            } else {
                componentInstanceList = new LinkedList<String>();
                componentInstanceList.add(componentUUID);
                this.componentInstancesOfType.put(componentID, componentInstanceList);
            }
            if (this.isGlobalPlaceholder(matcher)) {
                this.addPlaceholderKeyToMap(this.componentTypePlaceholders, componentID, matcher.group(7));
            } else {
                this.addPlaceholderKeyToMap(this.componentInstancePlaceholders, componentUUID, matcher.group(7));
            }
            if (matcher.group(2) != null && matcher.group(2).equals("*") || matcher.group(5) != null && matcher.group(5).equals("*")) {
                encryptedPlaceholder.add(String.valueOf(componentID) + "." + matcher.group(7));
            }
        }
    }

    private boolean isGlobalPlaceholder(Matcher matcherOfPlaceholder) {
        return matcherOfPlaceholder.group(2) != null && (matcherOfPlaceholder.group(2).equals("global") || matcherOfPlaceholder.group(5) != null && matcherOfPlaceholder.group(5).equals("global"));
    }

    private void addPlaceholderKeyToMap(Map<String, Map<String, String>> map, String key, String placeholderName) {
        Map<String, String> placeholderMap = map.get(key);
        if (placeholderMap == null) {
            placeholderMap = new HashMap<String, String>();
            map.put(key, placeholderMap);
        }
        if (!placeholderMap.containsKey(placeholderName)) {
            placeholderMap.put(placeholderName, null);
        }
    }

    public void setPlaceholderValue(String placeholder, String componentID, String componentUUID, String value, String wfID, boolean addToHistory) {
        if (placeholder.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
            Matcher matcher = ComponentUtils.getMatcherForPlaceholder((String)placeholder);
            if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + matcher.group(7)), encryptedPlaceholder)) {
                try {
                    value = new String(new Base64().encode(value.toString().getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((Object)("Could not encode placeholder " + placeholder), (Throwable)e);
                }
            }
            if (this.isGlobalPlaceholder(matcher)) {
                if (this.componentTypePlaceholders.get(componentID) != null) {
                    this.componentTypePlaceholders.get(componentID).put(matcher.group(7), value);
                }
            } else if (this.componentInstancePlaceholders.get(componentUUID) != null) {
                this.componentInstancePlaceholders.get(componentUUID).put(matcher.group(7), value);
            }
            String tail = "." + matcher.group(7);
            if (addToHistory) {
                String placeholderCompHistory = String.valueOf(wfID) + "." + componentID + tail;
                List<Object> placeholderCompHistoryList = null;
                if (this.componentTypeHistory != null && this.componentTypeHistory.get(placeholderCompHistory.toString()) != null) {
                    placeholderCompHistoryList = this.componentTypeHistory.get(placeholderCompHistory.toString());
                    if (placeholderCompHistoryList.contains(value)) {
                        placeholderCompHistoryList.remove(value);
                    }
                } else {
                    placeholderCompHistoryList = new LinkedList();
                }
                if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + matcher.group(7)), encryptedPlaceholder)) {
                    this.storePassword((Serializable)((Object)value), componentID, matcher.group(7), placeholderCompHistoryList);
                } else {
                    placeholderCompHistoryList.add(value.toString());
                }
                if (this.componentTypeHistory != null) {
                    this.componentTypeHistory.put(placeholderCompHistory, placeholderCompHistoryList);
                }
                String placeholderInstanceHistory = String.valueOf(componentUUID) + tail;
                List<Object> placeholderHistoryList = null;
                if (this.componentInstanceHistory != null && this.componentInstanceHistory.get(placeholderInstanceHistory) != null) {
                    placeholderHistoryList = this.componentInstanceHistory.get(placeholderInstanceHistory);
                    if (placeholderHistoryList.contains(value)) {
                        placeholderHistoryList.remove(value);
                    }
                } else {
                    placeholderHistoryList = new LinkedList();
                }
                if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + matcher.group(7)), encryptedPlaceholder)) {
                    this.storePassword((Serializable)((Object)value), componentUUID, matcher.group(7), placeholderHistoryList);
                } else {
                    placeholderHistoryList.add(value.toString());
                }
                if (this.componentInstanceHistory != null) {
                    this.componentInstanceHistory.put(placeholderInstanceHistory, placeholderHistoryList);
                }
            } else {
                String placeholderCompHistory = String.valueOf(wfID) + "." + componentID + tail;
                List<Object> placeholderCompHistoryList = null;
                if (this.componentTypeHistory != null && this.componentTypeHistory.get(placeholderCompHistory.toString()) != null) {
                    placeholderCompHistoryList = this.componentTypeHistory.get(placeholderCompHistory.toString());
                    if (placeholderCompHistoryList.contains(value)) {
                        placeholderCompHistoryList.remove(value);
                    }
                } else {
                    placeholderCompHistoryList = new LinkedList();
                }
                if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + matcher.group(7)), encryptedPlaceholder)) {
                    this.clearPassword(componentID, matcher.group(7), placeholderCompHistoryList);
                }
                String placeholderInstanceHistory = String.valueOf(componentUUID) + tail;
                List<Object> placeholderHistoryList = null;
                if (this.componentInstanceHistory != null && this.componentInstanceHistory.get(placeholderInstanceHistory) != null) {
                    placeholderHistoryList = this.componentInstanceHistory.get(placeholderInstanceHistory);
                    if (placeholderHistoryList.contains(value)) {
                        placeholderHistoryList.remove(value);
                    }
                } else {
                    placeholderHistoryList = new LinkedList();
                }
                if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + matcher.group(7)), encryptedPlaceholder)) {
                    this.clearPassword(componentUUID, matcher.group(7), placeholderHistoryList);
                }
            }
        }
    }

    private void clearPassword(String componentID, String placeholderName, List<String> placeholderList) {
        placeholderList.clear();
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
            ISecurePreferences placeholderNode = prefs.node("placeholder");
            String path = String.valueOf(componentID) + "." + placeholderName;
            placeholderNode.remove(path);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Could not remove password", (Throwable)e);
        }
    }

    private void storePassword(Serializable value, String componentID, String placeholderName, List<String> placeholderList) {
        placeholderList.clear();
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
            ISecurePreferences placeholderNode = prefs.node("placeholder");
            String path = String.valueOf(componentID) + "." + placeholderName;
            placeholderNode.put(path, value.toString(), true);
            placeholderList.add("*");
        }
        catch (StorageException e) {
            LOGGER.warn((Object)"Could not store password", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Could not store password", (Throwable)e);
        }
    }

    public void setGlobalPlaceholderValue(String placeholder, String componentID, String value, String wfID, boolean addToHistory) {
        if (placeholder.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
            Matcher matcher = ComponentUtils.getMatcherForPlaceholder((String)placeholder);
            if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + matcher.group(7)), encryptedPlaceholder)) {
                try {
                    value = new String(new Base64().encode(value.toString().getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warn((Object)("Could not encode placeholder " + placeholder), (Throwable)e);
                }
            }
            if (this.isGlobalPlaceholder(matcher) && this.componentTypePlaceholders.get(componentID) != null) {
                this.componentTypePlaceholders.get(componentID).put(matcher.group(7), value);
            }
            if (addToHistory) {
                String placeholderCompHistory = String.valueOf(wfID) + "." + componentID + "." + matcher.group(7);
                List<Object> placeholderCompHistoryList = null;
                if (this.componentTypeHistory != null && this.componentTypeHistory.get(placeholderCompHistory) != null) {
                    placeholderCompHistoryList = this.componentTypeHistory.get(placeholderCompHistory);
                    if (placeholderCompHistoryList.contains(value)) {
                        placeholderCompHistoryList.remove(value);
                    }
                } else {
                    placeholderCompHistoryList = new LinkedList<String>();
                }
                placeholderCompHistoryList.add(value.toString());
                if (this.componentTypeHistory != null) {
                    this.componentTypeHistory.put(placeholderCompHistory, placeholderCompHistoryList);
                }
            }
        }
    }

    public Serializable getValueByPlaceholderName(String placeholderName, String componentUUID) {
        Serializable result = null;
        if (this.componentInstancePlaceholders.containsKey(componentUUID)) {
            result = (Serializable)((Object)this.componentInstancePlaceholders.get(componentUUID).get(placeholderName));
        }
        return result;
    }

    public Serializable getGlobalValueByPlaceholderName(String placeholderName, String componentId) {
        Serializable result = null;
        if (this.componentTypePlaceholders.get(componentId) != null) {
            result = (Serializable)((Object)this.componentTypePlaceholders.get(componentId).get(placeholderName));
        }
        return result;
    }

    public Serializable getValueByPlaceholder(String placeholder, String componentID, String componentUUID) {
        Serializable result = null;
        if (placeholder.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}")) {
            Matcher matcher = ComponentUtils.getMatcherForPlaceholder((String)placeholder);
            if (this.isGlobalPlaceholder(matcher)) {
                if (this.componentTypePlaceholders.get(componentID) != null) {
                    result = (Serializable)((Object)this.componentTypePlaceholders.get(componentID).get(matcher.group(7)));
                }
            } else if (this.componentInstancePlaceholders.get(componentUUID) != null) {
                result = (Serializable)((Object)this.componentInstancePlaceholders.get(componentUUID).get(matcher.group(7)));
            }
        }
        return result;
    }

    public Serializable getValueByPlaceholder(String placeholder, String componentID) {
        Matcher matcher;
        Serializable result = null;
        if (placeholder.matches("\\$\\{((\\w*)(\\.))?((\\*)(\\.))?(.*)\\}") && this.isGlobalPlaceholder(matcher = ComponentUtils.getMatcherForPlaceholder((String)placeholder)) && this.componentTypePlaceholders.get(componentID) != null) {
            result = (Serializable)((Object)this.componentTypePlaceholders.get(componentID).get(matcher.group(7)));
        }
        return result;
    }

    public List<String> getComponentInstances(String componentID) {
        if (this.componentInstancesOfType != null) {
            return this.componentInstancesOfType.get(componentID);
        }
        return null;
    }

    public Set<String> getPlaceholderNameSetOfComponentInstance(String componentUUID) {
        if (this.componentInstancePlaceholders != null) {
            return this.componentInstancePlaceholders.get(componentUUID).keySet();
        }
        return null;
    }

    public Map<String, String> getPlaceholdersOfComponentType(String componentID) {
        return this.componentTypePlaceholders.get(componentID);
    }

    public Map<String, String> getPlaceholdersOfComponentInstance(String componentUUID) {
        return this.componentInstancePlaceholders.get(componentUUID);
    }

    public Set<String> getPlaceholderNameSetOfComponentID(String componentID) {
        if (this.componentTypePlaceholders.get(componentID) != null) {
            return this.componentTypePlaceholders.get(componentID).keySet();
        }
        return null;
    }

    public Set<String> getPlaceholderNamesOfComponentInstance(String componentUUID) {
        HashSet<String> result = new HashSet<String>();
        if (this.componentInstancePlaceholders != null) {
            String compKey = "";
            for (String compKeyIt : this.componentInstancesOfType.keySet()) {
                List<String> instances = this.componentInstancesOfType.get(compKeyIt);
                if (!instances.contains(componentUUID)) continue;
                compKey = compKeyIt;
            }
            for (String placeholderName : this.componentInstancePlaceholders.get(componentUUID).keySet()) {
                if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(compKey) + "." + placeholderName), encryptedPlaceholder)) {
                    result.add("${*." + placeholderName + "}");
                    continue;
                }
                result.add("${" + placeholderName + "}");
            }
        }
        return result;
    }

    public Set<String> getPlaceholderOfComponent(String componentID) {
        HashSet<String> result = new HashSet<String>();
        if (this.componentTypePlaceholders != null && this.componentTypePlaceholders.get(componentID) != null) {
            for (String placeholderName : this.componentTypePlaceholders.get(componentID).keySet()) {
                if (ComponentUtils.isEncryptedPlaceholder((String)(String.valueOf(componentID) + "." + placeholderName), encryptedPlaceholder)) {
                    result.add("${global.*." + placeholderName + "}");
                    continue;
                }
                result.add("${global." + placeholderName + "}");
            }
        }
        return result;
    }

    public Set<String> getIdentifiersOfPlaceholderContainingComponents() {
        if (this.componentInstancesOfType != null) {
            return this.componentInstancesOfType.keySet();
        }
        return null;
    }

    public static String getNameOfPlaceholder(String fullPlaceholder) {
        return ComponentUtils.getMatcherForPlaceholder((String)fullPlaceholder).group(7);
    }

    protected void bindPersistentSettingsService(PersistentSettingsService newPersistentSettingsService) {
        persistentSettingsService = newPersistentSettingsService;
    }

    public static List<String> getEncryptedPlaceholder() {
        return encryptedPlaceholder;
    }

    public String[] getInstancePlaceholderHistory(String placeholder, String componentUUID) {
        String[] result = new String[]{};
        if (this.componentInstanceHistory.containsKey(String.valueOf(componentUUID) + "." + placeholder)) {
            List<String> history = this.componentInstanceHistory.get(String.valueOf(componentUUID) + "." + placeholder);
            result = history.toArray(result);
        }
        return result;
    }

    public String[] getComponentPlaceholderHistory(String placeholder, String componentID, String wfID) {
        String[] result = new String[]{};
        if (this.componentTypeHistory.containsKey(String.valueOf(wfID) + "." + componentID + "." + placeholder)) {
            List<String> history = this.componentTypeHistory.get(String.valueOf(wfID) + "." + componentID + "." + placeholder);
            result = history.toArray(result);
        }
        return result;
    }

    public void saveHistory() {
        if (!placeholderPersistentSettingsUUID.isEmpty()) {
            String id = String.valueOf(WORKFLOW_PLACEHOLDER_PATH) + placeholderPersistentSettingsUUID;
            persistentSettingsService.saveMapWithStringList(this.componentTypeHistory, String.valueOf(id) + File.separator + PLACEHOLDERCOMPONENT_HISTORYFILE);
            persistentSettingsService.saveMapWithStringList(this.componentInstanceHistory, String.valueOf(id) + File.separator + PLACEHOLDERINSTANCE_HISTORYFILE);
        }
    }

    public void deletePlaceholderHistory(String componentDescriptionIdentifier, String placeholderName) {
        ISecurePreferences placeholderNode;
        ISecurePreferences prefs;
        HashSet<String> setToDelete = new HashSet<String>();
        for (String key : this.componentInstanceHistory.keySet()) {
            if (key == null || placeholderName == null || !key.endsWith(placeholderName)) continue;
            setToDelete.add(key);
        }
        for (String key : setToDelete) {
            if (!this.componentInstanceHistory.get(key).isEmpty() && !this.componentInstanceHistory.get(key).get(0).equals("*")) {
                try {
                    prefs = SecurePreferencesFactory.getSecurePreferencesStore();
                    placeholderNode = prefs.node("placeholder");
                    placeholderNode.remove(key);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Could not remove from storage", (Throwable)e);
                }
            }
            this.componentInstanceHistory.remove(key);
        }
        setToDelete = new HashSet();
        for (String key : this.componentTypeHistory.keySet()) {
            if (!key.endsWith(String.valueOf(componentDescriptionIdentifier) + "." + placeholderName)) continue;
            setToDelete.add(key);
        }
        for (String key : setToDelete) {
            if (!this.componentTypeHistory.get(key).isEmpty() && !this.componentTypeHistory.get(key).get(0).equals("*")) {
                try {
                    prefs = SecurePreferencesFactory.getSecurePreferencesStore();
                    placeholderNode = prefs.node("placeholder");
                    placeholderNode.remove(key);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Could not remove from storage", (Throwable)e);
                }
            }
            this.componentTypeHistory.remove(key);
        }
        this.saveHistory();
    }

    public String[] getOtherPlaceholderHistoryValues(String placeholderName) {
        LinkedList<String> proposals = new LinkedList<String>();
        for (String key : this.componentTypeHistory.keySet()) {
            if (!key.endsWith(placeholderName)) continue;
            for (String newValue : this.componentTypeHistory.get(key)) {
                if (proposals.contains(newValue)) continue;
                proposals.add(newValue);
            }
        }
        return proposals.toArray(new String[proposals.size()]);
    }

    public String getValueFromOtherComponentInWorkflow(String placeholderName, String identifier) {
        String resultValue = null;
        for (String key : this.componentTypeHistory.keySet()) {
            if (!key.endsWith(placeholderName) || !key.contains(identifier)) continue;
            List<String> allValues = this.componentTypeHistory.get(key);
            resultValue = allValues.get(allValues.size() - 1);
        }
        return resultValue;
    }

    public void deleteAllPasswordHistories() {
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getSecurePreferencesStore();
            ISecurePreferences node = prefs.node("placeholder");
            node.removeNode();
        }
        catch (IOException e) {
            LOGGER.error((Object)COULD_NOT_LOAD_PASSWORD_FROM_STORE, (Throwable)e);
        }
    }

    protected static void setPersistentSettingsService(PersistentSettingsService incPersistentSettingsService) {
        persistentSettingsService = incPersistentSettingsService;
    }

    public Map<String, List<String>> getComponentTypeHistory() {
        return this.componentTypeHistory;
    }

    public void setComponentTypeHistory(Map<String, List<String>> componentTypeHistory) {
        this.componentTypeHistory = componentTypeHistory;
    }

    public Map<String, List<String>> getComponentInstanceHistory() {
        return this.componentInstanceHistory;
    }

    public void setComponentInstanceHistory(Map<String, List<String>> componentInstanceHistory) {
        this.componentInstanceHistory = componentInstanceHistory;
    }

    public Map<String, Map<String, String>> getComponentInstancePlaceholders() {
        return this.componentInstancePlaceholders;
    }

    public void setComponentInstancePlaceholders(Map<String, Map<String, String>> componentInstancePlaceholders) {
        this.componentInstancePlaceholders = componentInstancePlaceholders;
    }

    public Map<String, Map<String, String>> getComponentTypePlaceholders() {
        return this.componentTypePlaceholders;
    }

    public void setComponentTypePlaceholders(Map<String, Map<String, String>> componentTypePlaceholders) {
        this.componentTypePlaceholders = componentTypePlaceholders;
    }

    public Map<String, List<String>> getComponentInstancesOfType() {
        return this.componentInstancesOfType;
    }

    public void setComponentInstancesOfType(Map<String, List<String>> componentInstancesOfType) {
        this.componentInstancesOfType = componentInstancesOfType;
    }

    public static void setPlaceholderPersistentSettingsUUID(String placeholderPersistentSettingsUUID) {
        WorkflowPlaceholderHandler.placeholderPersistentSettingsUUID = placeholderPersistentSettingsUUID;
    }

    public static String getPlaceholderPersistentSettingsUUID() {
        return placeholderPersistentSettingsUUID;
    }

    public void setPlaceholdersDataType(Map<String, String> componentDataType) {
        this.placeholdersDataType = componentDataType;
    }

    public Map<String, String> getPlaceholdersDataType() {
        return this.placeholdersDataType;
    }

    public static boolean isActivePlaceholder(String instancePlaceholder, ConfigurationDescription configDesc) {
        Set configKeys = configDesc.getComponentConfigurationDefinition().getConfigurationKeys();
        Set activeConfigKeys = configDesc.getActiveConfigurationDefinition().getConfigurationKeys();
        boolean isActivePlaceholder = false;
        for (String configKey : configDesc.getConfiguration().keySet()) {
            String configValue;
            if (!activeConfigKeys.contains(configKey) && configKeys.contains(configKey) || !configDesc.isPlaceholderSet(configKey) || !(configValue = configDesc.getActualConfigurationValue(configKey)).contains(instancePlaceholder)) continue;
            isActivePlaceholder = true;
            break;
        }
        return isActivePlaceholder;
    }
}

