/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.api;

import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class WorkflowDescriptionValidationResult {
    private boolean succeeded;
    private LogicalNodeId missingControllerNodeId = null;
    private Map<String, LogicalNodeId> missingComponentsNodeIds = new HashMap<String, LogicalNodeId>();

    public WorkflowDescriptionValidationResult(boolean validationSucceeded, LogicalNodeId missingControllerNodeId, Map<String, LogicalNodeId> missingComponentsNodeIds) {
        this.succeeded = validationSucceeded;
        this.missingControllerNodeId = missingControllerNodeId;
        this.missingComponentsNodeIds = missingComponentsNodeIds;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public LogicalNodeId getMissingControllerNodeId() {
        return this.missingControllerNodeId;
    }

    public Map<String, LogicalNodeId> getMissingComponentsNodeIds() {
        return this.missingComponentsNodeIds;
    }

    public String toString() {
        StringBuilder causeLogMsg = new StringBuilder();
        if (this.missingControllerNodeId != null) {
            causeLogMsg.append(StringUtils.format((String)"target instance for workflow controller unknown: %s", (Object[])new Object[]{this.missingControllerNodeId}));
        }
        for (String compName : this.missingComponentsNodeIds.keySet()) {
            if (causeLogMsg.length() > 0) {
                causeLogMsg.append(", ");
            }
            causeLogMsg.append(StringUtils.format((String)"target instance for component unknown: %s -> %s", (Object[])new Object[]{compName, this.missingComponentsNodeIds.get(compName)}));
        }
        return causeLogMsg.toString().trim();
    }

    public static WorkflowDescriptionValidationResult createResultForFailure(LogicalNodeId missingControllerNodeId, Map<String, LogicalNodeId> missingComponentsNodeIds) {
        return new WorkflowDescriptionValidationResult(false, missingControllerNodeId, missingComponentsNodeIds);
    }

    public static WorkflowDescriptionValidationResult createResultForSuccess() {
        return new WorkflowDescriptionValidationResult(true, null, null);
    }
}

