/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.scripting;

import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.scripting.python.PythonOutputWriter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public final class WorkflowConsoleForwardingWriter
extends PythonOutputWriter {
    private static final String CONSOLE_ROW_TYPE_NOT_SUPPORTED = "Console row type not supported: ";
    private ComponentLog componentLog;
    private final ConsoleRow.Type consoleType;
    private final CountDownLatch printingLinesFinishedLatch = new CountDownLatch(1);

    public WorkflowConsoleForwardingWriter(Object lock, ComponentLog componentLog, ConsoleRow.Type type) {
        this(lock, componentLog, type, null);
    }

    public WorkflowConsoleForwardingWriter(Object lock, ComponentLog componentLog, ConsoleRow.Type consoleType, File logFile) {
        super(lock, logFile);
        this.componentLog = componentLog;
        if (consoleType != ConsoleRow.Type.TOOL_OUT && consoleType != ConsoleRow.Type.TOOL_ERROR) {
            throw new IllegalArgumentException(CONSOLE_ROW_TYPE_NOT_SUPPORTED + consoleType);
        }
        this.consoleType = consoleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        super.close();
        Object object = this.lock;
        synchronized (object) {
            this.executionQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    WorkflowConsoleForwardingWriter.this.componentLog = null;
                }
            });
        }
    }

    protected void onNewLineToForward(String line) {
        if (line == null) {
            this.printingLinesFinishedLatch.countDown();
        } else {
            switch (this.consoleType) {
                case TOOL_OUT: {
                    this.componentLog.toolStdout(line);
                    break;
                }
                case TOOL_ERROR: {
                    this.componentLog.toolStderr(line);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(CONSOLE_ROW_TYPE_NOT_SUPPORTED + this.consoleType);
                }
            }
        }
    }

    public void awaitPrintingLinesFinished() throws InterruptedException {
        this.printingLinesFinishedLatch.await();
    }
}

