/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.api.LiveNetworkIdResolutionService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.communication.protocol.ProtocolConstants;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.api.CallbackProxyService;
import de.rcenvironment.core.communication.rpc.api.CallbackService;
import de.rcenvironment.core.communication.rpc.api.RemoteServiceCallSenderService;
import de.rcenvironment.core.communication.rpc.internal.CallbackUtils;
import de.rcenvironment.core.communication.rpc.spi.ServiceProxyFactory;
import de.rcenvironment.core.toolkitbridge.api.StaticToolkitHolder;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.Assertions;
import de.rcenvironment.toolkit.modules.concurrency.api.ThreadGuard;
import de.rcenvironment.toolkit.modules.statistics.api.CounterCategory;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsFilterLevel;
import de.rcenvironment.toolkit.modules.statistics.api.StatisticsTrackerService;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ServiceProxyFactoryImpl
implements ServiceProxyFactory {
    private static final String ASSERT_MUST_NOT_BE_NULL = " must not be null!";
    private static final long serialVersionUID = -4239349616520603192L;
    private static final Log sharedLogInstance = LogFactory.getLog(ServiceProxyFactoryImpl.class);
    private static final long ID_RESOLUTION_MAX_RETRIES = 5L;
    private static final long ID_RESOLUTION_RETRY_WAIT_MSEC = 100L;
    private PlatformService platformService;
    private CallbackService callbackService;
    private CallbackProxyService callbackProxyService;
    private RemoteServiceCallSenderService remoteServiceCallService;
    private CounterCategory parameterTypesCounter;
    private CounterCategory methodCallCounter;
    private LiveNetworkIdResolutionService idResolutionService;

    public ServiceProxyFactoryImpl() {
        StatisticsTrackerService statisticsService = (StatisticsTrackerService)StaticToolkitHolder.getServiceWithUnitTestFallback(StatisticsTrackerService.class);
        this.methodCallCounter = statisticsService.getCounterCategory("Remote service calls (sent): service methods", StatisticsFilterLevel.RELEASE);
        this.parameterTypesCounter = statisticsService.getCounterCategory("Remote service calls (sent): parameter types", StatisticsFilterLevel.DEVELOPMENT);
    }

    public void bindPlatformService(PlatformService newInstance) {
        this.platformService = newInstance;
    }

    public void bindLiveNetworkIdResolutionService(LiveNetworkIdResolutionService newInstance) {
        this.idResolutionService = newInstance;
    }

    public void bindCallbackService(CallbackService newInstance) {
        this.callbackService = newInstance;
    }

    public void bindCallbackProxyService(CallbackProxyService newInstance) {
        this.callbackProxyService = newInstance;
    }

    public void bindRemoteServiceCallService(RemoteServiceCallSenderService newInstance) {
        this.remoteServiceCallService = newInstance;
    }

    @Override
    public Object createServiceProxy(ResolvableNodeId nodeId, Class<?> serviceIface, Class<?>[] ifaces) {
        Assertions.isDefined((Object)nodeId, (String)"The identifier of the requested platform must not be null!");
        Assertions.isDefined(serviceIface, (String)"The interface of the requested service must not be null!");
        InvocationHandler handler = new InvocationHandler(serviceIface, nodeId){
            private final PlatformService ps;
            private final CallbackService cs;
            private final CallbackProxyService cps;
            private final Class<?> myService;
            private final ResolvableNodeId destinationNodeId;
            private LogicalNodeSessionId destinationLogicalNodeSessionId;
            {
                this.ps = ServiceProxyFactoryImpl.this.platformService;
                this.cs = ServiceProxyFactoryImpl.this.callbackService;
                this.cps = ServiceProxyFactoryImpl.this.callbackProxyService;
                this.myService = clazz;
                this.destinationNodeId = resolvableNodeId;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
                ThreadGuard.checkForForbiddenThread();
                1 var4_4 = this;
                synchronized (var4_4) {
                    if (this.destinationLogicalNodeSessionId == null) {
                        this.resolveDestinationNodeIdOrFail();
                    }
                }
                if (ServiceProxyFactoryImpl.this.remoteServiceCallService == null) {
                    throw new RemoteOperationException("RemoteServiceCallService was null");
                }
                if (ServiceProxyFactoryImpl.this.methodCallCounter.isEnabled()) {
                    ServiceProxyFactoryImpl.this.methodCallCounter.count(StringUtils.format((String)"%s#%s(...)", (Object[])new Object[]{this.myService.getName(), method.getName()}));
                }
                ArrayList<Serializable> parameterList = new ArrayList<Serializable>();
                if (parameters != null) {
                    Object[] objectArray = parameters;
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object parameter = objectArray[n2];
                        if (ServiceProxyFactoryImpl.this.parameterTypesCounter.isEnabled()) {
                            ServiceProxyFactoryImpl.this.parameterTypesCounter.countClass(parameter);
                        }
                        parameterList.add((Serializable)CallbackUtils.handleCallbackObject(parameter, this.destinationLogicalNodeSessionId.convertToInstanceNodeSessionId(), this.cs));
                        ++n2;
                    }
                }
                ServiceCallRequest serviceCallRequest = new ServiceCallRequest(this.destinationLogicalNodeSessionId, this.ps.getLocalDefaultLogicalNodeSessionId(), this.myService.getCanonicalName(), method.getName(), parameterList);
                Object returnValue = ServiceProxyFactoryImpl.this.remoteServiceCallService.performRemoteServiceCallAsProxy(serviceCallRequest);
                if (returnValue != null) {
                    returnValue = CallbackUtils.handleCallbackProxy(returnValue, this.cs, this.cps);
                }
                return returnValue;
            }

            private void resolveDestinationNodeIdOrFail() throws RemoteOperationException {
                int retries = 0;
                while (true) {
                    try {
                        this.destinationLogicalNodeSessionId = ServiceProxyFactoryImpl.this.idResolutionService.resolveToLogicalNodeSessionId(this.destinationNodeId);
                        if (retries > 0) {
                            sharedLogInstance.debug((Object)("Resolved service call destination id " + this.destinationNodeId + " after " + retries + " failed attempts"));
                        }
                        return;
                    }
                    catch (IdentifierException e) {
                        if ((long)retries < 5L) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                throw new RemoteOperationException("Interrupted while waiting to retry id resolution for " + this.destinationNodeId);
                            }
                            ++retries;
                            continue;
                        }
                        sharedLogInstance.debug((Object)("Converting id resolution exception to a " + RemoteOperationException.class.getSimpleName() + " of type " + (Object)((Object)ProtocolConstants.ResultCode.NO_ROUTE_TO_DESTINATION_AT_SENDER) + ": " + e.toString()));
                        throw new RemoteOperationException(StringUtils.format((String)"%s; the destination instance was %s", (Object[])new Object[]{ProtocolConstants.ResultCode.NO_ROUTE_TO_DESTINATION_AT_SENDER.toString(), this.destinationNodeId}));
                    }
                    break;
                }
            }
        };
        if (ifaces == null) {
            return Proxy.newProxyInstance(serviceIface.getClassLoader(), new Class[]{serviceIface}, handler);
        }
        Class[] allIfaces = new Class[ifaces.length + 1];
        allIfaces[0] = serviceIface;
        System.arraycopy(ifaces, 0, allIfaces, 1, ifaces.length);
        return Proxy.newProxyInstance(serviceIface.getClassLoader(), allIfaces, handler);
    }
}

