/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.transport.jms.common.AbstractJmsQueueConsumer;
import de.rcenvironment.core.communication.transport.jms.common.JmsProtocolUtils;
import de.rcenvironment.core.communication.transport.spi.MessageChannelEndpointHandler;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;

public final class RequestInboxConsumer
extends AbstractJmsQueueConsumer
implements Runnable {
    private static final long SLOW_DISPATCH_LOGGING_THRESHOLD_MSEC = 25000L;
    private final MessageChannelEndpointHandler endpointHandler;
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final boolean verboseRequestLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"NetworkRequests");

    public RequestInboxConsumer(String queueName, Connection connection, MessageChannelEndpointHandler endpointHandler) throws JMSException {
        super(connection, queueName);
        this.endpointHandler = endpointHandler;
    }

    @Override
    @TaskDescription(value="JMS Network Transport: Incoming request listener")
    public void run() {
        super.run();
    }

    @Override
    protected void dispatchMessage(final Message message, final Connection jmsConnection) {
        this.threadPool.execute(new Runnable(){

            @Override
            @TaskDescription(value="JMS Network Transport: Dispatch incoming request")
            public void run() {
                try (Session responseSession = jmsConnection.createSession(false, 1);){
                    RequestInboxConsumer.this.dispatchMessageInternal(message, responseSession);
                }
                catch (JMSException e) {
                    RequestInboxConsumer.this.log.error((Object)("JMS exception in response session for request from queue " + RequestInboxConsumer.this.queueName + ": " + e.toString()));
                }
            }
        });
    }

    private void dispatchMessageInternal(Message message, Session session) {
        String messageType;
        try {
            messageType = message.getStringProperty("messageType");
        }
        catch (JMSException jMSException) {
            this.log.warn((Object)"Received message with undefined message type");
            return;
        }
        try {
            if ("request".equals(messageType)) {
                NetworkRequest request = JmsProtocolUtils.createNetworkRequestFromMessage(message);
                int requestPayloadSize = request.getContentBytes().length;
                if (this.verboseRequestLoggingEnabled) {
                    this.log.debug((Object)StringUtils.format((String)"Received request  %s: type %s, payload length %d", (Object[])new Object[]{request.getRequestId(), request.getMessageType(), requestPayloadSize}));
                }
                if (requestPayloadSize >= 0x100000) {
                    this.log.debug((Object)StringUtils.format((String)"Received large network request %s from %s: type %s, payload length %d", (Object[])new Object[]{request.getRequestId(), request.accessMetaData().getSender(), request.getMessageType(), requestPayloadSize}));
                }
                String senderIdString = request.accessMetaData().getSenderIdString();
                long startTime = System.currentTimeMillis();
                NetworkResponse response = this.endpointHandler.onRawRequestReceived(request, senderIdString);
                long durationMsec = System.currentTimeMillis() - startTime;
                if (durationMsec > 25000L) {
                    this.log.debug((Object)StringUtils.format((String)"Slow dispatch (%,d msec) for incoming request of type %s", (Object[])new Object[]{durationMsec, request.getMessageType()}));
                }
                try {
                    Message jmsResponse = JmsProtocolUtils.createMessageFromNetworkResponse(response, session);
                    String messageId = message.getJMSMessageID();
                    if (messageId == null) {
                        this.log.error((Object)"Unexpected state: null JMS message id");
                        return;
                    }
                    jmsResponse.setJMSCorrelationID(messageId);
                    if (this.verboseRequestLoggingEnabled) {
                        this.log.debug((Object)StringUtils.format((String)"Sending response  %s: payload length %d", (Object[])new Object[]{request.getRequestId(), response.getContentBytes().length}));
                    }
                    JmsProtocolUtils.sendWithTransientProducer(session, jmsResponse, message.getJMSReplyTo());
                }
                catch (JMSException e) {
                    this.log.debug((Object)StringUtils.format((String)"Error sending JMS response after successful request dispatch; most likely, the remote side has closed the connection after sending the request (request type: %s, exception: %s)", (Object[])new Object[]{request.getMessageType(), e.toString()}));
                }
            } else if ("shutdown.channel".equals(messageType)) {
                String closingChannelId = message.getStringProperty("channel.id");
                this.endpointHandler.onInboundChannelClosing(closingChannelId);
            } else {
                this.log.warn((Object)("Received message of unhandled type " + messageType + " from queue " + this.queueName));
            }
        }
        catch (JMSException e) {
            this.log.warn((Object)("Error while dispatching message of type " + messageType), (Throwable)e);
        }
        catch (CommunicationException e) {
            this.log.warn((Object)("Error while dispatching message of type " + messageType), (Throwable)e);
        }
    }
}

